/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.lib.terminalemulator.Attr;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.Term;

class Screen
extends JComponent
implements Accessible {
    private final Term term;
    private static final boolean DEBUG = false;
    private Set<AWTKeyStroke> original_fwd_keys = null;
    private Set<AWTKeyStroke> original_bwd_keys = null;
    private AccessibleContext accessible_context;
    private AccessibleScreenText accessible_screen_text;
    private int oldPos;

    public Screen(Term term, int dx, int dy) {
        this.term = term;
        Dimension dim = new Dimension(dx, dy);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setGrabTab(true);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
    }

    public boolean OLD_isManagingFocus() {
        return true;
    }

    private void setGrabTab(boolean grabTab) {
        if (this.original_fwd_keys == null) {
            this.original_fwd_keys = new HashSet<AWTKeyStroke>();
            this.original_fwd_keys.add(AWTKeyStroke.getAWTKeyStroke(9, 2));
            this.original_bwd_keys = new HashSet<AWTKeyStroke>();
            this.original_bwd_keys.add(AWTKeyStroke.getAWTKeyStroke(9, 3));
        }
        if (grabTab) {
            this.setFocusTraversalKeys(0, this.original_fwd_keys);
            this.setFocusTraversalKeys(1, this.original_bwd_keys);
        } else {
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.term.do_paint(g);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(1000, 1000);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessible_context == null) {
            this.accessible_context = new AccessibleScreen();
        }
        return this.accessible_context;
    }

    void possiblyUpdateCaretText() {
        if (this.accessible_screen_text == null) {
            return;
        }
        int pos = this.term.CoordToPosition(this.term.getCursorCoord());
        this.accessible_context.firePropertyChange("AccessibleText", null, pos);
        this.accessible_context.firePropertyChange("AccessibleCaret", pos, this.oldPos);
        this.oldPos = pos;
    }

    protected class AccessibleScreen
    extends JComponent.AccessibleJComponent {
        protected AccessibleScreen() {
            super(Screen.this);
        }

        @Override
        public String getAccessibleDescription() {
            return "Terminal emulator";
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        public AccessibleText getAccessibleText() {
            if (Screen.this.accessible_screen_text == null) {
                Screen.this.accessible_screen_text = new AccessibleScreenText();
            }
            return Screen.this.accessible_screen_text;
        }
    }

    protected class AccessibleScreenText
    implements AccessibleText {
        private int last_attr;
        private MutableAttributeSet last_as;

        AccessibleScreenText() {
        }

        @Override
        public int getCaretPosition() {
            return Screen.this.term.CoordToPosition(Screen.this.term.getCursorCoord());
        }

        @Override
        public AttributeSet getCharacterAttribute(int index) {
            int attr;
            Coord c = Screen.this.term.PositionToCoord(index);
            if (c == null) {
                return null;
            }
            BCoord b = c.toBCoord(Screen.this.term.firsta());
            try {
                Line l = Screen.this.term.buf().lineAt(b.row);
                int[] attrs = l.attrArray();
                attr = attrs[b.col];
            }
            catch (Exception x) {
                return null;
            }
            if (attr == this.last_attr) {
                return this.last_as;
            }
            SimpleAttributeSet as = new SimpleAttributeSet();
            if (Attr.UNDERSCORE.isSet(attr)) {
                as.addAttribute(StyleConstants.Underline, Boolean.TRUE);
            }
            if (Attr.BRIGHT.isSet(attr)) {
                as.addAttribute(StyleConstants.Bold, Boolean.TRUE);
            }
            boolean reverse = Attr.REVERSE.isSet(attr);
            Color color = Screen.this.term.foregroundColor(reverse, attr);
            if (color != Color.black) {
                as.addAttribute(StyleConstants.Foreground, color);
            }
            if ((color = Screen.this.term.backgroundColor(reverse, attr)) != null) {
                as.addAttribute(StyleConstants.Background, color);
            }
            this.last_attr = attr;
            this.last_as = as;
            return as;
        }

        @Override
        public Rectangle getCharacterBounds(int index) {
            return Screen.this.term.getCharacterBounds(Screen.this.term.PositionToCoord(index));
        }

        @Override
        public int getCharCount() {
            return Screen.this.term.getCharCount();
        }

        @Override
        public int getSelectionStart() {
            Extent x = Screen.this.term.getSelectionExtent();
            if (x == null) {
                return this.getCaretPosition();
            }
            return Screen.this.term.CoordToPosition(x.begin);
        }

        @Override
        public int getSelectionEnd() {
            Extent x = Screen.this.term.getSelectionExtent();
            if (x == null) {
                return this.getCaretPosition();
            }
            return Screen.this.term.CoordToPosition(x.end);
        }

        @Override
        public String getSelectedText() {
            return Screen.this.term.getSelectedText();
        }

        private String getHelper(int part, BCoord b) {
            if (b == null) {
                return null;
            }
            Line l = Screen.this.term.buf().lineAt(b.row);
            switch (part) {
                case 1: {
                    return String.valueOf(l.charAt(b.col));
                }
                case 2: {
                    BExtent bword = Screen.this.term.buf().find_word(Screen.this.term.getWordDelineator(), b);
                    Extent word = bword.toExtent(Screen.this.term.firsta());
                    return Screen.this.term.textWithin(word.begin, word.end);
                }
                case 3: {
                    return l.toString();
                }
            }
            return null;
        }

        @Override
        public String getAfterIndex(int part, int index) {
            Coord c = Screen.this.term.PositionToCoord(index);
            if (c == null) {
                return null;
            }
            BCoord b = c.toBCoord(Screen.this.term.firsta());
            b = Screen.this.term.buf().advance(b);
            return this.getHelper(part, b);
        }

        @Override
        public String getAtIndex(int part, int index) {
            Coord c = Screen.this.term.PositionToCoord(index);
            if (c == null) {
                return null;
            }
            BCoord b = c.toBCoord(Screen.this.term.firsta());
            return this.getHelper(part, b);
        }

        @Override
        public String getBeforeIndex(int part, int index) {
            Coord c = Screen.this.term.PositionToCoord(index);
            if (c == null) {
                return null;
            }
            BCoord b = c.toBCoord(Screen.this.term.firsta());
            b = Screen.this.term.buf().backup(b);
            return this.getHelper(part, b);
        }

        @Override
        public int getIndexAtPoint(Point p) {
            BCoord v = Screen.this.term.toViewCoord(p);
            BCoord b = Screen.this.term.toBufCoords(v);
            return Screen.this.term.CoordToPosition(new Coord(b, Screen.this.term.firsta()));
        }
    }
}

