/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.primefaces;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.primefaces.Bundle;
import org.netbeans.modules.web.primefaces.PrimefacesImplementation;
import org.netbeans.modules.web.primefaces.ui.PrimefacesCustomizerPanel;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class PrimefacesCustomizer
implements JsfComponentCustomizer {
    private static final RequestProcessor RP = new RequestProcessor(PrimefacesCustomizer.class);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private PrimefacesCustomizerPanel panel;
    private Future<Boolean> result = null;
    private boolean fixedLibrary = false;

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    private synchronized PrimefacesCustomizerPanel getPanel() {
        if (this.panel == null) {
            this.panel = new PrimefacesCustomizerPanel(this);
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Preferences preferences = PrimefacesImplementation.getPrimefacesPreferences();
        String primefacesLib = preferences.get("preferred-library", "");
        if (LibraryManager.getDefault().getLibrary(primefacesLib) != null) {
            return true;
        }
        PrimefacesCustomizer primefacesCustomizer = this;
        synchronized (primefacesCustomizer) {
            if (this.result == null) {
                this.result = RP.submit((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (Library library : LibraryManager.getDefault().getLibraries()) {
                            List content;
                            if (!"j2se".equals(library.getType()) || !PrimefacesImplementation.isValidPrimefacesLibrary(content = library.getContent("classpath"))) continue;
                            this.refreshParentValidation();
                            return true;
                        }
                        this.refreshParentValidation();
                        return false;
                    }

                    private void refreshParentValidation() {
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                PrimefacesCustomizer.this.fireChange();
                            }
                        });
                    }
                });
            } else {
                if (!this.result.isDone()) {
                    return false;
                }
                try {
                    return this.result.get() != false || this.fixedLibrary;
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return false;
    }

    public String getErrorMessage() {
        if (this.result == null && !this.isValid() || this.result != null && !this.result.isDone()) {
            return Bundle.PrimefacesCustomizer_err_searching_primefaces_library();
        }
        return this.getPanel().getErrorMessage();
    }

    public String getWarningMessage() {
        return this.getPanel().getWarningMessage();
    }

    public void saveConfiguration() {
        Preferences preferences = PrimefacesImplementation.getPrimefacesPreferences();
        if (this.panel.getPrimefacesLibrary() != null) {
            preferences.put("preferred-library", this.panel.getPrimefacesLibrary().getName());
        }
    }

    public HelpCtx getHelpCtx() {
        return this.panel.getHelpCtx();
    }

    public void setFixedLibrary(boolean fixed) {
        this.fixedLibrary = fixed;
    }

    public void fireChange() {
        this.changeSupport.fireChange();
    }
}

