/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeliveredArtifact;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="artifactType")
@JsonFilter(value="explicitlySetFilter")
public final class ContainerRegistryDeliveredArtifact
extends DeliveredArtifact {
    @JsonProperty(value="deliveredArtifactHash")
    private final String deliveredArtifactHash;
    @JsonProperty(value="imageUri")
    private final String imageUri;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ContainerRegistryDeliveredArtifact(String deployArtifactId, String outputArtifactName, String deliveredArtifactHash, String imageUri) {
        super(deployArtifactId, outputArtifactName);
        this.deliveredArtifactHash = deliveredArtifactHash;
        this.imageUri = imageUri;
    }

    public String getDeliveredArtifactHash() {
        return this.deliveredArtifactHash;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerRegistryDeliveredArtifact(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", deliveredArtifactHash=").append(String.valueOf(this.deliveredArtifactHash));
        sb.append(", imageUri=").append(String.valueOf(this.imageUri));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerRegistryDeliveredArtifact)) {
            return false;
        }
        ContainerRegistryDeliveredArtifact other = (ContainerRegistryDeliveredArtifact)((Object)o);
        return Objects.equals(this.deliveredArtifactHash, other.deliveredArtifactHash) && Objects.equals(this.imageUri, other.imageUri) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deliveredArtifactHash == null ? 43 : this.deliveredArtifactHash.hashCode());
        result = result * 59 + (this.imageUri == null ? 43 : this.imageUri.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="deployArtifactId")
        private String deployArtifactId;
        @JsonProperty(value="outputArtifactName")
        private String outputArtifactName;
        @JsonProperty(value="deliveredArtifactHash")
        private String deliveredArtifactHash;
        @JsonProperty(value="imageUri")
        private String imageUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder deployArtifactId(String deployArtifactId) {
            this.deployArtifactId = deployArtifactId;
            this.__explicitlySet__.add("deployArtifactId");
            return this;
        }

        public Builder outputArtifactName(String outputArtifactName) {
            this.outputArtifactName = outputArtifactName;
            this.__explicitlySet__.add("outputArtifactName");
            return this;
        }

        public Builder deliveredArtifactHash(String deliveredArtifactHash) {
            this.deliveredArtifactHash = deliveredArtifactHash;
            this.__explicitlySet__.add("deliveredArtifactHash");
            return this;
        }

        public Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            this.__explicitlySet__.add("imageUri");
            return this;
        }

        public ContainerRegistryDeliveredArtifact build() {
            ContainerRegistryDeliveredArtifact model = new ContainerRegistryDeliveredArtifact(this.deployArtifactId, this.outputArtifactName, this.deliveredArtifactHash, this.imageUri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerRegistryDeliveredArtifact model) {
            if (model.wasPropertyExplicitlySet("deployArtifactId")) {
                this.deployArtifactId(model.getDeployArtifactId());
            }
            if (model.wasPropertyExplicitlySet("outputArtifactName")) {
                this.outputArtifactName(model.getOutputArtifactName());
            }
            if (model.wasPropertyExplicitlySet("deliveredArtifactHash")) {
                this.deliveredArtifactHash(model.getDeliveredArtifactHash());
            }
            if (model.wasPropertyExplicitlySet("imageUri")) {
                this.imageUri(model.getImageUri());
            }
            return this;
        }
    }
}

