/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.GradleProjectErrorNotifications;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleReport;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.cache.ProjectInfoDiskCache;
import org.netbeans.modules.gradle.execute.GradleNetworkProxySupport;
import org.netbeans.modules.gradle.loaders.AbstractProjectLoader;
import org.netbeans.modules.gradle.loaders.Bundle;
import org.netbeans.modules.gradle.loaders.GradleArtifactStore;
import org.netbeans.modules.gradle.loaders.GradleDaemon;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.tooling.internal.NbProjectInfo;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class LegacyProjectLoader
extends AbstractProjectLoader {
    private static final RequestProcessor DAEMON_LOG_RP = new RequestProcessor(LegacyProjectLoader.class);
    private static final Logger LOG = Logger.getLogger(LegacyProjectLoader.class.getName());
    private static AtomicLong timeInLoad = new AtomicLong();
    private static AtomicInteger loadedProjects = new AtomicInteger();
    private static final boolean DEBUG_GRADLE_INFO_ACTION = Boolean.getBoolean("netbeans.debug.gradle.info.action");
    private static final Pattern FILE_PATH_FROM_LOCATION = Pattern.compile("(?:build|settings) file '(.*)'(?: line:.*)$", 2);

    public LegacyProjectLoader(AbstractProjectLoader.ReloadContext ctx) {
        super(ctx);
    }

    @Override
    public GradleProject load() {
        GradleProject ret;
        try {
            ret = (GradleProject)GradleDaemon.GRADLE_LOADER_RP.submit((Callable)new ProjectLoaderTask(this.ctx)).get();
            LegacyProjectLoader.updateSubDirectoryCache(ret);
        }
        catch (InterruptedException | ExecutionException ex) {
            ret = null;
        }
        return ret;
    }

    @Override
    public boolean isEnabled() {
        return this.ctx.aim.betterThan(NbGradleProject.Quality.EVALUATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static GradleProject loadGradleProject(AbstractProjectLoader.ReloadContext ctx, CancellationToken token, ProgressListener pl) {
        void var15_23;
        GradleBaseProject base;
        NbGradleProject.Quality quality;
        NbProjectInfo info;
        long start;
        block35: {
            Serializable o;
            GoOnline goOnline;
            start = System.currentTimeMillis();
            info = null;
            quality = ctx.aim;
            base = ctx.previous.getBaseProject();
            ProjectConnection pconn = (ProjectConnection)ctx.project.getLookup().lookup(ProjectConnection.class);
            GradleProjectErrorNotifications errors = (GradleProjectErrorNotifications)ctx.project.getLookup().lookup(GradleProjectErrorNotifications.class);
            GradleCommandLine cmd = new GradleCommandLine(RunUtils.getCompatibleGradleDistribution(ctx.project), ctx.cmd);
            cmd.setFlag(GradleCommandLine.Flag.CONFIGURE_ON_DEMAND, GradleSettings.getDefault().isConfigureOnDemand());
            cmd.setFlag(GradleCommandLine.Flag.CONFIGURATION_CACHE, GradleSettings.getDefault().getUseConfigCache());
            cmd.addParameter(GradleCommandLine.Parameter.INIT_SCRIPT, GradleDaemon.initScript());
            cmd.setStackTrace(GradleCommandLine.StackTrace.SHORT);
            cmd.addProjectProperty("nbSerializeCheck", "true");
            if (GradleSettings.getDefault().isOffline()) {
                goOnline = GoOnline.NEVER;
            } else if (ctx.aim == NbGradleProject.Quality.FULL_ONLINE) {
                goOnline = GoOnline.ALWAYS;
            } else {
                switch (GradleSettings.getDefault().getDownloadLibs()) {
                    case NEVER: {
                        goOnline = GoOnline.NEVER;
                        break;
                    }
                    case ALWAYS: {
                        goOnline = GoOnline.ALWAYS;
                        break;
                    }
                    default: {
                        goOnline = GoOnline.ON_DEMAND;
                    }
                }
            }
            try {
                errors.clear();
                AtomicBoolean onlineResult = new AtomicBoolean();
                info = LegacyProjectLoader.retrieveProjectInfo(ctx.project, goOnline, pconn, cmd, token, pl, onlineResult);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Retrieved project info:");
                    ArrayList<String> keys = new ArrayList<String>(info.getInfo().keySet());
                    Collections.sort(keys);
                    for (String string : keys) {
                        Object o2 = info.getInfo().get(string);
                        if (o2 instanceof Collection) {
                            Collection c = (Collection)o2;
                            if (!c.isEmpty()) {
                                LOG.finer(String.format("    %-20s: [", string));
                                for (Object x : c) {
                                    if (Object[].class.isInstance(x)) {
                                        x = Arrays.asList((Object[])x);
                                    }
                                    LOG.finer(String.format("    %-20s", x));
                                }
                                LOG.finer("    ]");
                                continue;
                            }
                        } else if (o2 instanceof Map) {
                            Map m = (Map)o2;
                            if (m.isEmpty()) continue;
                            LOG.finer(String.format("    %-20s: {", string));
                            ArrayList mkeys = new ArrayList(m.keySet());
                            Collections.sort(mkeys);
                            for (String k : mkeys) {
                                Object x = m.get(k);
                                if (Object[].class.isInstance(x)) {
                                    x = Arrays.asList((Object[])x);
                                }
                                LOG.finer(String.format("        %-20s:%s", k, x));
                            }
                            LOG.finer("    }");
                            continue;
                        }
                        LOG.finer(String.format("    %-20s:%s", string, o2));
                    }
                }
                if (!info.getProblems().isEmpty()) {
                    errors.openNotification(Bundle.TIT_LOAD_ISSUES(base.getProjectDir().getName()), Bundle.TIT_LOAD_ISSUES(base.getProjectDir().getName()), GradleProjectErrorNotifications.bulletedList(info.getProblems()));
                }
                if (!info.hasException()) {
                    if (!info.getProblems().isEmpty() || !info.getReports().isEmpty()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            ArrayList o3 = new ArrayList(info.getReports().stream().map(LegacyProjectLoader::copyReport).map(r -> r.formatReportForHintOrProblem(true, FileUtil.toFileObject((File)ctx.project.getGradleFiles().getBuildScript()))).collect(Collectors.toList()));
                            LOG.log(Level.FINE, "Project {0} loaded without exception, but with problems: {1}", new Object[]{ctx.project, o3});
                        }
                        quality = NbGradleProject.Quality.SIMPLE;
                    } else {
                        quality = onlineResult.get() ? NbGradleProject.Quality.FULL_ONLINE : NbGradleProject.Quality.FULL;
                    }
                    break block35;
                }
                if (info.getProblems().isEmpty() && info.getReports().isEmpty()) {
                    String problem = info.getGradleException();
                    String[] lines = problem.split("\n");
                    LOG.log(Level.INFO, "Failed to retrieve project information for: {0}\nReason: {1}", new Object[]{base.getProjectDir(), problem});
                    errors.openNotification(Bundle.TIT_LOAD_FAILED(base.getProjectDir().getName()), lines[0], problem);
                    GradleProject gradleProject = ctx.previous.invalidate(problem);
                    return gradleProject;
                }
                ArrayList<GradleReport> reps = new ArrayList<GradleReport>();
                for (NbProjectInfo.Report report : info.getReports()) {
                    reps.add(LegacyProjectLoader.copyReport(report));
                }
                o = new ArrayList(reps.stream().map(r -> r.formatReportForHintOrProblem(true, FileUtil.toFileObject((File)ctx.project.getGradleFiles().getBuildScript()))).collect(Collectors.toList()));
                LOG.log(Level.FINE, "Project {0} loaded with exception, and with problems: {1}", new Object[]{ctx.project, o});
                LOG.log(Level.FINE, "Thrown exception:", info.getGradleException());
                File file = ctx.project.getGradleFiles().getBuildScript();
                for (String s : info.getProblems()) {
                    reps.add(GradleProject.createGradleReport(file == null ? null : file.toPath(), s));
                }
                GradleProject gradleProject = ctx.previous.invalidate(reps.toArray(new GradleReport[0]));
                return gradleProject;
            }
            catch (IllegalStateException | GradleConnectionException ex) {
                LOG.log(Level.FINE, "Failed to retrieve project information for: " + base.getProjectDir(), ex);
                List<GradleReport> problems = LegacyProjectLoader.exceptionsToProblems(ctx.project.getGradleFiles().getBuildScript(), ex);
                errors.openNotification(Bundle.TIT_LOAD_FAILED(base.getProjectDir()), ex.getMessage(), GradleProjectErrorNotifications.bulletedList(problems));
                o = ctx.previous.invalidate(problems.toArray(new GradleReport[0]));
                return o;
            }
            finally {
                loadedProjects.incrementAndGet();
            }
        }
        long finish = System.currentTimeMillis();
        timeInLoad.getAndAdd(finish - start);
        LOG.log(Level.FINE, "Loaded project {0} in {1} msec", new Object[]{base.getProjectDir(), finish - start});
        if (SwingUtilities.isEventDispatchThread()) {
            LOG.log(Level.FINE, "Load happened on AWT event dispatcher", new RuntimeException());
        }
        ProjectInfoDiskCache.QualifiedProjectInfo qinfo = new ProjectInfoDiskCache.QualifiedProjectInfo(quality, info);
        GradleProject gradleProject = LegacyProjectLoader.createGradleProject(ctx.project.getGradleFiles(), qinfo);
        GradleArtifactStore.getDefault().processProject(gradleProject);
        if (info.getMiscOnly()) {
            GradleProject gradleProject2 = ctx.previous;
        } else {
            LegacyProjectLoader.saveCachedProjectInfo(qinfo, gradleProject);
        }
        return var15_23;
    }

    static GradleReport copyReport(NbProjectInfo.Report orig) {
        Matcher m;
        String rawLoc = orig.getScriptLocation();
        String loc = null;
        if (rawLoc != null && (m = FILE_PATH_FROM_LOCATION.matcher(rawLoc)).matches()) {
            loc = m.group(1);
        }
        return GradleProject.createGradleReport(orig.getErrorClass(), loc, orig.getLineNumber(), orig.getMessage(), orig.getCause() == null ? null : LegacyProjectLoader.copyReport(orig.getCause()));
    }

    private static List<GradleReport> causesToProblems(Throwable ex) {
        ArrayList<GradleReport> problems = new ArrayList<GradleReport>();
        Throwable th = ex;
        while (th != null) {
            problems.add(GradleProject.createGradleReport(null, th.getMessage()));
            ex = th;
            if (ex != (th = th.getCause())) continue;
            break;
        }
        return problems;
    }

    private static List<GradleReport> exceptionsToProblems(File script, Throwable t) {
        if (!(t instanceof GradleConnectionException)) {
            return LegacyProjectLoader.causesToProblems(t);
        }
        return Collections.singletonList(LegacyProjectLoader.createReport(t.getCause()));
    }

    private static String getLocation(Throwable locationAwareEx) {
        try {
            Method locationAccessor = locationAwareEx.getClass().getMethod("getLocation", new Class[0]);
            return (String)locationAccessor.invoke((Object)locationAwareEx, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.FINE, "Error getting location", ex);
        }
        catch (IllegalArgumentException iae) {
            LOG.log(Level.FINE, "This probably should not happen: " + locationAwareEx.getClass().getName(), iae);
        }
        return null;
    }

    private static int getLineNumber(Throwable locationAwareEx) {
        try {
            Method lineNumberAccessor = locationAwareEx.getClass().getMethod("getLineNumber", new Class[0]);
            Integer i = (Integer)lineNumberAccessor.invoke((Object)locationAwareEx, new Object[0]);
            return i != null ? i : -1;
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.FINE, "Error getting line number", ex);
        }
        catch (IllegalArgumentException iae) {
            LOG.log(Level.FINE, "This probably should not happen: " + locationAwareEx.getClass().getName(), iae);
        }
        return -1;
    }

    private static GradleReport createReport(Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable reported = e;
        String loc = null;
        int line = -1;
        GradleReport nested = null;
        if (e.getClass().getName().endsWith("LocationAwareException")) {
            String rawLoc = LegacyProjectLoader.getLocation(e);
            if (rawLoc != null) {
                Matcher m = FILE_PATH_FROM_LOCATION.matcher(rawLoc);
                loc = m.matches() ? m.group(1) : rawLoc;
                line = LegacyProjectLoader.getLineNumber(e);
            }
            reported = e.getCause();
        } else {
            reported = e;
        }
        if (reported.getCause() != null && reported.getCause() != reported) {
            nested = LegacyProjectLoader.createReport(reported.getCause());
        }
        return GradleProject.createGradleReport(reported.getClass().getName(), loc, line, reported.getMessage(), nested);
    }

    private static BuildActionExecuter<NbProjectInfo> createInfoAction(ProjectConnection pconn, GradleCommandLine cmd, CancellationToken token, ProgressListener pl) {
        BuildActionExecuter ret = pconn.action((BuildAction)new NbProjectInfoAction());
        cmd.configure((ConfigurableLauncher<?>)ret);
        if (DEBUG_GRADLE_INFO_ACTION) {
            ret.addJvmArguments(new String[]{"-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5006"});
        }
        if (LOG.isLoggable(Level.FINEST)) {
            ret.addArguments(new String[]{"--debug"});
        } else if (LOG.isLoggable(Level.FINER)) {
            ret.addArguments(new String[]{"--info"});
        } else {
            ret.addArguments(new String[]{"--warn"});
        }
        if (token != null) {
            ret.withCancellationToken(token);
        }
        if (pl != null) {
            ret.addProgressListener(pl);
        }
        return ret;
    }

    private static NbProjectInfo retrieveProjectInfo(NbGradleProjectImpl projectImpl, GoOnline goOnline, ProjectConnection pconn, GradleCommandLine cmd, CancellationToken token, ProgressListener pl, AtomicBoolean wasOnline) throws GradleConnectionException, IllegalStateException {
        BuildActionExecuter<NbProjectInfo> action;
        GradleCommandLine online;
        block14: {
            GradleSettings settings = GradleSettings.getDefault();
            online = new GradleCommandLine(cmd);
            GradleCommandLine offline = new GradleCommandLine(cmd);
            if (goOnline != GoOnline.ALWAYS) {
                if (settings.getDownloadSources() == GradleSettings.DownloadMiscRule.ALWAYS) {
                    // empty if block
                }
                if (settings.getDownloadJavadoc() == GradleSettings.DownloadMiscRule.ALWAYS) {
                    // empty if block
                }
                offline.addFlag(GradleCommandLine.Flag.OFFLINE);
            }
            if (goOnline == GoOnline.NEVER || goOnline == GoOnline.ON_DEMAND) {
                action = LegacyProjectLoader.createInfoAction(pconn, offline, token, pl);
                wasOnline.set(!offline.hasFlag(GradleCommandLine.Flag.OFFLINE));
                try {
                    NbProjectInfo ret = LegacyProjectLoader.runInfoAction(action);
                    if (goOnline == GoOnline.NEVER || !ret.hasException()) {
                        return ret;
                    }
                }
                catch (IllegalStateException | GradleConnectionException ex) {
                    LOG.log(Level.FINE, "Project {0} loaded with exception for mode {1}", new Object[]{projectImpl, goOnline});
                    LOG.log(Level.FINE, "Thrown exception is: ", ex);
                    if (goOnline != GoOnline.NEVER) break block14;
                    throw ex;
                }
            }
        }
        action = LegacyProjectLoader.createInfoAction(pconn, online, token, pl);
        GradleNetworkProxySupport support = (GradleNetworkProxySupport)projectImpl.getLookup().lookup(GradleNetworkProxySupport.class);
        if (support != null) {
            try {
                GradleNetworkProxySupport.ProxyResult result = support.checkProxySettings().get();
                switch (result.getStatus()) {
                    case ABORT: {
                        LOG.log(Level.FINE, "User cancelled the project load");
                        throw new IllegalStateException(Bundle.ERR_UserAbort());
                    }
                }
                action = result.configure(action);
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(ex);
            }
            catch (ExecutionException ex) {
                throw new IllegalStateException(ex);
            }
        }
        wasOnline.set(true);
        return LegacyProjectLoader.runInfoAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NbProjectInfo runInfoAction(BuildActionExecuter<NbProjectInfo> action) {
        OutputStream logStream = null;
        try {
            if (LOG.isLoggable(Level.FINER)) {
                if (LOG.isLoggable(Level.FINEST)) {
                    action.addArguments(new String[]{"--debug"});
                }
                ImmediatePipedOutputStream pos = new ImmediatePipedOutputStream();
                try {
                    logStream = pos;
                    class LogDelegate
                    implements Runnable {
                        final BufferedReader rdr;

                        LogDelegate(InputStream is) throws IOException {
                            this.rdr = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        }

                        @Override
                        public void run() {
                            boolean first = true;
                            try {
                                String line;
                                while ((line = this.rdr.readLine()) != null) {
                                    if (first) {
                                        LOG.log(Level.FINER, "[gradle] ---- daemon log starting");
                                        first = false;
                                    }
                                    LOG.log(Level.FINER, "[gradle] {0}", line);
                                }
                            }
                            catch (IOException iOException) {
                            }
                            finally {
                                LOG.log(Level.FINER, "[gradle] ---- log terminated");
                            }
                        }
                    }
                    DAEMON_LOG_RP.post((Runnable)new LogDelegate(new PipedInputStream(pos)));
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
                action.setStandardOutput((OutputStream)pos);
                action.setStandardError((OutputStream)pos);
            }
            NbProjectInfo nbProjectInfo = (NbProjectInfo)action.run();
            return nbProjectInfo;
        }
        finally {
            if (logStream != null) {
                try {
                    logStream.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class ProjectLoaderTask
    implements Callable<GradleProject>,
    Cancellable {
        private final AbstractProjectLoader.ReloadContext ctx;
        private CancellationTokenSource tokenSource;

        public ProjectLoaderTask(AbstractProjectLoader.ReloadContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public GradleProject call() throws Exception {
            this.tokenSource = GradleConnector.newCancellationTokenSource();
            String msg = this.ctx.description != null ? Bundle.FMT_ProjectLoadReason(this.ctx.description, this.ctx.previous.getBaseProject().getName()) : Bundle.LBL_Loading(this.ctx.previous.getBaseProject().getName());
            ProgressHandle handle = ProgressHandle.createHandle((String)msg, (Cancellable)this);
            ProgressListener pl = pe -> handle.progress(pe.getDescription());
            handle.start();
            try {
                GradleProject gradleProject = LegacyProjectLoader.loadGradleProject(this.ctx, this.tokenSource.token(), pl);
                return gradleProject;
            }
            catch (Throwable ex) {
                LOG.log(Level.WARNING, ex.getMessage(), ex);
                throw ex;
            }
            finally {
                handle.finish();
            }
        }

        public boolean cancel() {
            if (this.tokenSource != null) {
                this.tokenSource.cancel();
            }
            return true;
        }
    }

    private static class NbProjectInfoAction
    implements Serializable,
    BuildAction<NbProjectInfo> {
        private NbProjectInfoAction() {
        }

        public NbProjectInfo execute(BuildController bc) {
            return (NbProjectInfo)bc.getModel(NbProjectInfo.class);
        }
    }

    static class ImmediatePipedOutputStream
    extends PipedOutputStream {
        ImmediatePipedOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.flush();
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.flush();
        }
    }

    private static enum GoOnline {
        NEVER,
        ON_DEMAND,
        ALWAYS;

    }
}

