/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.api.extexecution.base.Environment;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.CommonServerBridge;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.ide.WildflyDeploymentStatus;
import org.netbeans.modules.javaee.wildfly.ide.WildflyOutputSupport;
import org.netbeans.modules.javaee.wildfly.ide.WildflyStartServer;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.netbeans.modules.javaee.wildfly.util.WildFlyProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.InputOutput;

class WildflyStartRunnable
implements Runnable {
    private static final int START_TIMEOUT = 300000;
    private static final String CONF_FILE_NAME = "standalone.conf.bat";
    private static final String RUN_FILE_NAME = "run.bat";
    private static final String JBOSS_HOME = "JBOSS_HOME";
    private static final String STANDALONE_SH = File.separatorChar + "bin" + File.separatorChar + "standalone.sh";
    private static final String STANDALONE_BAT = File.separatorChar + "bin" + File.separatorChar + "standalone.bat";
    private static final String CONF_BAT = File.separatorChar + "bin" + File.separatorChar + "standalone.conf.bat";
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final Pattern IF_JAVA_OPTS_PATTERN = Pattern.compile(".*if(\\s+not)?\\s+(\"x%JAVA_OPTS%\"\\s+==\\s+\"x\")\\s+.*", 32);
    private static final String NEW_IF_CONDITION_STRING = "\"xx\" == \"x\"";
    private static final SpecificationVersion JDK_18 = new SpecificationVersion("1.8");
    private final WildflyDeploymentManager dm;
    private final String instanceName;
    private final WildflyStartServer startServer;

    WildflyStartRunnable(WildflyDeploymentManager dm, WildflyStartServer startServer) {
        this.dm = dm;
        this.instanceName = dm.getInstanceProperties().getProperty("displayName");
        this.startServer = startServer;
    }

    @Override
    public void run() {
        InstanceProperties ip = this.dm.getInstanceProperties();
        boolean free = this.checkPorts(ip);
        if (!free) {
            return;
        }
        Process serverProcess = this.createProcess(ip);
        if (serverProcess == null) {
            return;
        }
        WildflyOutputSupport outputSupport = WildflyOutputSupport.getInstance(ip, true);
        outputSupport.start(this.openConsole(), serverProcess, this.startServer.getMode() == WildflyStartServer.MODE.PROFILE);
        this.startServer.setConsoleConfigured(true);
        this.waitForServerToStart(outputSupport);
    }

    private void setupEnvironment(InstanceProperties ip, Environment env) {
        String baseDir;
        File configFile;
        int portOffSet;
        String logManagerJar;
        WildFlyProperties properties = this.dm.getProperties();
        JavaPlatform platform = properties.getJavaPlatform();
        String javaOpts = properties.getJavaOpts();
        StringBuilder javaOptsBuilder = new StringBuilder(javaOpts);
        if (this.startServer.getMode() == WildflyStartServer.MODE.PROFILE && !(logManagerJar = this.findLogManager(ip.getProperty("root-dir"))).isEmpty()) {
            javaOptsBuilder.append(" -Xbootclasspath/p:").append(logManagerJar).append(" -Djava.util.logging.manager=org.jboss.logmanager.LogManager");
            String[] loggingProperties = FileUtil.toFileObject((File)new File(ip.getProperty("root-dir") + File.separatorChar + "standalone" + File.separatorChar + "configuration", "logging.properties"));
            javaOptsBuilder.append(" -Dlogging.configuration=").append(loggingProperties.toURL());
        }
        if (platform.getSpecification().getVersion().compareTo(JDK_18) < 0) {
            javaOptsBuilder.append(" -XX:MaxPermSize=256m");
        }
        if ("64".equals(platform.getSystemProperties().get("sun.arch.data.model"))) {
            javaOptsBuilder.append(" -server");
        }
        if (properties.getProxyEnabled()) {
            String[] PROXY_PROPS;
            for (String prop : PROXY_PROPS = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"}) {
                String value;
                if (javaOpts.contains(prop) || (value = System.getProperty(prop)) == null) continue;
                if ("http.nonProxyHosts".equals(prop)) {
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new StringReader(value));
                        StringBuilder noNL = new StringBuilder();
                        while ((line = br.readLine()) != null) {
                            noNL.append(line);
                        }
                        value = noNL.toString().replace("<", "").replace(">", "").replace(" ", "").replace("\"", "").replace('|', ',').trim();
                    }
                    catch (IOException ioe) {
                        Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(WildflyStartRunnable.class, (String)"ERR_NonProxyHostParsingError"));
                        Logger.getLogger("global").log(Level.WARNING, null, ioe);
                        value = null;
                    }
                }
                if (value == null) continue;
                javaOptsBuilder.append(" -D").append(prop).append('=').append(value);
            }
        }
        if (this.startServer.getMode() == WildflyStartServer.MODE.DEBUG && !javaOptsBuilder.toString().contains("-Xverify")) {
            javaOptsBuilder.append(" -Xverify:none");
        }
        if (this.startServer.getMode() == WildflyStartServer.MODE.DEBUG && !javaOptsBuilder.toString().contains("-Xdebug") && !javaOptsBuilder.toString().contains("-agentlib:jdwp")) {
            javaOptsBuilder.append(String.format(" -agentlib:jdwp=transport=dt_socket,address=%1s,server=y,suspend=n", this.dm.getDebuggingPort()));
        }
        if (this.startServer.getMode() == WildflyStartServer.MODE.PROFILE) {
            javaOptsBuilder.append(" -Djava.net.preferIPv4Stack=true -Djboss.modules.system.pkgs=org.jboss.byteman,org.jboss.logmanager -Djava.awt.headless=true");
        } else {
            javaOptsBuilder.append(" -Djava.net.preferIPv4Stack=true -Djboss.modules.system.pkgs=org.jboss.byteman -Djava.awt.headless=true");
        }
        if (ip.getProperty("port-offset") != null && (portOffSet = Integer.parseInt(ip.getProperty("port-offset"))) > 0) {
            javaOptsBuilder.append(" -Djboss.socket.binding.port-offset=").append(portOffSet);
        }
        if (ip.getProperty("config_file") != null && (configFile = new File(ip.getProperty("config_file"))).exists() && configFile.getParentFile().exists() && configFile.getParentFile().getParentFile().exists() && !(baseDir = configFile.getParentFile().getParentFile().getAbsolutePath()).equals(ip.getProperty("server-dir"))) {
            javaOptsBuilder.append(" -Djboss.server.base.dir=").append(baseDir);
        }
        if (ip.getProperty("admin-port") != null) {
            try {
                int adminPort = Integer.parseInt(ip.getProperty("admin-port"));
                WildflyPluginUtils.Version currentVersion = this.dm.getServerVersion();
                if (!currentVersion.isWidlfy() || WildflyPluginUtils.WILDFLY_8_2_0.compareTo(currentVersion) <= 0) {
                    javaOptsBuilder.append(" -Djboss.management.http.port=").append(adminPort);
                } else {
                    javaOptsBuilder.append(" -Djboss.management.native.port=").append(adminPort);
                }
            }
            catch (NumberFormatException adminPort) {
                // empty catch block
            }
        }
        if (ip.getProperty("port") != null) {
            try {
                int httpConnectorPort = Integer.parseInt(ip.getProperty("port"));
                javaOptsBuilder.append(" -Djboss.http.port=").append(httpConnectorPort);
            }
            catch (NumberFormatException httpConnectorPort) {
                // empty catch block
            }
        }
        for (StartupExtender args : StartupExtender.getExtenders((Lookup)Lookups.singleton((Object)CommonServerBridge.getCommonInstance((String)ip.getProperty("url"))), (StartupExtender.StartMode)WildflyStartRunnable.getMode(this.startServer.getMode()))) {
            for (String singleArg : args.getArguments()) {
                javaOptsBuilder.append(' ').append(singleArg);
            }
        }
        javaOpts = javaOptsBuilder.toString();
        Logger.getLogger("global").log(Level.INFO, "JAVA_OPTS={0}", javaOpts);
        String javaHome = WildflyStartRunnable.getJavaHome(platform);
        env.setVariable("JAVA", javaHome + File.separatorChar + "bin" + File.separatorChar + "java");
        env.setVariable("JAVA_HOME", javaHome);
        env.setVariable(JBOSS_HOME, ip.getProperty("root-dir"));
        env.setVariable(JAVA_OPTS, javaOpts);
        if (Utilities.isWindows()) {
            env.setVariable("NOPAUSE", "true");
        }
    }

    private static StartupExtender.StartMode getMode(WildflyStartServer.MODE jbMode) {
        if (null != jbMode) {
            switch (jbMode) {
                case PROFILE: {
                    return StartupExtender.StartMode.PROFILE;
                }
                case DEBUG: {
                    return StartupExtender.StartMode.DEBUG;
                }
            }
            return StartupExtender.StartMode.NORMAL;
        }
        return StartupExtender.StartMode.NORMAL;
    }

    private boolean checkPorts(InstanceProperties ip) {
        try {
            String strHTTPConnectorPort = ip.getProperty("port");
            int httpConnectorPort = Integer.parseInt(strHTTPConnectorPort);
            if (httpConnectorPort <= 0) {
                return true;
            }
            if (!WildflyPluginUtils.isPortFree(httpConnectorPort)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_HTTP_PORT_IN_USE", strHTTPConnectorPort));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    private ProcessBuilder setupBinary(InstanceProperties ip, ProcessBuilder builder) {
        String serverRunFileName = this.getRunFileName(ip);
        if (!new File(serverRunFileName).exists()) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_FNF"));
            return null;
        }
        LinkedList<String> args = new LinkedList<String>();
        if (Utilities.isWindows()) {
            builder.setExecutable("cmd");
            args.add("/c");
            args.add(serverRunFileName);
        } else {
            builder.setExecutable(serverRunFileName);
        }
        if (ip.getProperty("config_file") != null && !"".equals(ip.getProperty("config_file"))) {
            String configFile = ip.getProperty("config_file");
            args.add("-c");
            args.add(configFile.substring(configFile.lastIndexOf(File.separatorChar) + 1));
        }
        builder.setArguments(args);
        return builder;
    }

    private String getRunFileName(InstanceProperties ip) {
        SpacesInPathFix fix = new SpacesInPathFix(ip);
        return fix.getRunFileName();
    }

    private static String getJavaHome(JavaPlatform platform) {
        FileObject fo = (FileObject)platform.getInstallFolders().iterator().next();
        return FileUtil.toFile((FileObject)fo).getAbsolutePath();
    }

    private String createProgressMessage(String resName) {
        return this.createProgressMessage(resName, null);
    }

    private String createProgressMessage(String resName, String param) {
        return NbBundle.getMessage(WildflyStartRunnable.class, (String)resName, (Object)this.instanceName, (Object)param);
    }

    private String getServerRunFileName(String serverLocation) {
        if (Utilities.isWindows()) {
            return serverLocation + STANDALONE_BAT;
        }
        return serverLocation + STANDALONE_SH;
    }

    private Process createProcess(InstanceProperties ip) {
        ProcessBuilder builder = ProcessBuilder.getLocal();
        this.setupEnvironment(ip, builder.getEnvironment());
        builder = this.setupBinary(ip, builder);
        if (builder == null) {
            return null;
        }
        try {
            File rootFile = null;
            String rootDir = ip.getProperty("root-dir");
            if (rootDir != null) {
                rootFile = new File(rootDir, "bin");
            }
            if (rootFile != null && !rootFile.isDirectory()) {
                rootFile = null;
            }
            builder.setWorkingDirectory(rootFile.getAbsolutePath());
            return builder.call();
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.WARNING, null, ioe);
            String serverLocation = ip.getProperty("root-dir");
            String serverRunFileName = this.getServerRunFileName(serverLocation);
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_PD", serverRunFileName));
            return null;
        }
    }

    private InputOutput openConsole() {
        InputOutput io = UISupport.getServerIO((String)this.dm.getUrl());
        if (io == null) {
            return null;
        }
        try {
            io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        io.select();
        this.startServer.setConsoleConfigured(true);
        return io;
    }

    private void fireStartProgressEvent(StateType stateType, String msg) {
        this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, msg));
    }

    private void waitForServerToStart(WildflyOutputSupport outputSupport) {
        this.fireStartProgressEvent(StateType.RUNNING, this.createProgressMessage("MSG_START_SERVER_IN_PROGRESS"));
        try {
            boolean result = outputSupport.waitForStart(300000L);
            this.dm.setNeedsRestart(false);
            if (result) {
                this.fireStartProgressEvent(StateType.COMPLETED, this.createProgressMessage("MSG_SERVER_STARTED"));
            } else {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED"));
            }
        }
        catch (TimeoutException ex) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_StartServerTimeout"));
        }
        catch (InterruptedException ex) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_StartServerInterrupted"));
            Thread.currentThread().interrupt();
        }
    }

    private String findLogManager(String serverDirPath) {
        StringBuilder logManagerPath = new StringBuilder(serverDirPath);
        logManagerPath.append(File.separatorChar).append("modules").append(File.separatorChar).append("system");
        logManagerPath.append(File.separatorChar).append("layers").append(File.separatorChar).append("base");
        logManagerPath.append(File.separatorChar).append("org").append(File.separatorChar).append("jboss");
        logManagerPath.append(File.separatorChar).append("logmanager").append(File.separatorChar).append("main");
        FileObject logManagerDir = FileUtil.toFileObject((File)new File(logManagerPath.toString()));
        for (FileObject child : logManagerDir.getChildren()) {
            if (!child.isData() || !"jar".equalsIgnoreCase(child.getExt())) continue;
            return child.getPath();
        }
        return "";
    }

    private class SpacesInPathFix {
        private InstanceProperties myProps;
        private boolean needChange;

        SpacesInPathFix(InstanceProperties ip) {
            this.myProps = ip;
            this.needChange = this.runFileNeedChange();
        }

        String getRunFileName() {
            String serverLocation = this.getProperties().getProperty("root-dir");
            String serverRunFileName = WildflyStartRunnable.this.getServerRunFileName(serverLocation);
            if (this.needChange) {
                String contentRun = this.readFile(serverRunFileName);
                String contentConf = this.readFile(serverLocation + CONF_BAT);
                Matcher matcherRun = IF_JAVA_OPTS_PATTERN.matcher(contentRun);
                Matcher matcherConf = contentConf != null ? IF_JAVA_OPTS_PATTERN.matcher(contentConf) : null;
                boolean needChangeRun = matcherRun.matches();
                boolean needChangeConf = matcherConf != null && matcherConf.matches();
                try {
                    if (needChangeRun || needChangeConf) {
                        File startBat = File.createTempFile(WildflyStartRunnable.RUN_FILE_NAME, ".bat");
                        File confBat = null;
                        if (contentConf != null) {
                            confBat = File.createTempFile(WildflyStartRunnable.CONF_FILE_NAME, ".bat", startBat.getParentFile());
                        }
                        startBat.deleteOnExit();
                        contentRun = this.replaceJavaOpts(contentRun, matcherRun);
                        if (confBat != null) {
                            contentRun = contentRun.replace(WildflyStartRunnable.CONF_FILE_NAME, confBat.getName());
                        }
                        this.writeFile(startBat, contentRun);
                        if (confBat != null) {
                            confBat.deleteOnExit();
                            contentConf = this.replaceJavaOpts(contentConf, matcherConf);
                            this.writeFile(confBat, contentConf);
                        }
                        return startBat.getAbsolutePath();
                    }
                }
                catch (IOException e) {
                    Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(WildflyStartRunnable.class, (String)"ERR_WriteError"));
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                }
            }
            return serverRunFileName;
        }

        private String replaceJavaOpts(String content, Matcher matcher) {
            String result = content;
            int start = 0;
            ArrayList<String> replacementString = new ArrayList<String>(1);
            while (matcher.find(start)) {
                if (matcher.groupCount() <= 1) continue;
                start = matcher.end(2);
                replacementString.add(matcher.group(2));
            }
            for (String replace : replacementString) {
                result = result.replace(replace, WildflyStartRunnable.NEW_IF_CONDITION_STRING);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(File file, String content) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(content);
            }
            catch (IOException e) {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(WildflyStartRunnable.class, (String)"ERR_WriteError"));
                Logger.getLogger("global").log(Level.WARNING, null, e);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readFile(String file) {
            StringBuilder builder = null;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(file)));
                builder = new StringBuilder();
                String line = "";
                do {
                    builder.append(line);
                    builder.append("\r\n");
                } while ((line = reader.readLine()) != null);
            }
            catch (IOException e) {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(WildflyStartRunnable.class, (String)"ERR_ReadError"));
                Logger.getLogger("global").log(Level.WARNING, null, e);
                String string = null;
                return string;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                }
            }
            return builder.toString();
        }

        private InstanceProperties getProperties() {
            return this.myProps;
        }

        private boolean runFileNeedChange() {
            WildFlyProperties properties = WildflyStartRunnable.this.dm.getProperties();
            if (properties.isVersion(WildflyPluginUtils.JBOSS_7_0_0)) {
                return false;
            }
            return false;
        }
    }
}

