/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.export;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.export.ExportBatch;

abstract class Exporter {
    protected static final int MAX_STEPS = 300;

    Exporter() {
    }

    protected abstract int getSteps(TableModel var1);

    protected void writeHeader(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
    }

    protected void writeData(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
    }

    protected void writeFooter(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
    }

    protected static void writeLine(Writer writer) throws IOException {
        writer.write("\n");
    }

    protected static void writeLine(Writer writer, String line) throws IOException {
        writer.write(line + "\n");
    }

    protected static void write(Writer writer, String text) throws IOException {
        writer.write(text);
    }

    final ExportBatch createBatch(final TableModel model, final String title, final Writer writer) {
        final TracerProgressObject progress = new TracerProgressObject(this.getSteps(model) + 2);
        ExportBatch.BatchRunnable worker = new ExportBatch.BatchRunnable(){

            @Override
            public void run() throws IOException {
                Exporter.this.doExport(model, title, writer, progress);
            }
        };
        return new ExportBatch(progress, worker);
    }

    private void doExport(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
        progress.setText("Initializing export...");
        this.writeHeader(model, title, writer, progress);
        if (progress.isFinished()) {
            return;
        }
        progress.addStep("Exporting data...");
        this.writeData(model, title, writer, progress);
        if (progress.isFinished()) {
            return;
        }
        progress.setText("Finishing export...");
        this.writeFooter(model, title, writer, progress);
        if (progress.isFinished()) {
            return;
        }
        progress.setText("Data exported");
        progress.finish();
    }
}

