/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common.api;

import java.io.File;
import java.util.Objects;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.modules.weblogic.common.api.DomainConfiguration;
import org.netbeans.modules.weblogic.common.api.Version;
import org.netbeans.modules.weblogic.common.api.WebLogicLayout;
import org.netbeans.modules.weblogic.common.api.WebLogicRemote;
import org.openide.util.WeakSet;

public final class WebLogicConfiguration {
    private static final WeakSet<WebLogicConfiguration> INSTANCES = new WeakSet();
    private final String id;
    private final File serverHome;
    private final File domainHome;
    private final String host;
    private final Integer port;
    private final Boolean secured;
    private final DomainConfiguration config;
    private final Credentials credentials;
    private WebLogicLayout layout;
    private WebLogicRemote remote;

    private WebLogicConfiguration(File serverHome, File domainHome, DomainConfiguration config, String host, Integer port, Boolean secured, Credentials credentials) {
        this.serverHome = serverHome;
        this.domainHome = domainHome;
        this.host = host;
        this.port = port;
        this.secured = secured;
        this.credentials = credentials;
        if (domainHome != null) {
            assert (config != null);
            this.id = serverHome + ":" + domainHome;
            this.config = config;
        } else {
            this.id = host + ":" + port;
            this.config = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static WebLogicConfiguration forLocalDomain(File serverHome, File domainHome, Credentials credentials) {
        DomainConfiguration config = DomainConfiguration.getInstance(domainHome, true);
        if (config == null) {
            return null;
        }
        WebLogicConfiguration instance = new WebLogicConfiguration(serverHome, domainHome, config, null, null, null, credentials);
        WeakSet<WebLogicConfiguration> weakSet = INSTANCES;
        synchronized (weakSet) {
            return (WebLogicConfiguration)INSTANCES.putIfAbsent((Object)instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static WebLogicConfiguration forRemoteDomain(File serverHome, String host, int port, boolean secured, Credentials credentials) {
        WebLogicConfiguration instance = new WebLogicConfiguration(serverHome, null, null, host, port, secured, credentials);
        WeakSet<WebLogicConfiguration> weakSet = INSTANCES;
        synchronized (weakSet) {
            return (WebLogicConfiguration)INSTANCES.putIfAbsent((Object)instance);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isRemote() {
        return this.domainHome == null;
    }

    @NonNull
    public File getServerHome() {
        return this.serverHome;
    }

    @NonNull
    public String getUsername() {
        return this.credentials.getUsername();
    }

    @NonNull
    public String getPassword() {
        return this.credentials.getPassword();
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        return this.config.getHost();
    }

    public int getPort() {
        if (this.port != null) {
            return this.port;
        }
        return this.config.getPort();
    }

    public boolean isSecured() {
        if (this.secured != null) {
            return this.secured;
        }
        return this.config.isSecured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public String getAdminURL() {
        if (this.config == null) {
            return WebLogicConfiguration.getAdminURL(this.host, this.port, this.secured);
        }
        DomainConfiguration domainConfiguration = this.config;
        synchronized (domainConfiguration) {
            return WebLogicConfiguration.getAdminURL(this.config.getHost(), this.config.getPort(), this.config.isSecured());
        }
    }

    @NullUnknown
    public File getDomainHome() {
        return this.domainHome;
    }

    @NullUnknown
    public String getDomainName() {
        if (this.config == null) {
            return null;
        }
        return this.config.getName();
    }

    @NullUnknown
    public String getDomainAdminServer() {
        if (this.config == null) {
            return null;
        }
        return this.config.getAdminServer();
    }

    @NullUnknown
    public File getLogFile() {
        if (this.config == null) {
            return null;
        }
        return this.config.getLogFile();
    }

    @CheckForNull
    public Version getDomainVersion() {
        if (this.config == null) {
            return null;
        }
        return this.config.getVersion();
    }

    @NonNull
    public synchronized WebLogicLayout getLayout() {
        if (this.layout == null) {
            this.layout = new WebLogicLayout(this);
        }
        return this.layout;
    }

    @NonNull
    public synchronized WebLogicRemote getRemote() {
        if (this.remote == null) {
            this.remote = new WebLogicRemote(this);
        }
        return this.remote;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebLogicConfiguration other = (WebLogicConfiguration)obj;
        return Objects.equals(this.id, other.id);
    }

    private static String getAdminURL(String host, int port, boolean secured) {
        StringBuilder sb = new StringBuilder();
        if (secured) {
            sb.append("t3s://");
        } else {
            sb.append("t3://");
        }
        sb.append(host).append(":").append(port);
        return sb.toString();
    }

    public static interface Credentials {
        @NonNull
        public String getUsername();

        @NonNull
        public String getPassword();
    }
}

