/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.tools.javac.code.Source;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.base.SourceLevelUtils;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.MultiReleaseJarFileObject;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class CachingFileManager
implements JavaFileManager,
PropertyChangeListener {
    private final CachingArchiveProvider provider;
    private final boolean cacheFile;
    private final JavaFileFilterImplementation filter;
    private final Source sourceLevel;
    private final boolean ignoreExcludes;
    private final ClassPath cp;
    private final boolean allowOutput;
    private static final Logger LOG = Logger.getLogger(CachingFileManager.class.getName());

    public CachingFileManager(@NonNull CachingArchiveProvider provider, @NonNull ClassPath cp, @NullAllowed Source sourceLevel, boolean cacheFile, boolean ignoreExcludes) {
        this(provider, cp, null, sourceLevel, false, cacheFile, ignoreExcludes);
    }

    public CachingFileManager(@NonNull CachingArchiveProvider provider, @NonNull ClassPath cp, @NullAllowed JavaFileFilterImplementation filter, @NullAllowed Source sourceLevel, boolean cacheFile, boolean ignoreExcludes) {
        this(provider, cp, filter, sourceLevel, true, cacheFile, ignoreExcludes);
    }

    private CachingFileManager(@NonNull CachingArchiveProvider provider, @NonNull ClassPath cp, @NullAllowed JavaFileFilterImplementation filter, @NullAllowed Source sourceLevel, boolean allowOutput, boolean cacheFile, boolean ignoreExcludes) {
        assert (provider != null);
        assert (cp != null);
        this.provider = provider;
        this.cp = cp;
        if (CacheClassPath.KEEP_JARS) {
            cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp));
        }
        this.filter = filter;
        this.sourceLevel = sourceLevel;
        this.allowOutput = allowOutput;
        this.cacheFile = cacheFile;
        this.ignoreExcludes = ignoreExcludes;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        return this.listImpl(l, this.cp.entries(), packageName, kinds, recursive);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location l, String pkgName, String relativeName) {
        return this.getFileForInputImpl(this.cp.entries(), pkgName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind) {
        return this.getJavaFileForInputImpl(this.cp.entries(), className, kind);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location l, String pkgName, String relativeName, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        List entries;
        if (!this.allowOutput) {
            throw new UnsupportedOperationException("Output is unsupported.");
        }
        JavaFileObject file = this.getFileForInputImpl(this.cp.entries(), pkgName, relativeName);
        if (file == null && !(entries = this.cp.entries()).isEmpty()) {
            String resourceName = FileObjects.resolveRelativePath(pkgName, relativeName);
            file = this.provider.getArchive(((ClassPath.Entry)entries.get(0)).getURL(), this.cacheFile).create(resourceName, this.filter);
        }
        return file;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location l) {
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location l, JavaFileObject javaFileObject) {
        if (javaFileObject instanceof InferableJavaFileObject) {
            return ((InferableJavaFileObject)javaFileObject).inferBinaryName();
        }
        return null;
    }

    public static URL[] getClassPathRoots(ClassPath cp) {
        assert (cp != null);
        List entries = cp.entries();
        ArrayList<URL> result = new ArrayList<URL>(entries.size());
        for (ClassPath.Entry entry : entries) {
            result.add(entry.getURL());
        }
        return result.toArray(new URL[0]);
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject0) {
        return fileObject instanceof FileObjects.FileBase && fileObject0 instanceof FileObjects.FileBase && ((FileObjects.FileBase)fileObject).getFile().equals(((FileObjects.FileBase)fileObject0).getFile());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            this.provider.clear();
        }
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return Collections.emptyList();
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        return null;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        return null;
    }

    protected final ClassPath getClassPath() {
        return this.cp;
    }

    protected final Iterable<JavaFileObject> listImpl(JavaFileManager.Location l, Collection<? extends ClassPath.Entry> roots, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        String folderName = FileObjects.convertPackage2Folder(packageName);
        LinkedList<Iterable<JavaFileObject>> idxs = new LinkedList<Iterable<JavaFileObject>>();
        List<? extends String> prefixes = null;
        boolean supportsMultiRelease = this.sourceLevel != null && this.sourceLevel.compareTo(SourceLevelUtils.JDK1_9) >= 0;
        for (ClassPath.Entry entry : roots) {
            try {
                Archive archive = this.provider.getArchive(entry.getURL(), this.cacheFile);
                if (archive != null) {
                    Iterable<JavaFileObject> entries;
                    if (supportsMultiRelease && archive.isMultiRelease()) {
                        if (prefixes == null) {
                            prefixes = this.multiReleaseRelocations();
                        }
                        HashMap<String, JavaFileObject> fqn2f = new HashMap<String, JavaFileObject>();
                        HashSet<String> seenPackages = new HashSet<String>();
                        for (String string : prefixes) {
                            Iterable<JavaFileObject> fos = archive.getFiles(CachingFileManager.join(string, folderName), this.ignoreExcludes ? null : entry, kinds, this.filter, recursive);
                            for (JavaFileObject fo : fos) {
                                boolean base = string.isEmpty();
                                if (!base) {
                                    fo = new MultiReleaseJarFileObject((InferableJavaFileObject)fo, string);
                                }
                                String fqn = this.inferBinaryName(l, fo);
                                String pkg = FileObjects.getPackageAndName(fqn)[0];
                                String name = pkg + "/" + FileObjects.getName(fo, false);
                                if (base) {
                                    seenPackages.add(pkg);
                                    fqn2f.put(name, fo);
                                    continue;
                                }
                                if (!seenPackages.contains(pkg)) continue;
                                fqn2f.put(name, fo);
                            }
                        }
                        entries = fqn2f.values();
                    } else {
                        entries = archive.getFiles(folderName, this.ignoreExcludes ? null : entry, kinds, this.filter, recursive);
                    }
                    idxs.add(entries);
                    if (!LOG.isLoggable(Level.FINEST)) continue;
                    CachingFileManager.logListedFiles(l, entry.getURL(), packageName, kinds, entries);
                    continue;
                }
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest(String.format("No archive for: %s", entry.getURL().toExternalForm()));
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return Iterators.chained(idxs);
    }

    protected final JavaFileObject getJavaFileForInputImpl(Collection<? extends ClassPath.Entry> roots, String className, JavaFileObject.Kind kind) {
        String[] namePair = FileObjects.getParentRelativePathAndName(className);
        boolean supportsMultiRelease = this.sourceLevel != null && this.sourceLevel.compareTo(SourceLevelUtils.JDK1_9) >= 0;
        List<? extends String> reloc = null;
        for (ClassPath.Entry entry : roots) {
            try {
                List<String> prefixes;
                Archive archive = this.provider.getArchive(entry.getURL(), this.cacheFile);
                if (archive == null) continue;
                if (supportsMultiRelease && archive.isMultiRelease()) {
                    if (reloc == null) {
                        reloc = this.multiReleaseRelocations();
                    }
                    prefixes = reloc;
                } else {
                    prefixes = Collections.singletonList("");
                }
                for (int i = prefixes.size() - 1; i >= 0; --i) {
                    String prefix = prefixes.get(i);
                    Iterable<JavaFileObject> files = archive.getFiles(CachingFileManager.join(prefix, namePair[0]), this.ignoreExcludes ? null : entry, null, this.filter, false);
                    for (JavaFileObject e : files) {
                        String ename = e.getName();
                        if (!namePair[1].equals(FileObjects.stripExtension(ename)) || kind != FileObjects.getKind(FileObjects.getExtension(ename))) continue;
                        return prefix.isEmpty() ? e : new MultiReleaseJarFileObject((InferableJavaFileObject)e, prefix);
                    }
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    protected final JavaFileObject getFileForInputImpl(Collection<? extends ClassPath.Entry> roots, String pkgName, String relativeName) {
        assert (pkgName != null);
        assert (relativeName != null);
        String resourceName = FileObjects.resolveRelativePath(pkgName, relativeName);
        boolean supportsMultiRelease = this.sourceLevel != null && this.sourceLevel.compareTo(SourceLevelUtils.JDK1_9) >= 0;
        List<? extends String> reloc = null;
        for (ClassPath.Entry entry : roots) {
            try {
                List<String> prefixes;
                Archive archive = this.provider.getArchive(entry.getURL(), this.cacheFile);
                if (archive == null) continue;
                if (supportsMultiRelease && archive.isMultiRelease()) {
                    if (reloc == null) {
                        reloc = this.multiReleaseRelocations();
                    }
                    prefixes = reloc;
                } else {
                    prefixes = Collections.singletonList("");
                }
                for (int i = prefixes.size() - 1; i >= 0; --i) {
                    String prefix = prefixes.get(i);
                    JavaFileObject file = archive.getFile(CachingFileManager.join(prefix, resourceName));
                    if (file == null) continue;
                    return prefix.isEmpty() ? file : new MultiReleaseJarFileObject((InferableJavaFileObject)file, prefix);
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    @NonNull
    private List<? extends String> multiReleaseRelocations() {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("");
        Source[] sources = Source.values();
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i].compareTo(SourceLevelUtils.JDK1_9) < 0 || sources[i].compareTo(this.sourceLevel) > 0) continue;
            prefixes.add(String.format("META-INF/versions/%s", CachingFileManager.normalizeSourceLevel(sources[i].name)));
        }
        return prefixes;
    }

    @NonNull
    private static String join(@NonNull String prefix, @NonNull String path) {
        return prefix.isEmpty() ? path : (path.isEmpty() ? prefix : prefix + '/' + path);
    }

    @NonNull
    private static String normalizeSourceLevel(@NonNull String sl) {
        int index = sl.indexOf(46);
        return index < 0 ? sl : sl.substring(index + 1);
    }

    private static void logListedFiles(@NonNull JavaFileManager.Location l, @NonNull URL root, @NonNull String packageName, @NonNull Set<? extends JavaFileObject.Kind> kinds, Iterable<? extends JavaFileObject> entries) {
        StringBuilder urls = new StringBuilder();
        for (JavaFileObject javaFileObject : entries) {
            urls.append(javaFileObject.toUri().toString());
            urls.append(", ");
        }
        LOG.finest(String.format("Files for %s (%s) in package: %s of type: %s files: [%s]", root.toExternalForm(), l.toString(), packageName, kinds.toString(), urls.toString()));
    }
}

