/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.model.DeployArtifactSource;
import com.oracle.bmc.devops.model.DeployArtifactSummary;
import com.oracle.bmc.devops.model.InlineDeployArtifactSource;
import com.oracle.bmc.devops.model.UpdateDeployArtifactDetails;
import com.oracle.bmc.devops.requests.GetDeployArtifactRequest;
import com.oracle.bmc.devops.requests.ListDeployArtifactsRequest;
import com.oracle.bmc.devops.requests.UpdateDeployArtifactRequest;
import com.oracle.bmc.devops.responses.GetDeployArtifactResponse;
import com.oracle.bmc.devops.responses.ListDeployArtifactsResponse;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.vault.VaultsClient;
import com.oracle.bmc.vault.model.Base64SecretContentDetails;
import com.oracle.bmc.vault.model.CreateSecretDetails;
import com.oracle.bmc.vault.model.SecretContentDetails;
import com.oracle.bmc.vault.model.SecretReuseRule;
import com.oracle.bmc.vault.model.UpdateSecretDetails;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.UpdateSecretRequest;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import com.oracle.bmc.vault.responses.UpdateSecretResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.assets.DependencyUtils;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectItem;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.steps.DatasourceNameStep;
import org.netbeans.modules.cloud.oracle.steps.DevopsStep;
import org.netbeans.modules.cloud.oracle.steps.KeyStep;
import org.netbeans.modules.cloud.oracle.steps.OverwriteStep;
import org.netbeans.modules.cloud.oracle.steps.PasswordStep;
import org.netbeans.modules.cloud.oracle.steps.ProjectStep;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.netbeans.modules.cloud.oracle.steps.VaultStep;
import org.netbeans.modules.cloud.oracle.vault.KeyItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class AddDbConnectionToVault
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(AddDbConnectionToVault.class.getName());
    private final DatabaseConnection context;

    public AddDbConnectionToVault(DatabaseConnection context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Steps.NextStepProvider nsProvider = Steps.NextStepProvider.builder().stepForClass(CompartmentStep.class, s -> new VaultStep()).stepForClass(VaultStep.class, s -> new KeyStep()).stepForClass(KeyStep.class, s -> new DatasourceNameStep()).stepForClass(DatasourceNameStep.class, s -> new OverwriteStep()).stepForClass(OverwriteStep.class, s -> new PasswordStep(this.context.getPassword(), this.context.getUser())).stepForClass(PasswordStep.class, s -> new DevopsStep()).stepForClass(DevopsStep.class, s -> new ProjectStep()).build();
        Lookup lookup = Lookups.fixed((Object[])new Object[]{nsProvider});
        Steps.getDefault().executeMultistep(new TenancyStep(), lookup).thenAccept(vals -> {
            Project project = (Project)vals.getValueForStep(ProjectStep.class);
            DevopsProjectItem devopsProject = (DevopsProjectItem)vals.getValueForStep(DevopsStep.class);
            String datasourceName = (String)vals.getValueForStep(DatasourceNameStep.class);
            VaultItem vault = (VaultItem)vals.getValueForStep(VaultStep.class);
            KeyItem key = (KeyItem)vals.getValueForStep(KeyStep.class);
            String password = (String)vals.getValueForStep(PasswordStep.class);
            if (datasourceName == null || datasourceName.isEmpty()) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.DatasourceEmpty());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            this.addDbConnectionToVault(vault, key, project, devopsProject, datasourceName, password);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDbConnectionToVault(VaultItem vault, KeyItem key, Project project, DevopsProjectItem devopsProject, String datasourceName, final String password) {
        ProgressHandle h = ProgressHandle.createHandle((String)Bundle.UpdatingVault(vault.getName()));
        h.start();
        h.progress(Bundle.ReadingSecrets());
        try {
            NotifyDescriptor.Message msg;
            VaultsClient client = VaultsClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile().getConfigProvider());
            ListSecretsRequest listSecretsRequest = ListSecretsRequest.builder().compartmentId(vault.getCompartmentId()).vaultId(vault.getKey().getValue()).limit(Integer.valueOf(88)).build();
            ListSecretsResponse secrets = client.listSecrets(listSecretsRequest);
            Map<String, String> existingSecrets = secrets.getItems().stream().collect(Collectors.toMap(s -> s.getSecretName(), s -> s.getId()));
            HashMap<String, String> values = new HashMap<String, String>(){
                {
                    this.put("Username", AddDbConnectionToVault.this.context.getUser());
                    this.put("Password", password);
                    this.put("OCID", (String)AddDbConnectionToVault.this.context.getConnectionProperties().get("OCID"));
                    this.put("CompartmentOCID", (String)AddDbConnectionToVault.this.context.getConnectionProperties().get("CompartmentOCID"));
                    this.put("wallet_Password", UUID.randomUUID().toString());
                }
            };
            for (Map.Entry entry : values.entrySet()) {
                UpdateSecretRequest request;
                String secretName = "DATASOURCES_" + datasourceName + "_" + ((String)entry.getKey()).toUpperCase();
                String base64Content = Base64.getEncoder().encodeToString(((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
                Base64SecretContentDetails contentDetails = Base64SecretContentDetails.builder().content(base64Content).stage(SecretContentDetails.Stage.Current).build();
                if (existingSecrets.containsKey(secretName)) {
                    h.progress(Bundle.UpdatingSecret(secretName));
                    UpdateSecretDetails updateSecretDetails = UpdateSecretDetails.builder().secretContent((SecretContentDetails)contentDetails).build();
                    request = UpdateSecretRequest.builder().secretId(existingSecrets.get(secretName)).updateSecretDetails(updateSecretDetails).build();
                    try {
                        UpdateSecretResponse updateSecretResponse = client.updateSecret(request);
                    }
                    catch (BmcException ex) {
                        LOG.log(Level.WARNING, "Update of secret failed", ex);
                    }
                    continue;
                }
                h.progress(Bundle.CreatingSecret(secretName));
                CreateSecretDetails createDetails = CreateSecretDetails.builder().secretName(secretName).secretContent((SecretContentDetails)contentDetails).secretRules(new ArrayList<SecretReuseRule>(Arrays.asList(SecretReuseRule.builder().isEnforcedOnDeletedSecretVersions(Boolean.valueOf(false)).build()))).compartmentId(vault.getCompartmentId()).vaultId(vault.getKey().getValue()).keyId(key.getKey().getValue()).build();
                request = CreateSecretRequest.builder().createSecretDetails(createDetails).build();
                client.createSecret((CreateSecretRequest)request);
            }
            try {
                DependencyUtils.addDependency(project, "io.micronaut.oraclecloud", "micronaut-oraclecloud-vault");
            }
            catch (IllegalStateException e) {
                LOG.log(Level.INFO, "Unable to add Vault dependency", e);
            }
            DevopsClient devopsClient = DevopsClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile().getConfigProvider());
            ListDeployArtifactsRequest request = ListDeployArtifactsRequest.builder().projectId(devopsProject.getKey().getValue()).build();
            ListDeployArtifactsResponse response = devopsClient.listDeployArtifacts(request);
            List artifacts = response.getDeployArtifactCollection().getItems();
            boolean found = false;
            for (DeployArtifactSummary artifact : artifacts) {
                if (!(devopsProject.getName() + "_oke_configmap").equals(artifact.getDisplayName())) continue;
                h.progress("updating  " + devopsProject.getName() + "_oke_configmap");
                found = true;
                GetDeployArtifactRequest artRequest = GetDeployArtifactRequest.builder().deployArtifactId(artifact.getId()).build();
                GetDeployArtifactResponse artResponse = devopsClient.getDeployArtifact(artRequest);
                DeployArtifactSource source = artResponse.getDeployArtifact().getDeployArtifactSource();
                if (!(source instanceof InlineDeployArtifactSource)) continue;
                byte[] content = ((InlineDeployArtifactSource)source).getBase64EncodedContent();
                String srcString = AddDbConnectionToVault.updateProperties(new String(content, StandardCharsets.UTF_8), vault.getCompartmentId(), vault.getKey().getValue(), datasourceName);
                byte[] base64Content = Base64.getEncoder().encode(srcString.getBytes(StandardCharsets.UTF_8));
                InlineDeployArtifactSource updatedSource = InlineDeployArtifactSource.builder().base64EncodedContent(base64Content).build();
                UpdateDeployArtifactDetails updateArtifactDetails = UpdateDeployArtifactDetails.builder().deployArtifactSource((DeployArtifactSource)updatedSource).build();
                UpdateDeployArtifactRequest updateArtifactRequest = UpdateDeployArtifactRequest.builder().updateDeployArtifactDetails(updateArtifactDetails).deployArtifactId(artifact.getId()).build();
                devopsClient.updateDeployArtifact(updateArtifactRequest);
            }
            if (!found) {
                msg = new NotifyDescriptor.Message((Object)Bundle.NoConfigMap(devopsProject.getName()), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
            msg = new NotifyDescriptor.Message((Object)Bundle.SecretsCreated());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            h.finish();
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)e.getMessage(), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
        finally {
            h.finish();
        }
    }

    protected static String updateProperties(String configmap, String compartmentOcid, String vaultOcid, String datasourceName) {
        StringWriter output = new StringWriter();
        String[] lines = configmap.split("\n");
        int previousIndent = 0;
        LinkedHashMap<Integer, String> path = new LinkedHashMap<Integer, String>();
        String propertiesName = null;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.trim().startsWith("#") || line.isEmpty()) {
                output.append(line);
                output.append("\n");
                continue;
            }
            int indent = 0;
            while (line.charAt(indent) == ' ') {
                ++indent;
            }
            if (previousIndent > indent || propertiesName != null && !line.contains("=")) {
                int f = indent;
                path.entrySet().removeIf(entry -> (Integer)entry.getKey() >= f);
                if (propertiesName != null) {
                    int propIndent = previousIndent;
                    if (properties.isEmpty()) {
                        propIndent = indent + 2;
                    }
                    output.append(AddDbConnectionToVault.formatProperties(propertiesName, properties, propIndent, compartmentOcid, vaultOcid, datasourceName));
                    properties.clear();
                }
                propertiesName = null;
                if (line.trim().equals("---")) {
                    output.append(line);
                    output.append("\n");
                    continue;
                }
            }
            if (propertiesName == null) {
                if (line.indexOf(58) < 0) {
                    throw new IllegalStateException("Invalid ConfigMap format");
                }
                String k = line.substring(0, line.indexOf(58)).trim();
                String v = line.substring(line.indexOf(58) + 1).trim();
                if (k == null) {
                    throw new IllegalStateException();
                }
                path.put(indent, k);
                output.append(line);
                output.append("\n");
                if (v.trim().equals("|")) {
                    propertiesName = k;
                    continue;
                }
            }
            if (propertiesName != null && line.contains("=")) {
                properties.put(line.substring(0, line.indexOf(61)).trim(), line.substring(line.indexOf(61) + 1).trim());
            }
            previousIndent = indent;
        }
        output.append(AddDbConnectionToVault.formatProperties(propertiesName, properties, previousIndent, compartmentOcid, vaultOcid, datasourceName));
        return output.toString();
    }

    private static String formatProperties(String proprtiesName, Map<String, String> prop, int indent, String compartmentId, String vaultId, String datasourceName) {
        StringBuilder output = new StringBuilder();
        if (proprtiesName.startsWith("bootstrap")) {
            prop.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith("oci.vault.vaults"));
            prop.put("oci.config.instance-principal.enabled", "true");
            prop.put("micronaut.config-client.enabled", "true");
            prop.put("oci.vault.config.enabled", "true");
            prop.put("oci.vault.vaults[0].ocid", vaultId);
            prop.put("oci.vault.vaults[0].compartment-ocid", compartmentId);
        } else if (proprtiesName.startsWith("application")) {
            prop.put("datasources.default.dialect", "ORACLE");
            prop.put("datasources.default.ocid", "${DATASOURCES_" + datasourceName + "_OCID}");
            prop.put("datasources.default.walletPassword", "${DATASOURCES_" + datasourceName + "_WALLET_PASSWORD}");
            prop.put("datasources.default.username", "${DATASOURCES_" + datasourceName + "_USERNAME}");
            prop.put("datasources.default.password", "${DATASOURCES_" + datasourceName + "_PASSWORD}");
        }
        for (Map.Entry<String, String> entry2 : prop.entrySet()) {
            output.append(new String(new char[indent]).replace('\u0000', ' '));
            output.append(entry2.getKey());
            output.append("=");
            output.append(entry2.getValue());
            output.append("\n");
        }
        return output.toString();
    }
}

