/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.bucket;

import com.oracle.bmc.objectstorage.ObjectStorageClient;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.bucket.BucketItem;
import org.netbeans.modules.cloud.oracle.bucket.Bundle;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class BucketNode
extends OCINode {
    private static final String BUCKET_ICON = "org/netbeans/modules/cloud/oracle/resources/bucket.svg";

    public BucketNode(BucketItem bucket) {
        super((OCIItem)bucket, Children.LEAF);
        this.setName(bucket.getName());
        this.setDisplayName(bucket.getName());
        this.setIconBaseWithExtension(BUCKET_ICON);
        this.setShortDescription(Bundle.BcuketDesc(bucket.getName()));
    }

    public static NodeProvider<BucketItem> createNode() {
        return BucketNode::new;
    }

    public static ChildrenProvider.SessionAware<CompartmentItem, BucketItem> getBuckets() {
        return (compartmentId, session) -> {
            ObjectStorageClient client = session.newClient(ObjectStorageClient.class);
            ListBucketsRequest listBucketsRequest = ListBucketsRequest.builder().compartmentId(compartmentId.getKey().getValue()).namespaceName(session.getTenancy().get().getName()).limit(Integer.valueOf(88)).build();
            List x = client.listBuckets(listBucketsRequest).getItems().stream().map(d -> new BucketItem(OCID.of(d.getName(), "Bucket"), compartmentId.getKey().getValue(), d.getName(), d.getNamespace())).collect(Collectors.toList());
            return x;
        };
    }
}

