/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.model.ProjectSummary;
import com.oracle.bmc.devops.requests.ListProjectsRequest;
import com.oracle.bmc.devops.responses.ListProjectsResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectItem;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectService;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.openide.NotifyDescriptor;

public class DevopsStep
extends AbstractStep<DevopsProjectItem> {
    private Map<String, DevopsProjectItem> devopsProjects;
    private DevopsProjectItem selected;

    @Override
    public void prepare(ProgressHandle h, Steps.Values values) {
        h.progress(Bundle.FetchingDevopsProjects());
        List<String> devops = DevopsProjectService.getDevopsProjectOcid();
        CompartmentItem compartment = (CompartmentItem)values.getValueForStep(CompartmentStep.class);
        Map<String, DevopsProjectItem> allProjectsInCompartment = DevopsStep.getDevopsProjects(compartment.getKey().getValue());
        Map<String, DevopsProjectItem> filtered = allProjectsInCompartment.entrySet().stream().filter(e -> devops.contains(((DevopsProjectItem)e.getValue()).getKey().getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.devopsProjects = !filtered.isEmpty() ? filtered : allProjectsInCompartment;
        if (this.devopsProjects.size() == 1) {
            this.selected = this.devopsProjects.values().iterator().next();
        }
    }

    @Override
    public NotifyDescriptor createInput() {
        if (this.devopsProjects.size() > 1) {
            return Steps.createQuickPick(this.devopsProjects, Bundle.SelectDevopsProject());
        }
        if (this.devopsProjects.isEmpty()) {
            return new NotifyDescriptor.QuickPick("", Bundle.NoDevopsProjects(), Collections.emptyList(), false);
        }
        throw new IllegalStateException("No data to create input");
    }

    @Override
    public boolean onlyOneChoice() {
        return this.devopsProjects.size() == 1;
    }

    @Override
    public void setValue(String projectName) {
        this.selected = this.devopsProjects.get(projectName);
    }

    @Override
    public DevopsProjectItem getValue() {
        return this.selected;
    }

    protected static Map<String, DevopsProjectItem> getDevopsProjects(String compartmentId) {
        try (DevopsClient client = new DevopsClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());){
            ListProjectsRequest request = ListProjectsRequest.builder().compartmentId(compartmentId).build();
            ListProjectsResponse response = client.listProjects(request);
            List projects = response.getProjectCollection().getItems();
            for (ProjectSummary project : projects) {
                project.getNotificationConfig().getTopicId();
            }
            Map map = projects.stream().map(p -> new DevopsProjectItem(OCID.of(p.getId(), "DevopsProject"), compartmentId, p.getName())).collect(Collectors.toMap(OCIItem::getName, Function.identity()));
            return map;
        }
    }
}

