/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Color;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTableModel;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableHTMLModel;
import org.netbeans.spi.viewmodel.TableHTMLModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BoldVariablesTableModelFilter
implements TableHTMLModelFilter,
Constants {
    private Map<Object, String> variableToValueType = new WeakHashMap<Object, String>();
    private Map<Object, String> variableToValueValue = new WeakHashMap<Object, String>();
    private Map<Object, String> variableToValueToString = new WeakHashMap<Object, String>();

    public boolean hasHTMLValueAt(TableHTMLModel original, Object row, String columnID) throws UnknownTypeException {
        return true;
    }

    public String getHTMLValueAt(TableHTMLModel original, Object row, String columnID) throws UnknownTypeException {
        if (original.hasHTMLValueAt(row, columnID)) {
            return original.getHTMLValueAt(row, columnID);
        }
        Object result = original.getValueAt(row, columnID);
        if ("LocalsType".equals(columnID) || "WatchType".equals(columnID)) {
            return this.bold(row, (String)result, this.variableToValueType);
        }
        if ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID)) {
            if (result instanceof Variable) {
                Variable var = (Variable)result;
                Object mirror = VariablesTableModel.getMirrorFor(var);
                if (mirror == null) {
                    String value = var.getValue();
                    return this.bold(row, value, this.variableToValueValue);
                }
                if ("java.lang.String".equals(var.getType())) {
                    String value = var.getValue();
                    value = BoldVariablesTableModelFilter.adjustEscaped(value);
                    return this.bold(row, value, this.variableToValueValue);
                }
                return null;
            }
            if (result == null || result instanceof String) {
                return this.bold(row, (String)result, this.variableToValueValue);
            }
            return null;
        }
        if ("LocalsToString".equals(columnID) || "WatchToString".equals(columnID)) {
            return this.bold(row, (String)result, this.variableToValueToString);
        }
        return original.getHTMLValueAt(row, columnID);
    }

    private static String adjustEscaped(String text) {
        text = text.replaceAll(Matcher.quoteReplacement("\\"), "\\\\\\\\");
        StringBuffer sb = null;
        int j = 0;
        int n = text.length();
        boolean quotes = n > 1 && text.startsWith("\"") && text.endsWith("\"");
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            String replacement = null;
            if (c == '\n') {
                replacement = "\\n";
            } else if (c == '\r') {
                replacement = "\\r";
            } else if (c == '\f') {
                replacement = "\\f";
            } else if (c == '\b') {
                replacement = "\\b";
            } else if (c == '\t') {
                replacement = "\\t";
            } else if (c == '\f') {
                replacement = "\\f";
            } else if (c == '\'') {
                replacement = "\\'";
            } else if (c == '\"' && (!quotes || i != 0 && i != n - 1)) {
                replacement = "\\\"";
            }
            if (replacement == null) continue;
            if (sb == null) {
                sb = new StringBuffer(text.substring(0, i));
            } else {
                sb.append(text.substring(j, i));
            }
            sb.append(replacement);
            j = i + 1;
        }
        if (sb == null) {
            return text;
        }
        sb.append(text.substring(j));
        return sb.toString();
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private String bold(Object variable, String value, Map<Object, String> map) {
        if (map.containsKey(variable)) {
            String oldValue = map.get(variable);
            if (Objects.equals(oldValue, value)) {
                return BoldVariablesTableModelFilter.toHTML(value, false, false, null);
            }
            map.put(variable, value);
            return BoldVariablesTableModelFilter.toHTML(value, true, false, null);
        }
        map.put(variable, value);
        return BoldVariablesTableModelFilter.toHTML(value, false, false, null);
    }

    public static String toHTML(String text, boolean bold, boolean italics, Color color) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (bold) {
            sb.append("<b>");
        }
        if (italics) {
            sb.append("<i>");
        }
        if (color == null && (color = UIManager.getColor("Table.foreground")) == null) {
            color = new JTable().getForeground();
        }
        sb.append("<font color=\"#");
        String hexColor = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        for (int i = hexColor.length(); i < 6; ++i) {
            sb.append("0");
        }
        sb.append(hexColor);
        sb.append("\">");
        text = text.replace("&", "&amp;");
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        sb.append(text);
        sb.append("</font>");
        if (italics) {
            sb.append("</i>");
        }
        if (bold) {
            sb.append("</b>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

