/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.spi.support.NativeExecutionUserNotification;
import org.netbeans.modules.nativeexecution.spi.support.PasswordProvider;
import org.netbeans.modules.nativeexecution.spi.support.PasswordProviderFactory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class RemoteUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private static final Object lock = RemoteUserInfo.class.getName() + "Lock";
    private static final PasswordManager pm = PasswordManager.getInstance();
    private final ExecutionEnvironment env;
    private final boolean allowInterraction;
    private char[] secret = null;

    public RemoteUserInfo(ExecutionEnvironment env, boolean allowToAskForPassword) {
        this.env = env;
        this.allowInterraction = allowToAskForPassword;
    }

    public String getPassphrase() {
        return this.getSecret();
    }

    public String getPassword() {
        return this.getSecret();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSecret() {
        String result = null;
        Object object = lock;
        synchronized (object) {
            char[] saved = pm.getPassword(this.env);
            if (saved != null) {
                result = new String(saved);
            } else if (this.secret != null) {
                result = new String(this.secret);
                Arrays.fill(this.secret, 'x');
                this.secret = null;
            }
        }
        return result;
    }

    public boolean promptPassword(String message) {
        return this.promptSecret(PasswordProvider.SecretType.PASSWORD, message);
    }

    public boolean promptPassphrase(String message) {
        return this.promptSecret(PasswordProvider.SecretType.PASSPHRASE, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean promptSecret(PasswordProvider.SecretType secretType, String message) {
        Object object = lock;
        synchronized (object) {
            PasswordProviderFactory factory;
            if (pm.getPassword(this.env) != null) {
                return true;
            }
            if (!this.allowInterraction) {
                return false;
            }
            Collection factories = Lookup.getDefault().lookupAll(PasswordProviderFactory.class);
            if (factories.isEmpty()) {
                return false;
            }
            PasswordProvider passwordProvider = null;
            Iterator iterator = factories.iterator();
            while (iterator.hasNext() && (passwordProvider = (factory = (PasswordProviderFactory)iterator.next()).create(secretType)) == null) {
            }
            if (passwordProvider == null) {
                return false;
            }
            if (!passwordProvider.askPassword(this.env, message)) {
                throw new CancellationException(RemoteUserInfo.loc("USER_AUTH_CANCELED", new String[0]));
            }
            this.secret = passwordProvider.getPassword();
            pm.storePassword(this.env, this.secret, passwordProvider.isRememberPassword());
            passwordProvider.clearPassword();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean promptYesNo(String str) {
        Object object = lock;
        synchronized (object) {
            if (RemoteUserInfo.isUnitTestMode() || RemoteUserInfo.isStandalone()) {
                System.err.println(str + " yes");
                return true;
            }
            return NativeExecutionUserNotification.getDefault().showYesNoQuestion(RemoteUserInfo.loc("TITLE_YN_Warning", new String[0]), str);
        }
    }

    private static boolean isStandalone() {
        if ("true".equals(System.getProperty("cnd.command.line.utility"))) {
            return true;
        }
        return !RemoteUserInfo.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    private static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    private boolean isSeparatorLine(String line) {
        if (line.isEmpty()) {
            return false;
        }
        char c = line.charAt(0);
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == c) continue;
            return false;
        }
        return true;
    }

    private String tryRemovingFrame(String line) {
        char c;
        if (!line.isEmpty() && !Character.isLetterOrDigit(c = line.charAt(0)) && line.charAt(line.length() - 1) == c) {
            line = line.substring(1, line.length() - 1).trim();
        }
        return line;
    }

    private String getBriefMessage(String message) {
        int maxLen = 80;
        if (message.length() <= 80) {
            return message;
        }
        if (message.contains("\n")) {
            String[] lines = message.split("\n");
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                if ((line = line.trim()).isEmpty() || this.isSeparatorLine(line) || (line = this.tryRemovingFrame(line).trim()).isEmpty()) continue;
                return line + "...";
            }
            return "";
        }
        return message.substring(0, 80) + "...";
    }

    public void showMessage(String message) {
        String titleAndBriefMessage = NbBundle.getMessage(RemoteUserInfo.class, (String)"TITLE_Message_Ex", (Object)this.env.getDisplayName(), (Object)this.getBriefMessage(message));
        NativeExecutionUserNotification.getDefault().showInfoNotification(titleAndBriefMessage, titleAndBriefMessage, message);
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (prompt.length == 1 && !echo[0]) {
            if (!this.promptPassword(RemoteUserInfo.loc("MSG_PasswordInteractive", destination, prompt[0]))) {
                return null;
            }
            return new String[]{this.getPassword()};
        }
        return null;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(RemoteUserInfo.class, (String)key, (Object[])params);
    }
}

