/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.resources.impl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.javaee.resources.api.model.Refreshable;
import org.netbeans.modules.javaee.resources.impl.model.JmsDestinationImpl;
import org.netbeans.modules.javaee.resources.impl.model.JmsDestinationsImpl;

public class JndiResourcesObjectProviders {

    private static abstract class AbstractProvider<T extends Refreshable>
    implements ObjectProvider<T> {
        private String[] annotationTypes;
        private AnnotationModelHelper helper;

        AbstractProvider(AnnotationModelHelper helper, String ... annotationTypes) {
            this.annotationTypes = annotationTypes;
            this.helper = helper;
        }

        public List<T> createInitialObjects() throws InterruptedException {
            final LinkedList result = new LinkedList();
            for (String annotationType : this.annotationTypes) {
                this.helper.getAnnotationScanner().findAnnotations(annotationType, AnnotationScanner.TYPE_KINDS, new AnnotationHandler(){

                    public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                        result.add(this.createObject(helper, type));
                    }
                });
            }
            return result;
        }

        public List<T> createObjects(TypeElement type) {
            ArrayList<T> result = new ArrayList<T>();
            for (String annotationType : this.annotationTypes) {
                if (type.getKind() != ElementKind.CLASS && type.getKind() != ElementKind.INTERFACE && type.getKind() != ElementKind.ENUM || !this.helper.hasAnyAnnotation(type.getAnnotationMirrors(), Collections.singleton(annotationType))) continue;
                result.add(this.createObject(this.helper, type));
            }
            return result;
        }

        public boolean modifyObjects(TypeElement type, List<T> objects) {
            assert (objects.size() == 1);
            Refreshable object = (Refreshable)objects.get(0);
            assert (object != null);
            if (!object.refresh(type)) {
                objects.remove(0);
                return true;
            }
            return false;
        }

        abstract T createObject(AnnotationModelHelper var1, TypeElement var2);
    }

    static final class JmsDestinationsProvider
    extends AbstractProvider<JmsDestinationsImpl> {
        public JmsDestinationsProvider(AnnotationModelHelper helper) {
            super(helper, "javax.jms.JMSDestinationDefinitions", "jakarta.jms.JMSDestinationDefinitions");
        }

        @Override
        JmsDestinationsImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new JmsDestinationsImpl(helper, typeElement);
        }
    }

    static final class JmsDestinationProvider
    extends AbstractProvider<JmsDestinationImpl> {
        JmsDestinationProvider(AnnotationModelHelper helper) {
            super(helper, "javax.jms.JMSDestinationDefinition", "jakarta.jms.JMSDestinationDefinition");
        }

        @Override
        public JmsDestinationImpl createObject(AnnotationModelHelper helper, TypeElement typeElement) {
            return new JmsDestinationImpl(helper, typeElement);
        }
    }
}

