/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.sources;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Phaser;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetScriptSourceRequest;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.CDTScript;
import org.netbeans.modules.javascript.cdtdebug.ScriptsHandler;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public final class ChangeLiveSupport {
    private static final Logger LOG = Logger.getLogger(ChangeLiveSupport.class.getName());
    public static final String PROP_CHANGES = "changes";
    private final CDTDebugger dbg;
    private final FileChangeListener sourceChangeListener;
    private final FileChangeDelivery fileChangeDelivery = new FileChangeDelivery();
    private final File[] sourceChangeRoots;
    private final RequestProcessor rp = new RequestProcessor(ChangeLiveSupport.class);
    private final PropertyChangeSupport pcl = new PropertyChangeSupport(this);
    private volatile boolean haveChanges = false;

    public ChangeLiveSupport(CDTDebugger dbg) {
        this.dbg = dbg;
        this.sourceChangeListener = new SourceChangeListener();
        this.sourceChangeRoots = dbg.getScriptsHandler().getLocalRoots();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "new ChangeLiveSupport(), sourceChangeRoots = {0}", Arrays.toString(this.sourceChangeRoots));
        }
        if (this.sourceChangeRoots.length == 0) {
            FileUtil.addFileChangeListener((FileChangeListener)this.sourceChangeListener);
        } else {
            for (File root : this.sourceChangeRoots) {
                FileUtil.addRecursiveListener((FileChangeListener)this.sourceChangeListener, (File)root);
            }
        }
        dbg.addListener(new CDTDebugger.Listener(){

            @Override
            public void notifySuspended(boolean suspended) {
            }

            @Override
            public void notifyCurrentFrame(CallFrame cf) {
            }

            @Override
            public void notifyFinished() {
                ChangeLiveSupport.this.destroy();
            }
        });
    }

    public boolean hasChanges() {
        return this.haveChanges;
    }

    private void setHasChanges(boolean haveChanges) {
        if (haveChanges == this.haveChanges) {
            return;
        }
        this.haveChanges = haveChanges;
        this.pcl.firePropertyChange(PROP_CHANGES, !haveChanges, haveChanges);
    }

    public void applyChanges() {
        this.fileChangeDelivery.applyChanges();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcl.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcl.removePropertyChangeListener(l);
    }

    private void applyModifiedFiles(List<FileObject> modifiedFiles) {
        ScriptsHandler sh = this.dbg.getScriptsHandler();
        Collection<CDTScript> scripts = sh.getScripts();
        Phaser phaser = new Phaser(1);
        LOG.log(Level.FINE, "applyModifiedFiles({0})", modifiedFiles);
        for (FileObject fo : modifiedFiles) {
            String fileSource;
            String serverPath;
            if (!sh.containsLocalFile(fo)) continue;
            String path = fo.getPath();
            try {
                serverPath = sh.getServerPath(path);
            }
            catch (ScriptsHandler.OutOfScope ex) {
                continue;
            }
            CDTScript script = null;
            for (CDTScript s : scripts) {
                if (!serverPath.equals(s.getUrl().getPath())) continue;
                script = s;
                break;
            }
            if (script == null) continue;
            try {
                fileSource = fo.asText();
            }
            catch (IOException ioex) {
                continue;
            }
            SetScriptSourceRequest request = new SetScriptSourceRequest();
            request.setScriptId(script.getScriptId());
            request.setScriptSource(fileSource);
            phaser.register();
            this.dbg.getConnection().getDebugger().setScriptSource(request).handle((res, thr) -> {
                LOG.fine("A ChangeLive command finished.");
                phaser.arriveAndDeregister();
                return null;
            });
            LOG.log(Level.FINE, "Running ChangeLive command for script {0}", script.getUrl().toASCIIString());
        }
        phaser.arriveAndAwaitAdvance();
    }

    private void destroy() {
        if (this.sourceChangeRoots.length == 0) {
            FileUtil.removeFileChangeListener((FileChangeListener)this.sourceChangeListener);
        } else {
            for (File root : this.sourceChangeRoots) {
                FileUtil.removeRecursiveListener((FileChangeListener)this.sourceChangeListener, (File)root);
            }
        }
    }

    private final class FileChangeDelivery
    implements Runnable {
        private final List<FileObject> changedFiles = new LinkedList<FileObject>();

        private FileChangeDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(FileObject file) {
            List<FileObject> list = this.changedFiles;
            synchronized (list) {
                this.changedFiles.add(file);
            }
            ChangeLiveSupport.this.setHasChanges(true);
        }

        @Override
        public void run() {
            this.applyChanges();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void applyChanges() {
            ArrayList<FileObject> modifiedFiles;
            List<FileObject> list = this.changedFiles;
            synchronized (list) {
                modifiedFiles = new ArrayList<FileObject>(this.changedFiles);
                this.changedFiles.clear();
            }
            ChangeLiveSupport.this.setHasChanges(false);
            ChangeLiveSupport.this.rp.post(new Runnable(){

                @Override
                public void run() {
                    ChangeLiveSupport.this.applyModifiedFiles(modifiedFiles);
                }
            });
        }
    }

    private final class SourceChangeListener
    implements FileChangeListener {
        private SourceChangeListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            ChangeLiveSupport.this.fileChangeDelivery.add(fe.getFile());
            fe.runWhenDeliveryOver((Runnable)ChangeLiveSupport.this.fileChangeDelivery);
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

