/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.cache;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.cache.AbstractDiskCache;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.tooling.internal.NbProjectInfo;

public final class ProjectInfoDiskCache
extends AbstractDiskCache<GradleFiles, QualifiedProjectInfo> {
    private static final int COMPATIBLE_CACHE_VERSION = 25;
    private static final String INFO_CACHE_FILE_NAME = "project-info.ser";
    private static final Map<GradleFiles, ProjectInfoDiskCache> DISK_CACHES = Collections.synchronizedMap(new WeakHashMap());

    public static ProjectInfoDiskCache get(GradleFiles gf) {
        ProjectInfoDiskCache ret = DISK_CACHES.computeIfAbsent(gf, k -> new ProjectInfoDiskCache((GradleFiles)k));
        return ret;
    }

    private ProjectInfoDiskCache(GradleFiles gf) {
        super(gf);
    }

    public static void testFlushCaches() {
        DISK_CACHES.clear();
    }

    public static boolean testDestroyCache(GradleFiles gf) {
        ProjectInfoDiskCache cache = ProjectInfoDiskCache.get(gf);
        if (cache == null) {
            return false;
        }
        File f = cache.cacheFile();
        return f.exists() && f.delete();
    }

    @Override
    protected int cacheVersion() {
        return 25;
    }

    @Override
    protected File cacheFile() {
        return new File(NbGradleProjectImpl.getCacheDir((GradleFiles)this.key), INFO_CACHE_FILE_NAME);
    }

    @Override
    protected Set<File> cacheInvalidators() {
        HashSet<File> ret = new HashSet<File>(((GradleFiles)this.key).getProjectFiles());
        if (((GradleFiles)this.key).hasWrapper()) {
            ret.add(((GradleFiles)this.key).getWrapperProperties());
        }
        return ret;
    }

    private static CacheReport makeReport(NbProjectInfo.Report r) {
        CacheReport nested = r.getCause() != null ? ProjectInfoDiskCache.makeReport(r.getCause()) : null;
        return new CacheReport(r.getSeverity(), r.getErrorClass(), r.getScriptLocation(), r.getLineNumber(), r.getMessage(), r.getDetail(), nested);
    }

    private static Set<NbProjectInfo.Report> makeReports(Collection<NbProjectInfo.Report> reps) {
        LinkedHashSet<NbProjectInfo.Report> res = new LinkedHashSet<NbProjectInfo.Report>();
        for (NbProjectInfo.Report r : reps) {
            res.add(ProjectInfoDiskCache.makeReport(r));
        }
        return res;
    }

    static final class CacheReport
    implements NbProjectInfo.Report,
    Serializable {
        private final String errorClass;
        private final String location;
        private final int line;
        private final String message;
        private final String detail;
        private final NbProjectInfo.Report causedBy;
        private final NbProjectInfo.Report.Severity severity;

        public CacheReport(NbProjectInfo.Report.Severity severity, String errorClass, String location, int line, String message, String detail, NbProjectInfo.Report causedBy) {
            this.severity = severity;
            this.errorClass = errorClass;
            this.location = location;
            this.line = line;
            this.message = message;
            this.detail = detail;
            this.causedBy = causedBy;
        }

        public CacheReport(NbProjectInfo.Report.Severity severity, String message, String detail) {
            this.severity = severity;
            this.errorClass = null;
            this.location = null;
            this.line = -1;
            this.message = message;
            this.detail = detail;
            this.causedBy = null;
        }

        @Override
        public String getErrorClass() {
            return this.errorClass;
        }

        @Override
        public String getScriptLocation() {
            return this.location;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        @NonNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @CheckForNull
        public NbProjectInfo.Report getCause() {
            return this.causedBy;
        }

        @Override
        public NbProjectInfo.Report.Severity getSeverity() {
            return this.severity;
        }

        @Override
        public String getDetail() {
            return this.detail;
        }

        public int hashCode() {
            int hash = 3;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheReport other = (CacheReport)obj;
            if (this.line != other.line) {
                return false;
            }
            if (!Objects.equals(this.errorClass, other.errorClass)) {
                return false;
            }
            if (!Objects.equals(this.location, other.location)) {
                return false;
            }
            if (!Objects.equals((Object)this.severity, (Object)other.severity)) {
                return false;
            }
            return Objects.equals(this.message, other.message);
        }
    }

    public static final class QualifiedProjectInfo
    implements NbProjectInfo {
        private final NbGradleProject.Quality quality;
        private final Map<String, Object> info;
        private final transient Map<String, Object> ext;
        private final Set<String> problems;
        private final Set<NbProjectInfo.Report> reports;
        private final String gradleException;

        public QualifiedProjectInfo(NbGradleProject.Quality quality, NbProjectInfo pinfo) {
            this.quality = quality;
            this.info = new TreeMap<String, Object>(pinfo.getInfo());
            this.ext = new TreeMap<String, Object>(pinfo.getExt());
            this.problems = new LinkedHashSet<String>(pinfo.getProblems());
            this.gradleException = pinfo.getGradleException();
            this.reports = ProjectInfoDiskCache.makeReports(pinfo.getReports());
        }

        @Override
        public Map<String, Object> getInfo() {
            return this.info;
        }

        @Override
        public Map<String, Object> getExt() {
            return this.ext != null ? this.ext : Collections.emptyMap();
        }

        @Override
        public Set<String> getProblems() {
            return this.problems;
        }

        @Override
        public Set<NbProjectInfo.Report> getReports() {
            return this.reports;
        }

        @Override
        public String getGradleException() {
            return this.gradleException;
        }

        @Override
        public boolean hasException() {
            return this.gradleException != null;
        }

        @Override
        public boolean getMiscOnly() {
            return false;
        }

        public NbGradleProject.Quality getQuality() {
            return this.quality;
        }

        public String toString() {
            return "QualifiedProjectInfo{quality=" + this.quality + "}";
        }
    }
}

