/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.java.file.launcher.api.SourceLauncher;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SharedRootData {
    private static final Logger LOG = Logger.getLogger(SharedRootData.class.getName());
    private static final Map<FileObject, SharedRootData> root2Data = new HashMap<FileObject, SharedRootData>();
    private final FileObject root;
    private final Map<String, String> options = new TreeMap<String, String>();
    private final FileChangeListener listener = new FileChangeAdapter(){

        public void fileAttributeChanged(FileAttributeEvent fe) {
            HashMap<String, String> newProperties = new HashMap<String, String>();
            SharedRootData.this.addPropertiesFor(fe.getFile(), newProperties);
            SharedRootData.this.setNewProperties(newProperties);
        }

        public void fileDeleted(FileEvent fe) {
            HashMap<String, String> newProperties = new HashMap<String, String>();
            newProperties.put(FileUtil.getRelativePath((FileObject)SharedRootData.this.root, (FileObject)fe.getFile()), null);
            SharedRootData.this.setNewProperties(newProperties);
        }
    };

    public static synchronized void ensureRootRegistered(FileObject root) {
        root2Data.computeIfAbsent(root, r -> new SharedRootData((FileObject)r));
    }

    @CheckForNull
    public static synchronized SharedRootData getDataForRoot(FileObject root) {
        return root2Data.get(root);
    }

    private SharedRootData(FileObject root) {
        this.root = root;
        root.addRecursiveListener(this.listener);
        Enumeration todo = root.getChildren(true);
        HashMap<String, String> newProperties = new HashMap<String, String>();
        while (todo.hasMoreElements()) {
            FileObject current = (FileObject)todo.nextElement();
            this.addPropertiesFor(current, newProperties);
        }
        this.setNewProperties(newProperties);
    }

    private void addPropertiesFor(FileObject file, Map<String, String> newProperties) {
        if (file.isData() && "text/x-java".equals(file.getMIMEType())) {
            newProperties.put(FileUtil.getRelativePath((FileObject)this.root, (FileObject)file), (String)file.getAttribute("single_file_vm_options"));
        }
    }

    private synchronized void setNewProperties(Map<String, String> newProperties) {
        if (newProperties.isEmpty()) {
            return;
        }
        for (String key : newProperties.keySet()) {
            String value = newProperties.get(key);
            if (value == null) {
                this.options.remove(key);
                continue;
            }
            this.options.put(key, value);
        }
        String joinedCommandLine = SourceLauncher.joinCommandLines(this.options.values());
        try {
            if (!joinedCommandLine.equals(this.root.getAttribute("single_file_vm_options"))) {
                this.root.setAttribute("single_file_vm_options", (Object)joinedCommandLine);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Failed to set single_file_vm_options for " + this.root.getPath(), ex);
        }
    }
}

