/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl;

import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.ResolvedProperty;
import org.netbeans.modules.css.model.api.Expression;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Prio;
import org.netbeans.modules.css.model.api.Property;
import org.netbeans.modules.css.model.api.PropertyDeclaration;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.impl.ModelElement;
import org.netbeans.modules.css.model.impl.ModelElementListener;
import org.openide.filesystems.FileObject;

public class PropertyDeclarationI
extends ModelElement
implements PropertyDeclaration {
    private Property property;
    private PropertyValue propertyValue;
    private Prio prio;
    private ResolvedProperty resolvedProperty;
    private final ModelElementListener elementListener = new ModelElementListener.Adapter(){

        @Override
        public void elementAdded(PropertyValue value) {
            PropertyDeclarationI.this.propertyValue = value;
        }

        @Override
        public void elementAdded(Property value) {
            PropertyDeclarationI.this.property = value;
        }

        @Override
        public void elementAdded(Prio value) {
            PropertyDeclarationI.this.prio = value;
        }
    };

    public PropertyDeclarationI(Model model) {
        super(model);
        this.addTextElement(this.getIndent());
        this.addEmptyElement(Property.class);
        this.addTextElement(":");
        this.addTextElement(" ");
        this.addEmptyElement(PropertyValue.class);
        this.addEmptyElement(Prio.class);
    }

    public PropertyDeclarationI(Model model, Node node) {
        super(model, node);
        this.initChildrenElements();
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public void setProperty(Property property) {
        this.setElement(property);
    }

    @Override
    public PropertyValue getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        this.setElement(value);
    }

    @Override
    public Prio getPrio() {
        return this.prio;
    }

    @Override
    public void setPrio(Prio prio) {
        this.setElement(prio);
    }

    @Override
    protected ModelElementListener getElementListener() {
        return this.elementListener;
    }

    @Override
    protected Class getModelClass() {
        return PropertyDeclaration.class;
    }

    @Override
    public synchronized ResolvedProperty getResolvedProperty() {
        PropertyDefinition pmodel;
        FileObject file = (FileObject)this.getModel().getLookup().lookup(FileObject.class);
        if (this.resolvedProperty == null && (pmodel = Properties.getPropertyDefinition((String)this.getProperty().getContent().toString().trim())) != null) {
            Expression expression = this.getPropertyValue().getExpression();
            CharSequence content = expression != null ? expression.getContent() : "";
            this.resolvedProperty = ResolvedProperty.resolve((FileObject)file, (PropertyDefinition)pmodel, (CharSequence)content);
        }
        return this.resolvedProperty;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("(");
        Property p = this.getProperty();
        b.append(p == null ? "null" : p.getContent());
        PropertyValue pv = this.getPropertyValue();
        b.append(":");
        Expression e = pv == null ? null : pv.getExpression();
        b.append(e == null ? "null" : e.getContent());
        b.append(this.getPrio() == null ? "" : "!");
        b.append(")");
        return b.toString();
    }
}

