/*
SRPageInfoController.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import <HMDTFoundation/HMDTFoundation.h>
#import <HMDTAppKit/HMDTAppKit.h>
#import <HMDTWebKit/HMDTWebKit.h>

// Notifications
extern NSString*    SRPageInfoLinkSelectedNotification;

// Constants
enum {
    SRPageInfoSearchLinkAll = 1, 
    SRPageInfoSerachLinkURL, 
    SRPageInfoSearchLinkText, 
};

@class SRPageController;

@interface SRPageInfoController : NSWindowController
{
    SRPageController*               _pageController;
    
    NSMutableArray*                 _profiles;
    BOOL                            _isInitialized;
    
    int                             _linksSearchType;
    
    NSMatrix*                       _imagesMatrix;
    NSMutableArray*                 _images;
    
    NSMutableSet*                   _DOMNodes;
    
    IBOutlet NSObjectController*    _objectController;
    
    IBOutlet HMSplitView*           _splitView;
    IBOutlet HMTableView*           _profileTableView;
    IBOutlet NSView*                _infoView;
    
    IBOutlet NSView*                _generalView;
    IBOutlet NSTreeController*      _httpHeaderTreeController;
    IBOutlet NSOutlineView*         _httpHeaderOutlineView;
    
    IBOutlet NSView*                _linksView;
    IBOutlet NSArrayController*     _linksArrayController;
    IBOutlet NSSearchField*         _linksSearchField;
    IBOutlet NSMenu*                _linksSearchMenu;
    IBOutlet HMSplitView*           _linksSplitView;
    IBOutlet NSTableView*           _linksTableView;
    IBOutlet NSScrollView*          _linksScrollView;
    IBOutlet NSView*                _linksLowerView;
    IBOutlet NSView*                _linksTextView;
    IBOutlet NSView*                _linksImageView;

    IBOutlet NSView*                _domTreesView;
    IBOutlet HMSplitView*           _domTreesSplitView;
    IBOutlet NSOutlineView*         _domTreesOutlineView;
    IBOutlet NSOutlineView*         _domTreesDomOutlineView;
    IBOutlet NSOutlineView*         _domTreesDomAttrOutlineView;
    
    IBOutlet NSView*                _cookiesView;
    IBOutlet NSArrayController*     _cookiesArrayController;
    
    IBOutlet NSView*                _cssView;
    IBOutlet NSArrayController*     _cssArrayController;
    IBOutlet HMSplitView*           _cssSplitView;
    IBOutlet NSTableView*           _cssTableView;
    IBOutlet NSTextView*            _cssTextView;
    
    IBOutlet NSView*                _javaScriptView;
    IBOutlet NSArrayController*     _javaScriptArrayController;
    IBOutlet HMSplitView*           _javaScriptSplitView;
    IBOutlet NSTableView*           _javaScriptTableView;
    IBOutlet NSTextView*            _javaScriptTextView;
    
    IBOutlet NSView*                _imagesView;
    IBOutlet NSObjectController*    _imagesObjectController;
    IBOutlet NSMutableDictionary*   _imagesContent;
    IBOutlet HMSplitView*           _imagesSplitView;
    IBOutlet NSScrollView*          _imagesMatrixScrollView;
    IBOutlet NSView*                _imagesLowerView;
    IBOutlet NSScrollView*          _imagesImageScrollView;
    IBOutlet NSView*                _imagesImageView;
    
    IBOutlet NSView*                _sourceView;
    IBOutlet NSTreeController*      _sourceTreeController;
    IBOutlet HMSplitView*           _sourceSplitView;
    IBOutlet NSOutlineView*         _sourceOutlineView;
    IBOutlet NSTextView*            _sourceTextView;
    
    IBOutlet NSView*                _otherView;
    IBOutlet NSArrayController*     _otherArrayController;
    IBOutlet HMSplitView*           _otherSplitView;
    IBOutlet NSTableView*           _otherTableView;
    IBOutlet NSScrollView*          _otherScrollView;
    IBOutlet NSView*                _otherLowerView;
    IBOutlet NSView*                _otherTextView;
    IBOutlet NSView*                _otherWebView;
    IBOutlet WebView*               _otherWebWebView;
}

// Initialize
+ (SRPageInfoController*)pageInfoControllerWithPageController:(SRPageController*)pageController;

// Page info handling
- (NSString*)URLString;

- (NSString*)profileTitle;
- (void)setProfileWithTitle:(NSString*)title;

- (void)setPageController:(SRPageController*)pageController;

@end
