//
//  Tree.h
//  X-MasTree
//
//  Created by John Schilling on 11/8/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ShapedView.h"
#import "ShapedWindow.h"

@interface Tree : NSWindowController {

    IBOutlet ShapedWindow   *_treeWindow;
    
    NSSize                  _sizes[4];
    int                     _currentSize;
    
    NSImage                 *_treeImage;
    
    NSImage                 *_redLights0;
    NSImage                 *_redLights1;
    NSImage                 *_greenLights0;
    NSImage                 *_greenLights1;
    NSImage                 *_blueLights0;
    NSImage                 *_blueLights1;
    NSImage                 *_purpleLights0;
    NSImage                 *_purpleLights1;
    
    NSImage                 *_oldredLights0;
    NSImage                 *_oldredLights1;
    NSImage                 *_oldgreenLights0;
    NSImage                 *_oldgreenLights1;
    NSImage                 *_oldblueLights0;
    NSImage                 *_oldblueLights1;
    NSImage                 *_oldpurpleLights0;
    NSImage                 *_oldpurpleLights1;
    
    NSImage                 *_ornamentsRed;
    NSImage                 *_ornamentsGreen;
    NSImage                 *_ornamentsBlue;
    NSImage                 *_ornamentsPurple;
    
    NSImage                 *_popcorn;
    NSImage                 *_tinsel;
    
    NSImage                 *_starOn;
    NSImage                 *_starOff;
    
    NSImage                 *_badgerRed;
    NSImage                 *_badgerGreen;
    
    NSImage                 *_customBottom;
    NSImage                 *_customTop;
    
    NSMutableDictionary     *_fontAttributes;
    
    BOOL                    _hasShadow;
    
    int                     _treeSize;
    
    int                     _starBlinkTicks;
    int                     _starBlinkTicksMax;
    BOOL                    _starLit;
    
    int                     _lightAlternateNumber;
    
    int                     _lightsRedBlinkTicks;
    int                     _lightsRedBlinkTicksMax;
    BOOL                    _lightsRedBlinkOn;
    int                     _lightsRedFadeOnTicks;
    int                     _lightsRedFadeOnMaxTicks;
    BOOL                    _lightsRedFadingUp;
    float                   _lightsRedAlpha;
    
    int                     _lightsGreenBlinkTicks;
    int                     _lightsGreenBlinkTicksMax;
    BOOL                    _lightsGreenBlinkOn;
    int                     _lightsGreenFadeOnTicks;
    int                     _lightsGreenFadeOnMaxTicks;
    BOOL                    _lightsGreenFadingUp;
    float                   _lightsGreenAlpha;
    
    int                     _lightsBlueBlinkTicks;
    int                     _lightsBlueBlinkTicksMax;
    BOOL                    _lightsBlueBlinkOn;
    int                     _lightsBlueFadeOnTicks;
    int                     _lightsBlueFadeOnMaxTicks;
    BOOL                    _lightsBlueFadingUp;
    float                   _lightsBlueAlpha;
    
    int                     _lightsPurpleBlinkTicks;
    int                     _lightsPurpleBlinkTicksMax;
    BOOL                    _lightsPurpleBlinkOn;
    int                     _lightsPurpleFadeOnTicks;
    int                     _lightsPurpleFadeOnMaxTicks;
    BOOL                    _lightsPurpleFadingUp;
    float                   _lightsPurpleAlpha;
}

- (id)initNewTreeWithSize:(int)treeSize 
                    color:(int)treeColor 
               withShadow:(BOOL)withShadow 
              windowLevel:(int)windowLevel;

- (void)loadTreeForSize:(int)treeSize color:(int)treeColor;
- (void)loadLightsForSize:(int)size;
- (NSImage *)lightsForColor:(NSString *)color style:(int)style density:(int)density size:(int)size;
- (void)loadOrnamentsForSize:(int)size;
- (NSImage *)ornamentsForColor:(NSString *)color size:(int)size;
- (void)loadPopcornAndTinselForSize:(int)size;
- (void)loadStarsForSize:(int)size;
- (void)loadCustomOrnamentsForSize:(int)size;
- (void)loadBadgers;

- (NSWindow *)treeWindow;
- (void)setWindowLevel:(int)windowLevel;
- (void)setHasShadow:(BOOL)hasShadow;
- (void)resetShadow;
- (void)saveTreeFrame;
- (void)displayTree;
- (void)updateTreeForSize:(int)treeSize treeColor:(int)treeColor;
- (void)drawTree;
- (void)drawDockIcon;

- (void)clearStateVariables;
- (float)randBetween:(float)x And:(float)y;

@end
