/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zip.compress;

import com.android.tools.build.apkzlib.zip.CompressionResult;
import com.android.tools.build.apkzlib.zip.Compressor;
import com.android.tools.build.apkzlib.zip.utils.CloseableByteSource;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public abstract class ExecutorCompressor
implements Compressor {
    @Nonnull
    private final Executor executor;

    public ExecutorCompressor(@Nonnull Executor executor) {
        this.executor = executor;
    }

    @Override
    @Nonnull
    public ListenableFuture<CompressionResult> compress(@Nonnull CloseableByteSource source) {
        SettableFuture<CompressionResult> future = SettableFuture.create();
        this.executor.execute(() -> {
            try {
                future.set(this.immediateCompress(source));
            }
            catch (Throwable e) {
                future.setException(e);
            }
        });
        return future;
    }

    @Nonnull
    protected abstract CompressionResult immediateCompress(@Nonnull CloseableByteSource var1) throws Exception;
}

