/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.IAppConstants;
import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.jcd.cls.AbstractClassDefVisitor;
import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.ElementFactory;
import com.vladium.jcd.cls.Field_info;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IFieldCollection;
import com.vladium.jcd.cls.IInterfaceCollection;
import com.vladium.jcd.cls.IMethodCollection;
import com.vladium.jcd.cls.Method_info;
import com.vladium.jcd.cls.attribute.AttributeElementFactory;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.BridgeAttribute_info;
import com.vladium.jcd.cls.attribute.CodeAttribute_info;
import com.vladium.jcd.cls.attribute.ConstantValueAttribute_info;
import com.vladium.jcd.cls.attribute.Exception_info;
import com.vladium.jcd.cls.attribute.ExceptionsAttribute_info;
import com.vladium.jcd.cls.attribute.GenericAttribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.IExceptionHandlerTable;
import com.vladium.jcd.cls.attribute.InnerClassesAttribute_info;
import com.vladium.jcd.cls.attribute.LineNumberTableAttribute_info;
import com.vladium.jcd.cls.attribute.LineNumber_info;
import com.vladium.jcd.cls.attribute.SourceFileAttribute_info;
import com.vladium.jcd.cls.attribute.SyntheticAttribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Class_info;
import com.vladium.jcd.cls.constant.CONSTANT_Long_info;
import com.vladium.jcd.cls.constant.CONSTANT_Methodref_info;
import com.vladium.jcd.cls.constant.CONSTANT_String_info;
import com.vladium.jcd.compiler.CodeGen;
import com.vladium.jcd.lib.Types;
import com.vladium.jcd.opcodes.IOpcodes;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.IConstants;
import com.vladium.util.IntIntMap;
import com.vladium.util.IntObjectMap;
import com.vladium.util.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class InstrVisitor
extends AbstractClassDefVisitor
implements IClassDefVisitor,
IAttributeVisitor,
IOpcodes,
IConstants {
    private final boolean m_excludeSyntheticMethods;
    private final boolean m_excludeBridgeMethods;
    private final boolean m_doSUIDCompensation;
    private final Logger m_log;
    private boolean m_warningIssued;
    private boolean m_instrument;
    private boolean m_metadata;
    private boolean m_ignoreAlreadyInstrumented;
    ClassDef m_cls;
    private String m_classPackageName;
    private String m_className;
    private String m_classSrcFileName;
    private int[][][] m_classBlockMetadata;
    private MethodDescriptor[] m_classMethodDescriptors;
    private int m_syntheticStringIndex;
    int m_coverageFieldrefIndex;
    private int m_registerMethodrefIndex;
    int m_preclinitMethodrefIndex;
    int m_classNameConstantIndex;
    private int m_stampIndex;
    private int m_clinitID;
    private int m_clinitStatus;
    int m_classInstrMethodCount;
    int[] m_classBlockCounts;
    private long m_classSignature;
    int m_methodID;
    private String m_methodName;
    private int m_methodFirstLine;
    private int[] m_methodBlockOffsets;
    private int[] m_methodBlockSizes;
    private int[] m_methodJumpAdjOffsets;
    private int[] m_methodJumpAdjValues;
    private static final long NBEAST = 16661L;
    private static final String COVERAGE_FIELD_NAME = "$VRc";
    private static final String SUID_FIELD_NAME = "serialVersionUID";
    private static final String PRECLINIT_METHOD_NAME = "$VRi";
    private static final String JAVA_IO_SERIALIZABLE_NAME = "java/io/Serializable";
    private static final String JAVA_IO_EXTERNALIZABLE_NAME = "java/io/Externalizable";
    private static final int EMIT_CTX_MIN_INIT_CAPACITY = 64;
    private static final int PRECLINIT_INIT_CAPACITY = 128;
    private static final boolean MARK_ADDED_ELEMENTS_SYNTHETIC = true;
    private static final boolean SKIP_SYNTHETIC_CLASSES = false;
    private static final LineNumberComparator LINE_NUMBER_COMPARATOR = new LineNumberComparator();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public InstrVisitor(CoverageOptions coverageOptions) {
        this.m_excludeSyntheticMethods = coverageOptions.excludeSyntheticMethods();
        this.m_excludeBridgeMethods = coverageOptions.excludeBridgeMethods();
        this.m_doSUIDCompensation = coverageOptions.doSUIDCompensation();
        this.m_log = Logger.getLogger();
    }

    public void process(ClassDef classDef, boolean bl, boolean bl2, boolean bl3, InstrResult instrResult) {
        instrResult.m_instrumented = false;
        instrResult.m_descriptor = null;
        if (!bl2 && !bl3) {
            return;
        }
        if (classDef.isInterface()) {
            return;
        }
        this.reset();
        this.m_cls = classDef;
        this.m_instrument = bl2;
        this.m_metadata = bl3;
        this.m_ignoreAlreadyInstrumented = bl;
        this.visit((ClassDef)null, null);
        if (this.m_metadata) {
            this.setClassName(classDef.getName());
            instrResult.m_descriptor = new ClassDescriptor(this.m_classPackageName, this.m_className, this.m_classSignature, this.m_classSrcFileName, this.m_classMethodDescriptors);
        }
        instrResult.m_instrumented = this.m_instrument;
    }

    public Object visit(ClassDef classDef, Object object) {
        Object object2;
        ClassDef classDef2 = this.m_cls;
        String string = classDef2.getName();
        String string2 = Types.vmNameToJavaName(string);
        boolean bl = this.m_log.atTRACE1();
        if (bl) {
            this.m_log.trace1("visit", "class: [" + string + "]");
        }
        if (!this.m_warningIssued && string2.startsWith(IAppConstants.APP_PACKAGE)) {
            this.m_warningIssued = true;
            this.m_log.warning("EMMA classes appear to be included on the instrumentation");
            this.m_log.warning("path: this is not a correct way to use EMMA");
        }
        if (((int[])(object2 = classDef2.getFields(COVERAGE_FIELD_NAME))).length > 0) {
            this.m_instrument = false;
            this.m_metadata = false;
            if (this.m_ignoreAlreadyInstrumented) {
                if (bl) {
                    this.m_log.trace1("visit", "skipping instrumented class");
                }
                return object;
            }
            throw new IllegalStateException("class [" + string2 + "] appears to be instrumented already");
        }
        object2 = classDef2.getConstants();
        SyntheticAttribute_info syntheticAttribute_info = null;
        this.m_syntheticStringIndex = classDef2.addCONSTANT_Utf8("Synthetic", true);
        IAttributeCollection iAttributeCollection = ElementFactory.newAttributeCollection(1);
        syntheticAttribute_info = new SyntheticAttribute_info(this.m_syntheticStringIndex);
        iAttributeCollection.add(syntheticAttribute_info);
        int n = classDef2.addField(COVERAGE_FIELD_NAME, "[[Z", 26, iAttributeCollection);
        this.m_coverageFieldrefIndex = classDef2.addFieldref(n);
        int n2 = classDef2.addClassref("com/vladium/emma/rt/RT");
        int n3 = classDef2.addNameType("r", "([[ZLjava/lang/String;J)V");
        this.m_registerMethodrefIndex = object2.add(new CONSTANT_Methodref_info(n2, n3));
        n2 = classDef2.addNameType(PRECLINIT_METHOD_NAME, "()[[Z");
        this.m_preclinitMethodrefIndex = object2.add(new CONSTANT_Methodref_info(classDef2.getThisClassIndex(), n2));
        this.m_classNameConstantIndex = object2.add(new CONSTANT_String_info(classDef2.getThisClass().m_name_index));
        this.visit(classDef2.getMethods(), object);
        if (this.m_doSUIDCompensation) {
            Object object3;
            n = (this.m_clinitStatus & 8) != 0 ? 1 : 0;
            n2 = 0;
            if (n != 0) {
                int n4;
                int[] nArray = classDef2.getFields(SUID_FIELD_NAME);
                n2 = nArray.length;
                if (n2 > 0) {
                    IFieldCollection iFieldCollection = classDef2.getFields();
                    for (n4 = 0; n4 < n2; ++n4) {
                        Field_info field_info = iFieldCollection.get(nArray[n4]);
                        if ((field_info.getAccessFlags() & 0x18) != 24) continue;
                        n = 0;
                        break;
                    }
                }
                if (n != 0 && classDef2.getThisClassIndex() == 0) {
                    boolean bl2 = false;
                    IInterfaceCollection iInterfaceCollection = classDef2.getInterfaces();
                    int n5 = iInterfaceCollection.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        CONSTANT_Class_info cONSTANT_Class_info = (CONSTANT_Class_info)object2.get(iInterfaceCollection.get(n4));
                        object3 = cONSTANT_Class_info.getName(classDef2);
                        if (!JAVA_IO_SERIALIZABLE_NAME.equals(object3) && !JAVA_IO_EXTERNALIZABLE_NAME.equals(object3)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        n = 0;
                    }
                }
            }
            if (n != 0) {
                if (n2 > 0) {
                    this.m_log.warning("class [" + string2 + "] declares a 'serialVersionUID'");
                    this.m_log.warning("field that is not static and final: this is likely an implementation mistake");
                    this.m_log.warning("and can interfere with EMMA's SUID compensation");
                }
                IAttributeCollection iAttributeCollection2 = ElementFactory.newAttributeCollection(2);
                int n6 = classDef2.addCONSTANT_Utf8("ConstantValue", true);
                int n7 = object2.add(new CONSTANT_Long_info(classDef2.computeSUID(true)));
                object3 = new ConstantValueAttribute_info(n6, n7);
                iAttributeCollection2.add((Attribute_info)object3);
                if (syntheticAttribute_info == null) {
                    syntheticAttribute_info = new SyntheticAttribute_info(this.m_syntheticStringIndex);
                }
                iAttributeCollection2.add(syntheticAttribute_info);
                classDef2.addField(SUID_FIELD_NAME, "J", 26, iAttributeCollection2);
            }
        }
        this.visit(classDef2.getAttributes(), object);
        return object;
    }

    public Object visit(IMethodCollection iMethodCollection, Object object) {
        int n;
        int n2;
        int n3;
        Method_info method_info;
        ClassDef classDef = this.m_cls;
        boolean bl = this.m_log.atTRACE2();
        int n4 = iMethodCollection.size();
        boolean bl2 = this.m_metadata;
        this.m_classBlockCounts = new int[n4 + 1];
        if (bl2) {
            this.m_classBlockMetadata = new int[n4 + 1][][];
            this.m_classMethodDescriptors = new MethodDescriptor[n4];
        }
        for (int i = 0; i < n4; ++i) {
            method_info = iMethodCollection.get(i);
            this.m_methodName = method_info.getName(classDef);
            if (bl) {
                this.m_log.trace2("visit", (method_info.isSynthetic() ? "synthetic " : "") + "method #" + i + ": [" + this.m_methodName + "]");
            }
            n3 = "<clinit>".equals(this.m_methodName) ? 1 : 0;
            n2 = 0;
            if (n3 == 0) {
                if (this.m_excludeSyntheticMethods && method_info.isSynthetic()) {
                    n2 = 1;
                    if (bl) {
                        this.m_log.trace2("visit", "skipped synthetic method");
                    }
                } else if (this.m_excludeBridgeMethods && method_info.isBridge()) {
                    n2 = 1;
                    if (bl) {
                        this.m_log.trace2("visit", "skipped bridge method");
                    }
                }
            }
            if (n2 != 0) {
                if (!bl2) continue;
                this.m_classMethodDescriptors[i] = new MethodDescriptor(this.m_methodName, method_info.getDescriptor(classDef), 4, this.m_methodBlockSizes, null, 0);
                continue;
            }
            if ((method_info.getAccessFlags() & 0x500) != 0) {
                if (bl2) {
                    this.m_classMethodDescriptors[i] = new MethodDescriptor(this.m_methodName, method_info.getDescriptor(classDef), 2, this.m_methodBlockSizes, null, 0);
                }
                if (!bl) continue;
                this.m_log.trace2("visit", "skipped " + (method_info.isAbstract() ? "abstract" : "native") + " method");
                continue;
            }
            this.m_methodFirstLine = 0;
            this.m_methodID = i;
            if (n3 != 0) {
                this.m_clinitID = i;
                if (!bl) continue;
                this.m_log.trace2("visit", "<clinit> method delayed");
                continue;
            }
            IAttributeCollection iAttributeCollection = method_info.getAttributes();
            int n5 = iAttributeCollection.size();
            for (int j = 0; j < n5; ++j) {
                Attribute_info attribute_info = iAttributeCollection.get(j);
                attribute_info.accept(this, object);
            }
            if (!bl2) continue;
            int[][] nArray = this.m_classBlockMetadata[this.m_methodID];
            int n6 = nArray == null ? 1 : 0;
            this.m_classMethodDescriptors[i] = new MethodDescriptor(this.m_methodName, method_info.getDescriptor(classDef), n6, this.m_methodBlockSizes, nArray, this.m_methodFirstLine);
        }
        if (this.m_clinitID >= 0) {
            method_info = iMethodCollection.get(this.m_clinitID);
            this.m_classInstrMethodCount = n4;
        } else {
            this.m_clinitStatus = 8;
            n3 = classDef.addCONSTANT_Utf8("Code", true);
            n2 = classDef.addCONSTANT_Utf8("<clinit>", true);
            int n7 = classDef.addCONSTANT_Utf8("()V", true);
            IAttributeCollection iAttributeCollection = ElementFactory.newAttributeCollection(2);
            CodeAttribute_info codeAttribute_info = new CodeAttribute_info(n3, 0, 0, new byte[]{-79}, AttributeElementFactory.newExceptionHandlerTable(0), ElementFactory.newAttributeCollection(0));
            iAttributeCollection.add(codeAttribute_info);
            iAttributeCollection.add(new SyntheticAttribute_info(this.m_syntheticStringIndex));
            method_info = new Method_info(10, n2, n7, iAttributeCollection);
            this.m_clinitID = classDef.addMethod(method_info);
            if (bl) {
                this.m_log.trace2("visit", "added synthetic <clinit> method");
            }
            this.m_classInstrMethodCount = n4 + 1;
        }
        this.m_methodFirstLine = 0;
        this.m_methodID = this.m_clinitID;
        if (bl) {
            this.m_log.trace2("visit", (method_info.isSynthetic() ? "synthetic " : "") + "method #" + this.m_methodID + ": [<clinit>]");
        }
        IAttributeCollection iAttributeCollection = method_info.getAttributes();
        n2 = iAttributeCollection.size();
        for (n = 0; n < n2; ++n) {
            Attribute_info attribute_info = iAttributeCollection.get(n);
            attribute_info.accept(this, object);
        }
        int n8 = classDef.addCONSTANT_Utf8("Code", true);
        n2 = classDef.addCONSTANT_Utf8(PRECLINIT_METHOD_NAME, false);
        n = classDef.addCONSTANT_Utf8("()[[Z", false);
        IAttributeCollection iAttributeCollection2 = ElementFactory.newAttributeCollection(2);
        ByteArrayOStream byteArrayOStream = new ByteArrayOStream(128);
        Object object2 = this.m_classBlockCounts;
        int n9 = this.m_classInstrMethodCount;
        CodeGen.push_int_value(byteArrayOStream, classDef, n9);
        int n10 = classDef.addClassref("[[Z");
        byteArrayOStream.write4(197, n10 >>> 8, n10, 1);
        byteArrayOStream.write4(89, 179, this.m_coverageFieldrefIndex >>> 8, this.m_coverageFieldrefIndex);
        for (int i = 0; i < n9; ++i) {
            int n11 = object2[i];
            if (n11 <= 0) continue;
            byteArrayOStream.write(89);
            CodeGen.push_int_value(byteArrayOStream, classDef, i);
            CodeGen.push_int_value(byteArrayOStream, classDef, n11);
            byteArrayOStream.write3(188, 4, 83);
        }
        byteArrayOStream.write(89);
        CodeGen.push_constant_index(byteArrayOStream, this.m_classNameConstantIndex);
        byteArrayOStream.write3(20, this.m_stampIndex >>> 8, this.m_stampIndex);
        byteArrayOStream.write3(184, this.m_registerMethodrefIndex >>> 8, this.m_registerMethodrefIndex);
        byteArrayOStream.write(176);
        object2 = new CodeAttribute_info(n8, 5, 0, EMPTY_BYTE_ARRAY, AttributeElementFactory.newExceptionHandlerTable(0), ElementFactory.newAttributeCollection(0));
        ((CodeAttribute_info)object2).setCode(byteArrayOStream.getByteArray(), byteArrayOStream.size());
        iAttributeCollection2.add((Attribute_info)object2);
        iAttributeCollection2.add(new SyntheticAttribute_info(this.m_syntheticStringIndex));
        Method_info method_info2 = new Method_info(10, n2, n, iAttributeCollection2);
        classDef.addMethod(method_info2);
        if (bl) {
            this.m_log.trace2("visit", "added synthetic pre-<clinit> method");
        }
        if (bl2) {
            int[][] nArray = this.m_classBlockMetadata[this.m_methodID];
            this.m_clinitStatus |= nArray == null ? 1 : 0;
            if ((this.m_clinitStatus & 8) == 0) {
                this.m_classMethodDescriptors[this.m_methodID] = new MethodDescriptor("<clinit>", method_info.getDescriptor(classDef), this.m_clinitStatus, this.m_methodBlockSizes, nArray, this.m_methodFirstLine);
            }
        }
        return object;
    }

    public Object visit(IAttributeCollection iAttributeCollection, Object object) {
        int n = iAttributeCollection.size();
        for (int i = 0; i < n; ++i) {
            iAttributeCollection.get(i).accept(this, object);
        }
        return object;
    }

    public Object visit(CodeAttribute_info codeAttribute_info, Object object) {
        int n;
        int n2;
        int n3;
        Block block;
        int n4;
        int n5;
        boolean bl = this.m_log.atTRACE2();
        boolean bl2 = this.m_log.atTRACE3();
        byte[] byArray = codeAttribute_info.getCode();
        int n6 = codeAttribute_info.getCodeSize();
        if (bl) {
            this.m_log.trace2("visit", "code attribute for method #" + this.m_methodID + ": size = " + n6);
        }
        IntSet intSet = new IntSet();
        IntIntMap intIntMap = new IntIntMap();
        intSet.add(0);
        IExceptionHandlerTable iExceptionHandlerTable = codeAttribute_info.getExceptionTable();
        int n7 = iExceptionHandlerTable.size();
        for (int i = 0; i < n7; ++i) {
            Exception_info exception_info = iExceptionHandlerTable.get(i);
            intSet.add(exception_info.m_handler_pc);
        }
        IntObjectMap intObjectMap = new IntObjectMap();
        boolean bl3 = false;
        boolean bl4 = false;
        int n8 = 0;
        intIntMap.put(0, 0);
        int n9 = 0;
        while (n9 < n6) {
            int n10 = 0xFF & byArray[n9];
            int n11 = 0;
            if (bl3) {
                intSet.add(n9);
                bl3 = false;
            }
            switch (n10) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    int n12 = n9 + 1;
                    int n13 = byArray[n12] << 8 | 0xFF & byArray[++n12];
                    n5 = n9 + n13;
                    intSet.add(n5);
                    intObjectMap.put(n9, new IFJUMP2(n10, n5));
                    bl3 = true;
                    break;
                }
                case 167: 
                case 168: {
                    int n12 = n9 + 1;
                    int n13 = byArray[n12] << 8 | 0xFF & byArray[++n12];
                    n5 = n9 + n13;
                    intSet.add(n5);
                    intObjectMap.put(n9, new JUMP2(n10, n5));
                    bl3 = true;
                    break;
                }
                case 171: {
                    int n14;
                    int n12 = n9 + 4 - (n9 & 3);
                    int n13 = byArray[n12] << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                    intSet.add(n9 + n13);
                    n5 = (0xFF & byArray[++n12]) << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                    int[] nArray = new int[n5];
                    int[] nArray2 = new int[n5 + 1];
                    nArray2[0] = n9 + n13;
                    for (n4 = 0; n4 < n5; ++n4) {
                        nArray[n4] = n14 = byArray[++n12] << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                        n13 = byArray[++n12] << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                        nArray2[n4 + 1] = n9 + n13;
                        intSet.add(n9 + n13);
                    }
                    intObjectMap.put(n9, new LOOKUPSWITCH(nArray, nArray2));
                    bl3 = true;
                    n11 = n9 - n12 - 1;
                    break;
                }
                case 170: {
                    int n12 = n9 + 4 - (n9 & 3);
                    int n13 = byArray[n12] << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                    intSet.add(n9 + n13);
                    n5 = byArray[++n12] << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                    int n15 = byArray[++n12] << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                    int[] nArray2 = new int[n15 - n5 + 2];
                    nArray2[0] = n9 + n13;
                    for (n4 = n5; n4 <= n15; ++n4) {
                        n13 = byArray[++n12] << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                        nArray2[n4 - n5 + 1] = n9 + n13;
                        intSet.add(n9 + n13);
                    }
                    intObjectMap.put(n9, new TABLESWITCH(n5, n15, nArray2));
                    bl3 = true;
                    n11 = n9 - n12 - 1;
                    break;
                }
                case 200: 
                case 201: {
                    int n12 = n9 + 1;
                    int n13 = byArray[n12] << 24 | (0xFF & byArray[++n12]) << 16 | (0xFF & byArray[++n12]) << 8 | 0xFF & byArray[++n12];
                    n5 = n9 + n13;
                    intSet.add(n5);
                    intObjectMap.put(n9, new JUMP4(n10, n5));
                    bl3 = true;
                    break;
                }
                case 169: {
                    int n12 = n9 + 1;
                    int n14 = bl4 ? (0xFF & byArray[n12]) << 8 | 0xFF & byArray[++n12] : 0xFF & byArray[n12];
                    intObjectMap.put(n9, new RET(n10, n14));
                    bl3 = true;
                    break;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    intObjectMap.put(n9, new TERMINATE(n10));
                    bl3 = true;
                }
            }
            n11 = n11 == 0 ? (bl4 ? WIDE_SIZE : NARROW_SIZE)[n10] : -n11;
            bl4 = n10 == 196;
            intIntMap.put(n9 += n11, ++n8);
        }
        n9 = intSet.size();
        if (bl) {
            this.m_log.trace2("visit", "method contains " + n9 + " basic blocks");
        }
        BlockList blockList = new BlockList(n9);
        int[] nArray = new int[n9 + 1];
        intSet.values(nArray, 0);
        nArray[n9] = n6;
        Arrays.sort(nArray);
        int[] nArray3 = intObjectMap.keys();
        Arrays.sort(nArray3);
        IntIntMap intIntMap2 = new IntIntMap(nArray.length);
        if (this.m_metadata) {
            this.m_methodBlockSizes = new int[n9];
            this.m_methodBlockOffsets = nArray;
        }
        this.consumeSignatureData(this.m_methodID, nArray);
        int[] nArray4 = new int[1];
        n5 = 0;
        n4 = 0;
        for (int i = 0; i < n9; ++i) {
            int n16;
            int n17;
            block = new Block();
            blockList.m_blocks.add(block);
            block.m_first = n17 = nArray[i];
            intIntMap2.put(n17, i);
            n3 = nArray[i + 1];
            n2 = 0;
            int n18 = n5;
            if (nArray3.length > n4 && (n16 = nArray3[n4]) < n3) {
                n2 = 1;
                block.m_length = n16 - n17;
                intIntMap.get(n16, nArray4);
                n5 = nArray4[0] + 1;
                block.m_branch = (Branch)intObjectMap.get(n16);
                block.m_branch.m_parentBlockID = i;
                ++n4;
            }
            if (n2 == 0) {
                block.m_length = n3 - n17;
                intIntMap.get(n3, nArray4);
                n5 = nArray4[0];
            }
            block.m_instrCount = n5 - n18;
            if (!this.m_metadata) continue;
            this.m_methodBlockSizes[i] = block.m_instrCount;
        }
        Block[] blockArray = blockList.m_blocks.toArray(new Block[n9]);
        for (n4 = 0; n4 < n9; ++n4) {
            int[] nArray5;
            block = blockArray[n4];
            if (block.m_branch == null || (nArray5 = block.m_branch.m_targets) == null) continue;
            n2 = nArray5.length;
            for (n3 = 0; n3 < n2; ++n3) {
                intIntMap2.get(nArray5[n3], nArray4);
                nArray5[n3] = nArray4[0];
            }
        }
        this.m_classBlockCounts[this.m_methodID] = n9;
        if (bl) {
            this.m_log.trace2("visit", "instrumenting... ");
        }
        n4 = codeAttribute_info.m_max_locals++;
        if (this.m_methodID == this.m_clinitID) {
            this.m_stampIndex = this.m_cls.getConstants().add(new CONSTANT_Long_info(this.m_classSignature));
            blockList.m_header = new clinitHeader(this, n4);
        } else {
            blockList.m_header = new methodHeader(this, n4);
        }
        int n19 = blockList.m_header.maxstack();
        int n20 = 0;
        for (n3 = 0; n3 < n9; ++n3) {
            Block block2 = blockArray[n3];
            BlockSegment blockSegment = new BlockSegment(this, n4, n3);
            block2.m_insertion = blockSegment;
            int n21 = ((CodeSegment)blockSegment).maxstack();
            if (n21 <= n20) continue;
            n20 = n21;
        }
        n3 = codeAttribute_info.m_max_stack;
        codeAttribute_info.m_max_stack += n20;
        if (n19 > codeAttribute_info.m_max_stack) {
            codeAttribute_info.m_max_stack = n19;
        }
        if (bl2) {
            this.m_log.trace3("visit", "increasing maxstack by " + (codeAttribute_info.m_max_stack - n3));
        }
        if (bl) {
            this.m_log.trace2("visit", "assembling... ");
        }
        if ((n4 = n6 << 1) < 64) {
            n4 = 64;
        }
        ByteArrayOStream byteArrayOStream = new ByteArrayOStream(n4);
        EmitCtx emitCtx = new EmitCtx(blockList, byteArrayOStream);
        int[] nArray6 = new int[n9];
        int[] nArray7 = new int[nArray6.length];
        blockList.m_header.emit(emitCtx);
        nArray7[0] = emitCtx.m_out.size();
        for (int i = 0; i < n9; ++i) {
            Block block3 = blockArray[i];
            if (i + 1 < n9) {
                nArray6[i + 1] = blockArray[i].m_first + blockArray[i].m_length;
            }
            block3.emit(emitCtx, byArray);
            if (i + 1 >= n9) continue;
            nArray7[i + 1] = emitCtx.m_out.size() - blockArray[i + 1].m_first;
        }
        this.m_methodJumpAdjOffsets = nArray6;
        this.m_methodJumpAdjValues = nArray7;
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer("jump adjustment map:" + EOL);
            for (int i = 0; i < nArray6.length; ++i) {
                stringBuffer.append("    " + nArray6[i] + ": +" + nArray7[i]);
                if (i >= nArray6.length - 1) continue;
                stringBuffer.append(EOL);
            }
            this.m_log.trace3("visit", stringBuffer.toString());
        }
        byte[] byArray2 = byteArrayOStream.getByteArray();
        int n22 = byteArrayOStream.size();
        if (bl2) {
            this.m_log.trace3("visit", "backpatching " + emitCtx.m_backpatchQueue.size() + " ip(s)");
        }
        for (int[] nArray8 : emitCtx.m_backpatchQueue) {
            int n23 = nArray8[1];
            n = blockArray[nArray8[3]].m_first - nArray8[2];
            switch (nArray8[0]) {
                case 4: {
                    byArray2[n23++] = (byte)(n >>> 24);
                    byArray2[n23++] = (byte)(n >>> 16);
                }
                case 2: {
                    byArray2[n23++] = (byte)(n >>> 8);
                    byArray2[n23] = (byte)n;
                }
            }
        }
        codeAttribute_info.setCode(byArray2, n22);
        if (bl) {
            this.m_log.trace2("visit", "method assembled into " + n22 + " code bytes");
        }
        IExceptionHandlerTable iExceptionHandlerTable2 = codeAttribute_info.getExceptionTable();
        for (int i = 0; i < iExceptionHandlerTable2.size(); ++i) {
            Exception_info exception_info = iExceptionHandlerTable2.get(i);
            n = InstrVisitor.lowbound(nArray6, exception_info.m_start_pc);
            exception_info.m_start_pc += nArray7[n];
            n = InstrVisitor.lowbound(nArray6, exception_info.m_end_pc);
            exception_info.m_end_pc += nArray7[n];
            n = InstrVisitor.lowbound(nArray6, exception_info.m_handler_pc);
            exception_info.m_handler_pc += nArray7[n];
        }
        IAttributeCollection iAttributeCollection = codeAttribute_info.getAttributes();
        int n24 = iAttributeCollection.size();
        for (n = 0; n < n24; ++n) {
            Attribute_info attribute_info = iAttributeCollection.get(n);
            attribute_info.accept(this, object);
        }
        return object;
    }

    public Object visit(LineNumberTableAttribute_info lineNumberTableAttribute_info, Object object) {
        int n;
        Object object2;
        int n2;
        boolean bl = this.m_log.atTRACE2();
        boolean bl2 = this.m_log.atTRACE3();
        if (bl) {
            this.m_log.trace2("visit", "attribute: [" + lineNumberTableAttribute_info.getName(this.m_cls) + "]");
        }
        int n3 = lineNumberTableAttribute_info.size();
        if (this.m_metadata) {
            Object object3;
            if (bl) {
                this.m_log.trace2("visit", "processing line number table for metadata...");
            }
            n2 = this.m_classBlockCounts[this.m_methodID];
            object2 = new int[n2][];
            if (n3 == 0) {
                for (n = 0; n < n2; ++n) {
                    object2[n] = EMPTY_INT_ARRAY;
                }
            } else {
                LineNumber_info[] lineNumber_infoArray = new LineNumber_info[lineNumberTableAttribute_info.size()];
                for (int i = 0; i < n3; ++i) {
                    object3 = lineNumberTableAttribute_info.get(i);
                    lineNumber_infoArray[i] = object3;
                }
                Arrays.sort(lineNumber_infoArray, LINE_NUMBER_COMPARATOR);
                int[] nArray = this.m_methodBlockOffsets;
                object3 = lineNumber_infoArray[0];
                Object object4 = null;
                this.m_methodFirstLine = ((LineNumber_info)object3).m_line_number;
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    IntSet intSet = new IntSet();
                    if (object4 != null && ((LineNumber_info)object3).m_start_pc > nArray[i]) {
                        intSet.add(((LineNumber_info)object4).m_line_number);
                    }
                    while (((LineNumber_info)object3).m_start_pc < nArray[i + 1]) {
                        intSet.add(((LineNumber_info)object3).m_line_number);
                        if (n4 == n3 - 1) break;
                        object4 = object3;
                        object3 = lineNumber_infoArray[++n4];
                    }
                    object2[i] = intSet.values();
                }
            }
            this.m_classBlockMetadata[this.m_methodID] = (int[][])object2;
            if (bl2) {
                StringBuffer stringBuffer = new StringBuffer("block-line map for method #" + this.m_methodID + ":");
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(EOL);
                    stringBuffer.append("    block " + i + ": ");
                    object3 = object2[i];
                    for (int j = 0; j < ((Object)object3).length; ++j) {
                        if (j != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append((int)object3[j]);
                    }
                }
                this.m_log.trace3("visit", stringBuffer.toString());
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = lineNumberTableAttribute_info.get(n2);
            n = InstrVisitor.lowbound(this.m_methodJumpAdjOffsets, ((LineNumber_info)object2).m_start_pc);
            ((LineNumber_info)object2).m_start_pc += this.m_methodJumpAdjValues[n];
        }
        return object;
    }

    public Object visit(ExceptionsAttribute_info exceptionsAttribute_info, Object object) {
        return object;
    }

    public Object visit(ConstantValueAttribute_info constantValueAttribute_info, Object object) {
        return object;
    }

    public Object visit(SourceFileAttribute_info sourceFileAttribute_info, Object object) {
        this.m_classSrcFileName = sourceFileAttribute_info.getSourceFile((ClassDef)this.m_cls).m_value;
        return object;
    }

    public Object visit(SyntheticAttribute_info syntheticAttribute_info, Object object) {
        return object;
    }

    public Object visit(BridgeAttribute_info bridgeAttribute_info, Object object) {
        return object;
    }

    public Object visit(InnerClassesAttribute_info innerClassesAttribute_info, Object object) {
        return object;
    }

    public Object visit(GenericAttribute_info genericAttribute_info, Object object) {
        return object;
    }

    private void setClassName(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            this.m_classPackageName = "";
            this.m_className = string;
        } else {
            this.m_classPackageName = string.substring(0, n);
            this.m_className = string.substring(n + 1);
        }
    }

    private void consumeSignatureData(int n, int[] nArray) {
        int n2 = nArray.length;
        long l = 16661L * this.m_classSignature + (long)((n + 1) * n2);
        for (int i = 1; i < n2; ++i) {
            l = 16661L * l + (long)nArray[i];
        }
        this.m_classSignature = l;
    }

    private static int lowbound(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = nArray[n4];
            if (n5 == n) {
                return n4;
            }
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n3;
    }

    private void reset() {
        this.m_instrument = false;
        this.m_metadata = false;
        this.m_ignoreAlreadyInstrumented = false;
        this.m_cls = null;
        this.m_classPackageName = null;
        this.m_className = null;
        this.m_classSrcFileName = null;
        this.m_classBlockMetadata = null;
        this.m_classMethodDescriptors = null;
        this.m_syntheticStringIndex = -1;
        this.m_coverageFieldrefIndex = -1;
        this.m_registerMethodrefIndex = -1;
        this.m_preclinitMethodrefIndex = -1;
        this.m_classNameConstantIndex = -1;
        this.m_clinitID = -1;
        this.m_clinitStatus = 0;
        this.m_classInstrMethodCount = -1;
        this.m_classBlockCounts = null;
        this.m_classSignature = 0L;
        this.m_methodID = -1;
        this.m_methodName = null;
        this.m_methodFirstLine = 0;
        this.m_methodBlockOffsets = null;
        this.m_methodJumpAdjOffsets = null;
        this.m_methodJumpAdjValues = null;
    }

    private static final class LineNumberComparator
    implements Comparator {
        private LineNumberComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((LineNumber_info)object).m_start_pc - ((LineNumber_info)object2).m_start_pc;
        }
    }

    static final class BlockSegment
    extends CodeSegment {
        private final ByteArrayOStream m_buf;
        private static final int BLOCK_INIT_CAPACITY = 16;

        public BlockSegment(InstrVisitor instrVisitor, int n, int n2) {
            super(instrVisitor);
            ByteArrayOStream byteArrayOStream;
            this.m_buf = byteArrayOStream = new ByteArrayOStream(16);
            ClassDef classDef = instrVisitor.m_cls;
            CodeGen.load_local_object_var(byteArrayOStream, n);
            CodeGen.push_int_value(byteArrayOStream, classDef, n2);
            byteArrayOStream.write2(4, 84);
        }

        int length() {
            return this.m_buf.size();
        }

        int maxstack() {
            return 3;
        }

        void emit(EmitCtx emitCtx) {
            try {
                this.m_buf.writeTo(emitCtx.m_out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static final class methodHeader
    extends CodeSegment {
        private final ByteArrayOStream m_buf;
        private static final int HEADER_INIT_CAPACITY = 16;

        methodHeader(InstrVisitor instrVisitor, int n) {
            super(instrVisitor);
            ByteArrayOStream byteArrayOStream;
            this.m_buf = byteArrayOStream = new ByteArrayOStream(16);
            ClassDef classDef = instrVisitor.m_cls;
            int n2 = instrVisitor.m_coverageFieldrefIndex;
            int n3 = instrVisitor.m_preclinitMethodrefIndex;
            byteArrayOStream.write4(178, n2 >>> 8, n2, 89);
            byteArrayOStream.write3(199, 0, 7);
            byteArrayOStream.write4(87, 184, n3 >>> 8, n3);
            CodeGen.push_int_value(byteArrayOStream, classDef, instrVisitor.m_methodID);
            byteArrayOStream.write(50);
            CodeGen.store_local_object_var(byteArrayOStream, n);
        }

        int length() {
            return this.m_buf.size();
        }

        int maxstack() {
            return 2;
        }

        void emit(EmitCtx emitCtx) {
            try {
                this.m_buf.writeTo(emitCtx.m_out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static final class clinitHeader
    extends CodeSegment {
        private final ByteArrayOStream m_buf;
        private static final int CLINIT_HEADER_INIT_CAPACITY = 32;

        clinitHeader(InstrVisitor instrVisitor, int n) {
            super(instrVisitor);
            ByteArrayOStream byteArrayOStream;
            this.m_buf = byteArrayOStream = new ByteArrayOStream(32);
            ClassDef classDef = instrVisitor.m_cls;
            int[] nArray = instrVisitor.m_classBlockCounts;
            int n2 = instrVisitor.m_classInstrMethodCount;
            int n3 = instrVisitor.m_coverageFieldrefIndex;
            int n4 = instrVisitor.m_preclinitMethodrefIndex;
            int n5 = instrVisitor.m_classNameConstantIndex;
            byteArrayOStream.write3(184, n4 >>> 8, n4);
            CodeGen.push_int_value(byteArrayOStream, classDef, instrVisitor.m_methodID);
            byteArrayOStream.write(50);
            CodeGen.store_local_object_var(byteArrayOStream, n);
        }

        int length() {
            return this.m_buf.size();
        }

        int maxstack() {
            return 2;
        }

        void emit(EmitCtx emitCtx) {
            try {
                this.m_buf.writeTo(emitCtx.m_out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static abstract class CodeSegment {
        final InstrVisitor m_visitor;

        CodeSegment(InstrVisitor instrVisitor) {
            this.m_visitor = instrVisitor;
        }

        abstract int length();

        abstract int maxstack();

        abstract void emit(EmitCtx var1);
    }

    static final class TABLESWITCH
    extends Branch {
        final int m_low;
        final int m_high;

        TABLESWITCH(int n, int n2, int[] nArray) {
            super(170, nArray);
            this.m_low = n;
            this.m_high = n2;
        }

        int maxlength() {
            return 12 + (this.m_targets.length << 2);
        }

        void emit(EmitCtx emitCtx) {
            int n;
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            int n2 = byteArrayOStream.size();
            byteArrayOStream.write(this.m_opcode);
            int n3 = 3 - (n2 & 3);
            for (n = 0; n < n3; ++n) {
                byteArrayOStream.write(0);
            }
            this.emitJumpOffset4(emitCtx, n2, this.m_targets[0]);
            n = this.m_low;
            byteArrayOStream.write4(n >>> 24, n >>> 16, n >>> 8, n);
            n3 = this.m_high;
            byteArrayOStream.write4(n3 >>> 24, n3 >>> 16, n3 >>> 8, n3);
            for (int i = 1; i < this.m_targets.length; ++i) {
                this.emitJumpOffset4(emitCtx, n2, this.m_targets[i]);
            }
        }
    }

    static final class LOOKUPSWITCH
    extends Branch {
        final int[] m_keys;

        LOOKUPSWITCH(int[] nArray, int[] nArray2) {
            super(171, nArray2);
            this.m_keys = nArray;
        }

        int maxlength() {
            return 12 + (this.m_keys.length << 3);
        }

        void emit(EmitCtx emitCtx) {
            int n;
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            int n2 = byteArrayOStream.size();
            byteArrayOStream.write(this.m_opcode);
            int n3 = 3 - (n2 & 3);
            for (n = 0; n < n3; ++n) {
                byteArrayOStream.write(0);
            }
            this.emitJumpOffset4(emitCtx, n2, this.m_targets[0]);
            n = this.m_keys.length;
            byteArrayOStream.write4(n >>> 24, n >>> 16, n >>> 8, n);
            for (n3 = 1; n3 < this.m_targets.length; ++n3) {
                int n4 = this.m_keys[n3 - 1];
                byteArrayOStream.write4(n4 >>> 24, n4 >>> 16, n4 >>> 8, n4);
                this.emitJumpOffset4(emitCtx, n2, this.m_targets[n3]);
            }
        }
    }

    static final class IFJUMP2
    extends Branch {
        IFJUMP2(int n, int n2) {
            super(n, new int[]{n2});
        }

        int maxlength() {
            return 8;
        }

        void emit(EmitCtx emitCtx) {
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            int n = this.m_targets[0];
            int n2 = byteArrayOStream.size();
            byteArrayOStream.write(this.m_opcode);
            this.emitJumpOffset2(emitCtx, n2, n);
        }
    }

    static final class JUMP4
    extends Branch {
        JUMP4(int n, int n2) {
            super(n, new int[]{n2});
        }

        int maxlength() {
            return 5;
        }

        void emit(EmitCtx emitCtx) {
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            int n = this.m_targets[0];
            int n2 = byteArrayOStream.size();
            byteArrayOStream.write(this.m_opcode);
            this.emitJumpOffset4(emitCtx, n2, n);
        }
    }

    static final class JUMP2
    extends Branch {
        JUMP2(int n, int n2) {
            super(n, new int[]{n2});
        }

        int maxlength() {
            return 5;
        }

        void emit(EmitCtx emitCtx) {
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            int n = this.m_targets[0];
            int n2 = byteArrayOStream.size();
            byteArrayOStream.write(this.m_opcode);
            this.emitJumpOffset2(emitCtx, n2, n);
        }
    }

    static final class RET
    extends Branch {
        final int m_varindex;

        RET(int n, int n2) {
            super(n, null);
            this.m_varindex = n2;
        }

        int length() {
            return this.m_varindex <= 255 ? 2 : 3;
        }

        void emit(EmitCtx emitCtx) {
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            if (this.m_varindex <= 255) {
                byteArrayOStream.write2(this.m_opcode, this.m_varindex);
            } else {
                byteArrayOStream.write4(196, this.m_opcode, this.m_varindex >>> 8, this.m_varindex);
            }
        }
    }

    static final class TERMINATE
    extends Branch {
        TERMINATE(int n) {
            super(n, null);
        }

        int length() {
            return 1;
        }

        void emit(EmitCtx emitCtx) {
            emitCtx.m_out.write(this.m_opcode);
        }
    }

    static abstract class Branch {
        final byte m_opcode;
        final int[] m_targets;
        int m_parentBlockID;

        protected Branch(int n, int[] nArray) {
            this.m_opcode = (byte)n;
            this.m_targets = nArray;
        }

        int maxlength() {
            return 1;
        }

        abstract void emit(EmitCtx var1);

        protected final void emitJumpOffset2(EmitCtx emitCtx, int n, int n2) {
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            if (n2 <= this.m_parentBlockID) {
                int n3 = ((Block)emitCtx.m_blocks.m_blocks.get((int)n2)).m_first - n;
                byteArrayOStream.write2(n3 >>> 8, n3);
            } else {
                int n4 = byteArrayOStream.size();
                byteArrayOStream.write2(0, 0);
                emitCtx.m_backpatchQueue.add(new int[]{2, n4, n, n2});
            }
        }

        protected final void emitJumpOffset4(EmitCtx emitCtx, int n, int n2) {
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            if (n2 <= this.m_parentBlockID) {
                int n3 = ((Block)emitCtx.m_blocks.m_blocks.get((int)n2)).m_first - n;
                byteArrayOStream.write4(n3 >>> 24, n3 >>> 16, n3 >>> 8, n3);
            } else {
                int n4 = byteArrayOStream.size();
                byteArrayOStream.write4(0, 0, 0, 0);
                emitCtx.m_backpatchQueue.add(new int[]{4, n4, n, n2});
            }
        }
    }

    static final class EmitCtx {
        final BlockList m_blocks;
        final ByteArrayOStream m_out;
        final List m_backpatchQueue;

        EmitCtx(BlockList blockList, ByteArrayOStream byteArrayOStream) {
            this.m_blocks = blockList;
            this.m_out = byteArrayOStream;
            this.m_backpatchQueue = new ArrayList();
        }
    }

    private static final class Block {
        int m_first;
        int m_length;
        int m_instrCount;
        public CodeSegment m_insertion;
        public Branch m_branch;

        private Block() {
        }

        void emit(EmitCtx emitCtx, byte[] byArray) {
            ByteArrayOStream byteArrayOStream = emitCtx.m_out;
            int n = this.m_first;
            this.m_first = byteArrayOStream.size();
            int n2 = this.m_length;
            for (int i = 0; i < n2; ++i) {
                byteArrayOStream.write(byArray[n + i]);
            }
            if (this.m_insertion != null) {
                this.m_insertion.emit(emitCtx);
            }
            if (this.m_branch != null) {
                this.m_branch.emit(emitCtx);
            }
        }
    }

    private static final class BlockList {
        final List m_blocks;
        CodeSegment m_header;

        BlockList() {
            this.m_blocks = new ArrayList();
        }

        BlockList(int n) {
            this.m_blocks = new ArrayList(n);
        }
    }

    public static final class InstrResult {
        public boolean m_instrumented;
        public ClassDescriptor m_descriptor;
    }
}

