/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.report.IItemAttribute;
import java.util.Comparator;

public interface ItemComparator
extends Comparator {
    public static final ItemComparator NULL_COMPARATOR = new Factory.NullComparator();

    public static abstract class Factory {
        public static ItemComparator create(int[] nArray, int n) {
            if (nArray == null) {
                throw new IllegalArgumentException("null input: attributeIDsWithDir");
            }
            if (nArray.length == 0) {
                return NULL_COMPARATOR;
            }
            Comparator[] comparatorArray = new Comparator[nArray.length >> 1];
            for (int i = 0; i < nArray.length; i += 2) {
                int n2 = nArray[i];
                Comparator comparator = IItemAttribute.Factory.getAttribute(n2, n).comparator();
                comparatorArray[i >> 1] = nArray[i + 1] < 0 ? new ReverseComparator(comparator) : comparator;
            }
            return new CompositeComparator(comparatorArray);
        }

        private static final class CompositeComparator
        implements ItemComparator {
            private final Comparator[] m_comparators;

            public int compare(Object object, Object object2) {
                for (int i = 0; i < this.m_comparators.length; ++i) {
                    int n = this.m_comparators[i].compare(object, object2);
                    if (n == 0) continue;
                    return n;
                }
                return 0;
            }

            CompositeComparator(Comparator[] comparatorArray) {
                this.m_comparators = comparatorArray;
            }
        }

        private static final class ReverseComparator
        implements ItemComparator {
            private final Comparator m_comparator;

            public int compare(Object object, Object object2) {
                return this.m_comparator.compare(object2, object);
            }

            ReverseComparator(Comparator comparator) {
                this.m_comparator = comparator;
            }
        }

        private static final class NullComparator
        implements ItemComparator {
            private NullComparator() {
            }

            public int compare(Object object, Object object2) {
                return 0;
            }
        }
    }
}

