/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.report.html.doc.AttributeSet;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.IContent;
import com.vladium.emma.report.html.doc.IElementList;
import com.vladium.emma.report.html.doc.ISimpleElement;
import com.vladium.emma.report.html.doc.Tag;
import com.vladium.emma.report.html.doc.Text;
import java.util.ArrayList;
import java.util.List;

public interface IElement
extends ISimpleElement,
IElementList {
    public IElement setText(String var1, boolean var2);

    public static abstract class Factory {
        public static IElement create(Tag tag) {
            return new ElementImpl(tag, AttributeSet.create());
        }

        public static IElement create(Tag tag, AttributeSet attributeSet) {
            return new ElementImpl(tag, attributeSet);
        }

        static class ElementImpl
        extends ISimpleElement.Factory.SimpleElementImpl
        implements IElement {
            protected final List m_contents = new ArrayList();
            private static final boolean DEBUG_HTML = false;

            public String toString() {
                return "<" + this.m_tag.getName() + ">";
            }

            public void emit(HTMLWriter hTMLWriter) {
                String string = this.m_tag.getName();
                hTMLWriter.write('<');
                hTMLWriter.write(string);
                if (!this.m_attrs.isEmpty()) {
                    hTMLWriter.write(' ');
                    this.m_attrs.emit(hTMLWriter);
                }
                hTMLWriter.write('>');
                for (IContent iContent : this.m_contents) {
                    iContent.emit(hTMLWriter);
                }
                hTMLWriter.write("</");
                hTMLWriter.write(string);
                hTMLWriter.write('>');
            }

            public IElementList add(IContent iContent) {
                if (iContent != null) {
                    this.m_contents.add(iContent);
                }
                return this;
            }

            public IElementList add(int n, IContent iContent) {
                if (iContent != null) {
                    this.m_contents.add(n, iContent);
                }
                return this;
            }

            public int size() {
                return this.m_contents.size();
            }

            public IElement setText(String string, boolean bl) {
                if (string != null) {
                    this.m_contents.clear();
                    this.m_contents.add(new Text(string, bl));
                }
                return this;
            }

            ElementImpl(Tag tag, AttributeSet attributeSet) {
                super(tag, attributeSet);
            }
        }
    }
}

