/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.xml;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemAttribute;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;

public final class ReportGenerator
extends AbstractReportGenerator
implements IAppErrorCodes {
    private IndentingWriter m_out;
    private static final String TYPE = "xml";
    private static final int IO_BUF_SIZE = 65536;

    public String getType() {
        return TYPE;
    }

    public void process(IMetaData iMetaData, ICoverageData iCoverageData, SourcePathCache sourcePathCache, IProperties iProperties) throws EMMARuntimeException {
        this.initialize(iMetaData, iCoverageData, sourcePathCache, iProperties);
        long l = 0L;
        boolean bl = this.m_log.atTRACE1();
        if (bl) {
            l = System.currentTimeMillis();
        }
        this.m_view.getRoot().accept(this, null);
        this.close();
        if (bl) {
            long l2 = System.currentTimeMillis();
            this.m_log.trace1("process", "[" + this.getType() + "] report generated in " + (l2 - l) + " ms");
        }
    }

    public void cleanup() {
        this.close();
        super.cleanup();
    }

    public Object visit(AllItem allItem, Object object) {
        try {
            Object object2;
            File file = this.m_settings.getOutFile();
            if (file == null) {
                file = new File("coverage.xml");
                this.m_settings.setOutFile(file);
            }
            File file2 = Files.newFile(this.m_settings.getOutDir(), file);
            this.m_log.info("writing [" + this.getType() + "] report to [" + file2.getAbsolutePath() + "] ...");
            this.openOutFile(file2, this.m_settings.getOutEncoding(), true);
            this.m_out.write("<?xml version=\"1.0\" encoding=\"" + this.m_settings.getOutEncoding() + "\"?>");
            try {
                object2 = new StringBuffer(101);
                ((StringBuffer)object2).append("<!-- ");
                ((StringBuffer)object2).append("EMMA");
                ((StringBuffer)object2).append(" v");
                ((StringBuffer)object2).append("0.0.0 (unsupported private build)");
                ((StringBuffer)object2).append(" report, generated ");
                ((StringBuffer)object2).append(new Date(EMMAProperties.getTimeStamp()));
                ((StringBuffer)object2).append(" -->");
                this.m_out.write(((StringBuffer)object2).toString());
                this.m_out.newLine();
                this.m_out.flush();
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
            }
            this.eol();
            this.openElementTag("report");
            this.closeElementTag(false);
            this.m_out.incIndent();
            this.eol();
            this.openElementTag("stats");
            this.closeElementTag(false);
            this.m_out.incIndent();
            this.emitStatsCount("packages", allItem.getChildCount());
            this.emitStatsCount("classes", allItem.getAggregate(11));
            this.emitStatsCount("methods", allItem.getAggregate(10));
            if (this.m_srcView && this.m_hasSrcFileInfo) {
                this.emitStatsCount("srcfiles", allItem.getAggregate(12));
                if (this.m_hasLineNumberInfo) {
                    this.emitStatsCount("srclines", allItem.getAggregate(7));
                }
            }
            this.m_out.decIndent();
            this.eol();
            this.endElement("stats");
            this.eol();
            this.openElementTag("data");
            this.closeElementTag(false);
            this.m_out.incIndent();
            object2 = this.m_typeSortComparators[PackageItem.getTypeMetadata().getTypeID()];
            this.emitItem(allItem, (ItemComparator)object2);
            this.m_out.decIndent();
            this.eol();
            this.endElement("data");
            this.m_out.decIndent();
            this.eol();
            this.endElement("report");
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
        return object;
    }

    public Object visit(PackageItem packageItem, Object object) {
        if (this.m_verbose) {
            this.m_log.verbose("  report: processing package [" + packageItem.getName() + "] ...");
        }
        try {
            ItemComparator itemComparator = this.m_typeSortComparators[this.m_srcView ? SrcFileItem.getTypeMetadata().getTypeID() : ClassItem.getTypeMetadata().getTypeID()];
            this.emitItem(packageItem, itemComparator);
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
        return object;
    }

    public Object visit(SrcFileItem srcFileItem, Object object) {
        try {
            ItemComparator itemComparator = this.m_typeSortComparators[ClassItem.getTypeMetadata().getTypeID()];
            this.emitItem(srcFileItem, itemComparator);
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
        return object;
    }

    public Object visit(ClassItem classItem, Object object) {
        try {
            ItemComparator itemComparator = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
            this.emitItem(classItem, itemComparator);
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
        return object;
    }

    public Object visit(MethodItem methodItem, Object object) {
        try {
            this.emitItem(methodItem, null);
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
        return object;
    }

    private void emitStatsCount(String string, int n) throws IOException {
        this.eol();
        this.openElementTag(string);
        this.m_out.write(" value=\"" + n);
        this.m_out.write(34);
        this.closeElementTag(true);
    }

    private void emitItem(IItem iItem, ItemComparator itemComparator) throws IOException {
        boolean bl;
        IItemMetadata iItemMetadata = iItem.getMetadata();
        int[] nArray = this.m_settings.getColumnOrder();
        String string = iItemMetadata.getTypeName();
        this.eol();
        this.openElementTag(string);
        this.m_out.write(" name=\"");
        this.m_out.write(Strings.HTMLEscape(iItem.getName()));
        this.m_out.write(34);
        this.closeElementTag(false);
        this.eol();
        this.m_out.incIndent();
        this.emitItemCoverage(iItem, nArray);
        boolean bl2 = bl = itemComparator != null && this.m_settings.getDepth() > iItemMetadata.getTypeID() && iItem.getChildCount() > 0;
        if (bl) {
            Iterator iterator = iItem.getChildren(itemComparator);
            while (iterator.hasNext()) {
                ((IItem)iterator.next()).accept(this, null);
            }
            this.eol();
        }
        this.m_out.decIndent();
        this.endElement(string);
    }

    private void emitItemCoverage(IItem iItem, int[] nArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int n : nArray) {
            IItemAttribute iItemAttribute;
            if (n == 0 || (iItemAttribute = iItem.getAttribute(n, this.m_settings.getUnitsType())) == null) continue;
            this.openElementTag("coverage");
            this.m_out.write(" type=\"");
            this.m_out.write(Strings.HTMLEscape(iItemAttribute.getName()));
            this.m_out.write("\" value=\"");
            iItemAttribute.format(iItem, stringBuffer);
            this.m_out.write(Strings.HTMLEscape(stringBuffer.toString()));
            this.m_out.write(34);
            stringBuffer.setLength(0);
            this.closeElementTag(true);
            this.eol();
        }
    }

    private void openElementTag(String string) throws IOException {
        this.m_out.write(60);
        this.m_out.write(string);
    }

    private void closeElementTag(boolean bl) throws IOException {
        if (bl) {
            this.m_out.write("/>");
        } else {
            this.m_out.write(62);
        }
    }

    private void endElement(String string) throws IOException {
        this.m_out.write("</");
        this.m_out.write(string);
        this.m_out.write(62);
    }

    private void eol() throws IOException {
        this.m_out.newLine();
    }

    private void close() {
        if (this.m_out != null) {
            try {
                this.m_out.flush();
                this.m_out.close();
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
            }
            finally {
                this.m_out = null;
            }
        }
    }

    private void openOutFile(File file, String string, boolean bl) {
        try {
            File file2;
            if (bl && (file2 = file.getParentFile()) != null) {
                file2.mkdirs();
            }
            this.m_out = new IndentingWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string), 65536, 0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EMMARuntimeException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException(iOException);
        }
    }

    private static final class IndentingWriter
    extends BufferedWriter {
        private int m_indent;
        private int m_state;
        private transient String m_sindent;
        private static final int INDENT_INCREMENT = 2;

        public void newLine() throws IOException {
            this.m_state = 0;
            super.write(IConstants.EOL, 0, IConstants.EOL.length());
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.indent();
            super.write(cArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.indent();
            super.write(n);
        }

        public void write(String string, int n, int n2) throws IOException {
            this.indent();
            super.write(string, n, n2);
        }

        IndentingWriter(Writer writer, int n, int n2) {
            super(writer, n);
            this.m_indent = n2;
        }

        void incIndent(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("delta be non-negative: " + n);
            }
            this.m_indent += n;
        }

        void incIndent() {
            this.incIndent(2);
        }

        void decIndent(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("delta be non-negative: " + n);
            }
            if (n > this.m_indent) {
                throw new IllegalArgumentException("delta = " + n + ", current indent = " + this.m_indent);
            }
            this.m_indent -= n;
        }

        void decIndent() {
            this.decIndent(2);
        }

        String getIndent() {
            if (this.m_indent <= 0) {
                return "";
            }
            if (this.m_sindent == null || this.m_sindent.length() < this.m_indent) {
                char[] cArray = new char[this.m_indent];
                for (int i = 0; i < this.m_indent; ++i) {
                    cArray[i] = 32;
                }
                this.m_sindent = new String(cArray);
                return this.m_sindent;
            }
            return this.m_sindent.substring(0, this.m_indent);
        }

        private void indent() throws IOException {
            if (this.m_state == 0) {
                String string = this.getIndent();
                super.write(string, 0, string.length());
                this.m_state = 1;
            }
        }
    }
}

