/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.instr.InstrVisitor;
import com.vladium.emma.rt.ClassPathCacheEntry;
import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.parser.ClassDefParser;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.Files;
import com.vladium.util.IPathEnumerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ClassPathProcessorST
implements IPathEnumerator.IPathHandler,
IAppErrorCodes {
    private final File[] m_path;
    private final boolean m_canonical;
    private final IMetaData m_mdata;
    private final IInclExclFilter m_coverageFilter;
    private final InstrVisitor m_visitor;
    private final InstrVisitor.InstrResult m_instrResult;
    private final Map m_cache;
    private final Logger m_log;
    private int m_classCount;
    private byte[] m_readbuf;
    private int m_readpos;
    private ByteArrayOStream m_baos;
    private File m_archiveFile;
    private static final int BUF_SIZE = 32768;

    public void run() {
        long l = System.currentTimeMillis();
        IPathEnumerator iPathEnumerator = IPathEnumerator.Factory.create(this.m_path, this.m_canonical, this);
        this.m_readbuf = new byte[32768];
        this.m_readpos = 0;
        this.m_baos = new ByteArrayOStream(32768);
        if (this.m_log.atINFO()) {
            this.m_log.info("processing classpath ...");
        }
        try {
            iPathEnumerator.enumerate();
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("INSTR_IO_FAILURE", iOException);
        }
        if (this.m_log.atINFO()) {
            long l2 = System.currentTimeMillis();
            this.m_log.info("[" + this.m_classCount + " class(es) processed in " + (l2 - l) + " ms]");
        }
    }

    public void handleArchiveStart(File file, File file2, Manifest manifest) {
        this.m_archiveFile = Files.newFile(file, file2.getPath());
    }

    public void handleArchiveEntry(JarInputStream jarInputStream, ZipEntry zipEntry) {
        String string;
        String string2;
        if (this.m_log.atTRACE2()) {
            this.m_log.trace2("handleArchiveEntry", "[" + zipEntry.getName() + "]");
        }
        if ((string2 = (string = zipEntry.getName()).toLowerCase()).endsWith(".class")) {
            String string3 = string.substring(0, string.length() - 6).replace('/', '.');
            if (this.m_coverageFilter == null || this.m_coverageFilter.included(string3)) {
                String string4;
                block22: {
                    string4 = null;
                    InputStream inputStream = null;
                    try {
                        this.readZipEntry(jarInputStream, zipEntry);
                        string4 = "jar:".concat(this.m_archiveFile.toURL().toExternalForm()).concat("!/").concat(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (inputStream == null) break block22;
                        try {
                            inputStream.close();
                            inputStream = null;
                        }
                        catch (Exception exception) {
                            throw new EMMARuntimeException(exception);
                        }
                    }
                    catch (IOException iOException) {
                        throw new EMMARuntimeException(iOException);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                                inputStream = null;
                            }
                            catch (Exception exception) {
                                throw new EMMARuntimeException(exception);
                            }
                        }
                    }
                }
                try {
                    ClassDef classDef = ClassDefParser.parseClass(this.m_readbuf, this.m_readpos);
                    if (!classDef.isInterface()) {
                        ++this.m_classCount;
                    }
                    this.m_visitor.process(classDef, false, false, true, this.m_instrResult);
                    classDef = null;
                    boolean bl = true;
                    if (this.m_instrResult.m_descriptor != null && !this.m_mdata.add(this.m_instrResult.m_descriptor, false)) {
                        bl = false;
                    }
                    if (bl && this.m_cache != null) {
                        byte[] byArray = new byte[this.m_readpos];
                        System.arraycopy(this.m_readbuf, 0, byArray, 0, this.m_readpos);
                        this.m_cache.put(string3, new ClassPathCacheEntry(byArray, string4));
                    }
                }
                catch (IOException iOException) {
                    throw new EMMARuntimeException(iOException);
                }
            }
        }
    }

    public void handleArchiveEnd(File file, File file2) {
        this.m_archiveFile = null;
    }

    public void handleDirStart(File file, File file2) {
    }

    public void handleFile(File file, File file2) {
        String string;
        String string2;
        if (this.m_log.atTRACE2()) {
            this.m_log.trace2("handleFile", "[" + file + "] [" + file2 + "]");
        }
        if ((string2 = (string = file2.getPath()).toLowerCase()).endsWith(".class")) {
            String string3 = string.substring(0, string.length() - 6).replace(File.separatorChar, '.');
            if (this.m_coverageFilter == null || this.m_coverageFilter.included(string3)) {
                Object object;
                String string4;
                block22: {
                    string4 = null;
                    InputStream inputStream = null;
                    try {
                        object = Files.newFile(file, file2.getPath());
                        this.readFile((File)object);
                        string4 = ((File)object).toURL().toExternalForm();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (inputStream == null) break block22;
                        try {
                            inputStream.close();
                            inputStream = null;
                        }
                        catch (Exception exception) {
                            throw new EMMARuntimeException(exception);
                        }
                    }
                    catch (IOException iOException) {
                        throw new EMMARuntimeException(iOException);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                                inputStream = null;
                            }
                            catch (Exception exception) {
                                throw new EMMARuntimeException(exception);
                            }
                        }
                    }
                }
                try {
                    object = ClassDefParser.parseClass(this.m_readbuf, this.m_readpos);
                    if (!((ClassDef)object).isInterface()) {
                        ++this.m_classCount;
                    }
                    this.m_visitor.process((ClassDef)object, false, false, true, this.m_instrResult);
                    object = null;
                    boolean bl = true;
                    if (this.m_instrResult.m_descriptor != null && !this.m_mdata.add(this.m_instrResult.m_descriptor, false)) {
                        bl = false;
                    }
                    if (bl && this.m_cache != null) {
                        byte[] byArray = new byte[this.m_readpos];
                        System.arraycopy(this.m_readbuf, 0, byArray, 0, this.m_readpos);
                        this.m_cache.put(string3, new ClassPathCacheEntry(byArray, string4));
                    }
                }
                catch (IOException iOException) {
                    throw new EMMARuntimeException(iOException);
                }
            }
        }
    }

    public void handleDirEnd(File file, File file2) {
    }

    ClassPathProcessorST(File[] fileArray, boolean bl, IMetaData iMetaData, IInclExclFilter iInclExclFilter, Map map) {
        if (fileArray == null) {
            throw new IllegalArgumentException("null input: path");
        }
        if (iMetaData == null) {
            throw new IllegalArgumentException("null input: mdata");
        }
        this.m_path = fileArray;
        this.m_canonical = bl;
        this.m_mdata = iMetaData;
        this.m_coverageFilter = iInclExclFilter;
        this.m_cache = map;
        this.m_visitor = new InstrVisitor(iMetaData.getOptions());
        this.m_instrResult = new InstrVisitor.InstrResult();
        this.m_log = Logger.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File file) throws IOException {
        int n = (int)file.length();
        this.ensureReadCapacity(n);
        FileInputStream fileInputStream = null;
        try {
            int n2;
            int n3;
            fileInputStream = new FileInputStream(file);
            for (n2 = 0; n2 < n && (n3 = ((InputStream)fileInputStream).read(this.m_readbuf, n2, n - n2)) >= 0; n2 += n3) {
            }
            this.m_readpos = n2;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void readZipEntry(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        int n = (int)zipEntry.getSize();
        if (n >= 0) {
            int n2;
            int n3;
            this.ensureReadCapacity(n);
            for (n2 = 0; n2 < n && (n3 = zipInputStream.read(this.m_readbuf, n2, n - n2)) >= 0; n2 += n3) {
            }
            this.m_readpos = n2;
        } else {
            int n4;
            this.ensureReadCapacity(32768);
            this.m_baos.reset();
            while ((n4 = zipInputStream.read(this.m_readbuf)) >= 0) {
                this.m_baos.write(this.m_readbuf, 0, n4);
            }
            this.m_readbuf = this.m_baos.copyByteArray();
            this.m_readpos = this.m_readbuf.length;
        }
    }

    private void ensureReadCapacity(int n) {
        if (this.m_readbuf.length < n) {
            int n2 = this.m_readbuf.length;
            this.m_readbuf = null;
            this.m_readbuf = new byte[Math.max(n2 << 1, n)];
        }
    }
}

