/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.instr.InstrVisitor;
import com.vladium.emma.rt.IClassLoadHook;
import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.compiler.ClassWriter;
import com.vladium.jcd.parser.ClassDefParser;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.Descriptors;
import java.io.IOException;

public final class InstrClassLoadHook
implements IClassLoadHook {
    private final IInclExclFilter m_filter;
    private final IMetaData m_metadata;
    private final InstrVisitor m_classDefProcessor;
    private final InstrVisitor.InstrResult m_instrResult;

    public InstrClassLoadHook(IInclExclFilter iInclExclFilter, IMetaData iMetaData) {
        if (iMetaData == null) {
            throw new IllegalArgumentException("null input: mdata");
        }
        this.m_filter = iInclExclFilter;
        this.m_metadata = iMetaData;
        CoverageOptions coverageOptions = iMetaData.getOptions();
        this.m_classDefProcessor = new InstrVisitor(coverageOptions);
        this.m_instrResult = new InstrVisitor.InstrResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processClassDef(String string, byte[] byArray, int n, ByteArrayOStream byteArrayOStream) throws IOException {
        IInclExclFilter iInclExclFilter = this.m_filter;
        if (iInclExclFilter == null || iInclExclFilter.included(string)) {
            boolean bl;
            Object object;
            ClassDef classDef = ClassDefParser.parseClass(byArray, n);
            String string2 = Descriptors.javaNameToVMName(string);
            Object object2 = object = this.m_metadata.lock();
            synchronized (object2) {
                bl = this.m_metadata.hasDescriptor(string2);
            }
            this.m_classDefProcessor.process(classDef, false, true, !bl, this.m_instrResult);
            boolean bl2 = this.m_instrResult.m_instrumented;
            if (this.m_instrResult.m_descriptor != null) {
                Object object3 = object;
                synchronized (object3) {
                    if (!this.m_metadata.add(this.m_instrResult.m_descriptor, false)) {
                        bl2 = false;
                    }
                }
            }
            if (bl2) {
                ClassWriter.writeClassTable(classDef, byteArrayOStream);
                return true;
            }
        }
        return false;
    }
}

