/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.ElementFactory;
import com.vladium.jcd.cls.Field_info;
import com.vladium.jcd.cls.IAccessFlags;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.IFieldCollection;
import com.vladium.jcd.cls.IInterfaceCollection;
import com.vladium.jcd.cls.IMethodCollection;
import com.vladium.jcd.cls.Method_info;
import com.vladium.jcd.cls.attribute.AttributeElementFactory;
import com.vladium.jcd.cls.attribute.CodeAttribute_info;
import com.vladium.jcd.cls.attribute.InnerClassesAttribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Class_info;
import com.vladium.jcd.cls.constant.CONSTANT_Fieldref_info;
import com.vladium.jcd.cls.constant.CONSTANT_NameAndType_info;
import com.vladium.jcd.cls.constant.CONSTANT_String_info;
import com.vladium.jcd.cls.constant.CONSTANT_Utf8_info;
import com.vladium.jcd.compiler.IClassFormatOutput;
import com.vladium.jcd.lib.Types;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.ByteArrayOStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class ClassDef
implements Cloneable,
IAccessFlags,
IClassFormatOutput {
    private long m_magic;
    private int[] m_version = new int[2];
    private int m_access_flags;
    private int m_this_class_index;
    private int m_super_class_index;
    private IConstantCollection m_constants = ElementFactory.newConstantCollection(-1);
    private IInterfaceCollection m_interfaces = ElementFactory.newInterfaceCollection(-1);
    private IFieldCollection m_fields = ElementFactory.newFieldCollection(-1);
    private IMethodCollection m_methods = ElementFactory.newMethodCollection(-1);
    private IAttributeCollection m_attributes = ElementFactory.newAttributeCollection(-1);
    private long m_declaredSUID;
    private static final boolean DEBUG_SUID = false;

    public void accept(IClassDefVisitor iClassDefVisitor, Object object) {
        iClassDefVisitor.visit(this, object);
    }

    public long getMagic() {
        return this.m_magic;
    }

    public void setMagic(long l) {
        this.m_magic = l;
    }

    public int[] getVersion() {
        return this.m_version;
    }

    public void setVersion(int[] nArray) {
        this.m_version[0] = nArray[0];
        this.m_version[1] = nArray[1];
    }

    public final void setDeclaredSUID(long l) {
        this.m_declaredSUID = l;
    }

    public int getThisClassIndex() {
        return this.m_this_class_index;
    }

    public void setThisClassIndex(int n) {
        this.m_this_class_index = n;
    }

    public CONSTANT_Class_info getThisClass() {
        return (CONSTANT_Class_info)this.m_constants.get(this.m_this_class_index);
    }

    public CONSTANT_Class_info getSuperClass() {
        return (CONSTANT_Class_info)this.m_constants.get(this.m_super_class_index);
    }

    public String getName() {
        return this.getThisClass().getName(this);
    }

    public int getSuperClassIndex() {
        return this.m_super_class_index;
    }

    public void setSuperClassIndex(int n) {
        this.m_super_class_index = n;
    }

    public final int getAccessFlags() {
        return this.m_access_flags;
    }

    public final void setAccessFlags(int n) {
        this.m_access_flags = n;
    }

    public boolean isInterface() {
        return (this.m_access_flags & 0x200) != 0;
    }

    public boolean isSynthetic() {
        return this.m_attributes.hasSynthetic();
    }

    public boolean isNested(int[] nArray) {
        InnerClassesAttribute_info innerClassesAttribute_info = this.m_attributes.getInnerClassesAttribute();
        if (innerClassesAttribute_info == null) {
            return false;
        }
        return innerClassesAttribute_info.makesClassNested(this.m_this_class_index, nArray);
    }

    public IConstantCollection getConstants() {
        return this.m_constants;
    }

    public IInterfaceCollection getInterfaces() {
        return this.m_interfaces;
    }

    public IFieldCollection getFields() {
        return this.m_fields;
    }

    public IMethodCollection getMethods() {
        return this.m_methods;
    }

    public IAttributeCollection getAttributes() {
        return this.m_attributes;
    }

    public int[] getFields(String string) {
        return this.m_fields.get(this, string);
    }

    public int[] getMethods(String string) {
        return this.m_methods.get(this, string);
    }

    public Object clone() {
        try {
            ClassDef classDef = (ClassDef)super.clone();
            classDef.m_version = (int[])this.m_version.clone();
            classDef.m_constants = (IConstantCollection)this.m_constants.clone();
            classDef.m_interfaces = (IInterfaceCollection)this.m_interfaces.clone();
            classDef.m_fields = (IFieldCollection)this.m_fields.clone();
            classDef.m_methods = (IMethodCollection)this.m_methods.clone();
            classDef.m_attributes = (IAttributeCollection)this.m_attributes.clone();
            return classDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        if (uDataOutputStream == null) {
            throw new IllegalArgumentException("null input: out");
        }
        uDataOutputStream.writeU4(this.m_magic);
        uDataOutputStream.writeU2(this.m_version[1]);
        uDataOutputStream.writeU2(this.m_version[0]);
        this.m_constants.writeInClassFormat(uDataOutputStream);
        uDataOutputStream.writeU2(this.m_access_flags);
        uDataOutputStream.writeU2(this.m_this_class_index);
        uDataOutputStream.writeU2(this.m_super_class_index);
        this.m_interfaces.writeInClassFormat(uDataOutputStream);
        this.m_fields.writeInClassFormat(uDataOutputStream);
        this.m_methods.writeInClassFormat(uDataOutputStream);
        this.m_attributes.writeInClassFormat(uDataOutputStream);
    }

    public final long getDeclaredSUID() {
        return this.m_declaredSUID;
    }

    public final long computeSUID(boolean bl) {
        long l = this.m_declaredSUID;
        if (l != 0L) {
            return l;
        }
        try {
            int n;
            int n2;
            ByteArrayOStream byteArrayOStream = new ByteArrayOStream(1024);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOStream);
            dataOutputStream.writeUTF(Types.vmNameToJavaName(this.getName()));
            Object object = new int[1];
            int n3 = (this.isNested((int[])object) ? object[0] : this.getAccessFlags()) & 0x611;
            dataOutputStream.writeInt(n3);
            object = this.getInterfaces();
            Object[] objectArray = new String[object.size()];
            int n4 = objectArray.length;
            for (n2 = 0; n2 < n4; ++n2) {
                objectArray[n2] = Types.vmNameToJavaName(((CONSTANT_Class_info)this.m_constants.get(object.get(n2))).getName(this));
            }
            Arrays.sort(objectArray);
            for (n2 = 0; n2 < n4; ++n2) {
                dataOutputStream.writeUTF((String)objectArray[n2]);
            }
            object = this.getFields();
            objectArray = new FieldDescriptor[object.size()];
            n4 = 0;
            int n5 = objectArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                Field_info field_info = object.get(n2);
                n = field_info.getAccessFlags();
                if ((n & 2) != 0 && (n & 0x88) != 0) continue;
                objectArray[n4++] = new FieldDescriptor(field_info.getName(this), n, field_info.getDescriptor(this));
            }
            if (n4 > 0) {
                Arrays.sort(objectArray, 0, n4);
                for (n2 = 0; n2 < n4; ++n2) {
                    Object object2 = objectArray[n2];
                    dataOutputStream.writeUTF(((FieldDescriptor)object2).m_name);
                    dataOutputStream.writeInt(((FieldDescriptor)object2).m_modifiers);
                    dataOutputStream.writeUTF(((FieldDescriptor)object2).m_descriptor);
                }
            }
            object = this.getMethods();
            boolean bl2 = false;
            Object[] objectArray2 = new ConstructorDescriptor[object.size()];
            Object[] objectArray3 = new MethodDescriptor[objectArray2.length];
            n5 = 0;
            int n6 = 0;
            int n7 = objectArray2.length;
            for (n = 0; n < n7; ++n) {
                Method_info method_info = object.get(n);
                String string = method_info.getName(this);
                if (!bl2 && "<clinit>".equals(string)) {
                    bl2 = true;
                    continue;
                }
                int n8 = method_info.getAccessFlags();
                if ((n8 & 2) != 0) continue;
                if ("<init>".equals(string)) {
                    objectArray2[n5++] = new ConstructorDescriptor(n8, method_info.getDescriptor(this));
                    continue;
                }
                objectArray3[n6++] = new MethodDescriptor(string, n8, method_info.getDescriptor(this));
            }
            if (bl2 && !bl) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            if (n5 > 0) {
                Arrays.sort(objectArray2, 0, n5);
                for (n = 0; n < n5; ++n) {
                    Object object3 = objectArray2[n];
                    dataOutputStream.writeUTF("<init>");
                    dataOutputStream.writeInt(((ConstructorDescriptor)object3).m_modifiers);
                    dataOutputStream.writeUTF(((ConstructorDescriptor)object3).m_descriptor.replace('/', '.'));
                }
            }
            if (n6 > 0) {
                Arrays.sort(objectArray3, 0, n6);
                for (n = 0; n < n6; ++n) {
                    Object object4 = objectArray3[n];
                    dataOutputStream.writeUTF(((MethodDescriptor)object4).m_name);
                    dataOutputStream.writeInt(((MethodDescriptor)object4).m_modifiers);
                    dataOutputStream.writeUTF(((MethodDescriptor)object4).m_descriptor.replace('/', '.'));
                }
            }
            dataOutputStream.flush();
            object = MessageDigest.getInstance("SHA");
            ((MessageDigest)object).update(byteArrayOStream.getByteArray(), 0, byteArrayOStream.size());
            byte[] byArray = ((MessageDigest)object).digest();
            for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                l = l << 8 | (long)(byArray[i] & 0xFF);
            }
            return l;
        }
        catch (IOException iOException) {
            throw new Error(iOException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
    }

    public int addCONSTANT_Utf8(String string, boolean bl) {
        int n;
        if (bl && (n = this.m_constants.findCONSTANT_Utf8(string)) > 0) {
            return n;
        }
        return this.m_constants.add(new CONSTANT_Utf8_info(string));
    }

    public int addStringConstant(String string) {
        int n = this.addCONSTANT_Utf8(string, true);
        return this.m_constants.add(new CONSTANT_String_info(n));
    }

    public int addNameType(String string, String string2) {
        int n = this.addCONSTANT_Utf8(string, true);
        int n2 = this.addCONSTANT_Utf8(string2, true);
        return this.m_constants.add(new CONSTANT_NameAndType_info(n, n2));
    }

    public int addClassref(String string) {
        int n = this.addCONSTANT_Utf8(string, true);
        return this.m_constants.add(new CONSTANT_Class_info(n));
    }

    public int addField(String string, String string2, int n) {
        int n2 = this.addCONSTANT_Utf8(string, true);
        int n3 = this.addCONSTANT_Utf8(string2, true);
        Field_info field_info = new Field_info(n, n2, n3, ElementFactory.newAttributeCollection(0));
        return this.m_fields.add(field_info);
    }

    public int addField(String string, String string2, int n, IAttributeCollection iAttributeCollection) {
        int n2 = this.addCONSTANT_Utf8(string, true);
        int n3 = this.addCONSTANT_Utf8(string2, true);
        Field_info field_info = new Field_info(n, n2, n3, iAttributeCollection);
        return this.m_fields.add(field_info);
    }

    public Method_info newEmptyMethod(String string, String string2, int n) {
        int n2 = this.addCONSTANT_Utf8("Code", true);
        int n3 = this.addCONSTANT_Utf8(string, true);
        int n4 = this.addCONSTANT_Utf8(string2, true);
        IAttributeCollection iAttributeCollection = ElementFactory.newAttributeCollection(0);
        CodeAttribute_info codeAttribute_info = new CodeAttribute_info(n2, 0, 0, CodeAttribute_info.EMPTY_BYTE_ARRAY, AttributeElementFactory.newExceptionHandlerTable(0), ElementFactory.newAttributeCollection(0));
        iAttributeCollection.add(codeAttribute_info);
        Method_info method_info = new Method_info(n, n3, n4, iAttributeCollection);
        return method_info;
    }

    public int addMethod(Method_info method_info) {
        return this.m_methods.add(method_info);
    }

    public int addFieldref(Field_info field_info) {
        CONSTANT_NameAndType_info cONSTANT_NameAndType_info = new CONSTANT_NameAndType_info(field_info.m_name_index, field_info.m_descriptor_index);
        int n = this.m_constants.add(cONSTANT_NameAndType_info);
        return this.m_constants.add(new CONSTANT_Fieldref_info(this.m_this_class_index, n));
    }

    public int addFieldref(int n) {
        Field_info field_info = this.m_fields.get(n);
        CONSTANT_NameAndType_info cONSTANT_NameAndType_info = new CONSTANT_NameAndType_info(field_info.m_name_index, field_info.m_descriptor_index);
        int n2 = this.m_constants.add(cONSTANT_NameAndType_info);
        return this.m_constants.add(new CONSTANT_Fieldref_info(this.m_this_class_index, n2));
    }

    private static final class MethodDescriptor
    implements Comparable {
        final String m_name;
        final int m_modifiers;
        final String m_descriptor;

        public final int compareTo(Object object) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)object;
            int n = this.m_name.compareTo(methodDescriptor.m_name);
            if (n == 0) {
                n = this.m_descriptor.compareTo(methodDescriptor.m_descriptor);
            }
            return n;
        }

        MethodDescriptor(String string, int n, String string2) {
            this.m_name = string;
            this.m_modifiers = n;
            this.m_descriptor = string2;
        }
    }

    private static final class ConstructorDescriptor
    implements Comparable {
        final int m_modifiers;
        final String m_descriptor;

        public final int compareTo(Object object) {
            return this.m_descriptor.compareTo(((ConstructorDescriptor)object).m_descriptor);
        }

        ConstructorDescriptor(int n, String string) {
            this.m_modifiers = n;
            this.m_descriptor = string;
        }
    }

    private static final class FieldDescriptor
    implements Comparable {
        final String m_name;
        final int m_modifiers;
        final String m_descriptor;

        public final int compareTo(Object object) {
            return this.m_name.compareTo(((FieldDescriptor)object).m_name);
        }

        FieldDescriptor(String string, int n, String string2) {
            this.m_name = string;
            this.m_modifiers = n;
            this.m_descriptor = string2;
        }
    }
}

