/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.compiler;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.constant.CONSTANT_Integer_info;
import com.vladium.jcd.opcodes.IOpcodes;
import com.vladium.util.ByteArrayOStream;

public abstract class CodeGen
implements IOpcodes {
    public static void load_local_object_var(ByteArrayOStream byteArrayOStream, int n) {
        if (n <= 3) {
            byteArrayOStream.write(42 + n);
        } else if (n <= 255) {
            byteArrayOStream.write2(25, n);
        } else {
            byteArrayOStream.write4(196, 25, n >>> 8, n);
        }
    }

    public static void store_local_object_var(ByteArrayOStream byteArrayOStream, int n) {
        if (n <= 3) {
            byteArrayOStream.write(75 + n);
        } else if (n <= 255) {
            byteArrayOStream.write2(58, n);
        } else {
            byteArrayOStream.write4(196, 58, n >>> 8, n);
        }
    }

    public static void push_int_value(ByteArrayOStream byteArrayOStream, ClassDef classDef, int n) {
        if (-1 <= n && n <= 5) {
            byteArrayOStream.write(3 + n);
        } else if (-128 <= n && n <= 127) {
            byteArrayOStream.write2(16, n);
        } else if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
            byteArrayOStream.write3(17, n >>> 8, n);
        } else {
            int n2 = classDef.getConstants().add(new CONSTANT_Integer_info(n));
            if (n2 <= 255) {
                byteArrayOStream.write2(18, n2);
            } else {
                byteArrayOStream.write3(19, n2 >>> 8, n2);
            }
        }
    }

    public static void push_constant_index(ByteArrayOStream byteArrayOStream, int n) {
        if (n <= 255) {
            byteArrayOStream.write2(18, n);
        } else {
            byteArrayOStream.write3(19, n >>> 8, n);
        }
    }

    private CodeGen() {
    }
}

