/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

public final class ObjectIntMap {
    private final float m_loadFactor;
    private Entry[] m_buckets;
    private int m_size;
    private int m_sizeThreshold;
    private static final String EOL = System.getProperty("line.separator", "\n");

    public ObjectIntMap() {
        this(11, 0.75f);
    }

    public ObjectIntMap(int n) {
        this(n, 0.75f);
    }

    public ObjectIntMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("negative input: initialCapacity [" + n + "]");
        }
        if ((double)f <= 0.0 || (double)f >= 1.000001) {
            throw new IllegalArgumentException("loadFactor not in (0.0, 1.0] range: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.m_loadFactor = (double)f > 1.0 ? 1.0f : f;
        this.m_sizeThreshold = (int)((float)n * f);
        this.m_buckets = new Entry[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.debugDump(stringBuffer);
        return stringBuffer.toString();
    }

    public int size() {
        return this.m_size;
    }

    public boolean contains(Object object) {
        Entry[] entryArray = this.m_buckets;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.m_key.hashCode() || entry.m_key.equals(object)) {
                return true;
            }
            entry = entry.m_next;
        }
        return false;
    }

    public boolean get(Object object, int[] nArray) {
        Entry[] entryArray = this.m_buckets;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.m_key.hashCode() || entry.m_key.equals(object)) {
                nArray[0] = entry.m_value;
                return true;
            }
            entry = entry.m_next;
        }
        return false;
    }

    public Object[] keys() {
        Object[] objectArray = new Object[this.m_size];
        int n = 0;
        for (int i = 0; i < this.m_buckets.length; ++i) {
            Entry entry = this.m_buckets[i];
            while (entry != null) {
                objectArray[n++] = entry.m_key;
                entry = entry.m_next;
            }
        }
        return objectArray;
    }

    public void put(Object object, int n) {
        Entry entry = null;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % this.m_buckets.length;
        Entry[] entryArray = this.m_buckets;
        Entry entry2 = entryArray[n3];
        while (entry2 != null) {
            if (n2 == entry2.m_key.hashCode() || entry2.m_key.equals(object)) {
                entry = entry2;
                break;
            }
            entry2 = entry2.m_next;
        }
        if (entry != null) {
            entry.m_value = n;
        } else {
            Entry entry3;
            if (this.m_size >= this.m_sizeThreshold) {
                this.rehash();
            }
            entryArray = this.m_buckets;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
            entry2 = entryArray[n3];
            entryArray[n3] = entry3 = new Entry(object, n, entry2);
            ++this.m_size;
        }
    }

    public void remove(Object object) {
        Entry entry;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.m_buckets.length;
        Entry[] entryArray = this.m_buckets;
        Entry entry2 = entry = entryArray[n2];
        while (entry != null) {
            Entry entry3 = entry.m_next;
            if (n == entry.m_key.hashCode() || entry.m_key.equals(object)) {
                if (entry2 == entry) {
                    entryArray[n2] = entry3;
                } else {
                    entry2.m_next = entry3;
                }
                --this.m_size;
                break;
            }
            entry2 = entry;
            entry = entry3;
        }
    }

    void debugDump(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            stringBuffer.append(super.toString());
            stringBuffer.append(EOL);
            stringBuffer.append("size = " + this.m_size + ", bucket table size = " + this.m_buckets.length + ", load factor = " + this.m_loadFactor + EOL);
            stringBuffer.append("size threshold = " + this.m_sizeThreshold + EOL);
        }
    }

    private void rehash() {
        Entry[] entryArray = this.m_buckets;
        int n = (this.m_buckets.length << 1) + 1;
        Entry[] entryArray2 = new Entry[n];
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2;
                Entry entry3 = entry.m_next;
                int n2 = entry.m_key.hashCode() & Integer.MAX_VALUE;
                int n3 = n2 % n;
                entry.m_next = entry2 = entryArray2[n3];
                entryArray2[n3] = entry;
                entry = entry3;
            }
        }
        this.m_sizeThreshold = (int)((float)n * this.m_loadFactor);
        this.m_buckets = entryArray2;
    }

    private static final class Entry {
        Object m_key;
        int m_value;
        Entry m_next;

        Entry(Object object, int n, Entry entry) {
            this.m_key = object;
            this.m_value = n;
            this.m_next = entry;
        }
    }
}

