/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    boolean selected;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    void changeColor(long l, long l2, long l3) {
        this.selected = true;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        NSColor nSColor;
        NSObject nSObject;
        NSColorPanel nSColorPanel = NSColorPanel.sharedColorPanel();
        if (this.rgb != null) {
            nSObject = NSColor.colorWithDeviceRed((float)this.rgb.red / 255.0f, (float)this.rgb.green / 255.0f, (float)this.rgb.blue / 255.0f, 1.0);
            nSColorPanel.setColor((NSColor)nSObject);
        }
        nSObject = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        long l = OS.NewGlobalRef(this);
        if (l == 0L) {
            SWT.error(2);
        }
        OS.object_setInstanceVariable(((SWTPanelDelegate)nSObject).id, Display.SWT_OBJECT, l);
        nSColorPanel.setDelegate(nSObject);
        this.rgb = null;
        this.selected = false;
        nSColorPanel.orderFront(null);
        NSApplication.sharedApplication().runModalForWindow(nSColorPanel);
        nSColorPanel.setDelegate(null);
        nSObject.release();
        OS.DeleteGlobalRef(l);
        if (this.selected && (nSColor = nSColorPanel.color()) != null) {
            nSColor = nSColor.colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
            this.rgb = new RGB((int)(nSColor.redComponent() * 255.0), (int)(nSColor.greenComponent() * 255.0), (int)(nSColor.blueComponent() * 255.0));
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    void windowWillClose(long l, long l2, long l3) {
        NSApplication.sharedApplication().stop(null);
    }
}

