/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class Sector {
    private final BlockDevice device;
    private final long offset;
    protected final ByteBuffer buffer;
    private boolean dirty;

    protected Sector(BlockDevice device, long offset, int size) {
        this.offset = offset;
        this.device = device;
        this.buffer = ByteBuffer.allocate(size);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.dirty = true;
    }

    protected void read() throws IOException {
        this.buffer.rewind();
        this.buffer.limit(this.buffer.capacity());
        this.device.read(this.offset, this.buffer);
        this.dirty = false;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    protected final void markDirty() {
        this.dirty = true;
    }

    public BlockDevice getDevice() {
        return this.device;
    }

    public final void write() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
        this.device.write(this.offset, this.buffer);
        this.dirty = false;
    }

    protected int get16(int offset) {
        return this.buffer.getShort(offset) & 0xFFFF;
    }

    protected long get32(int offset) {
        return this.buffer.getInt(offset) & 0xFFFFFFFF;
    }

    protected int get8(int offset) {
        return this.buffer.get(offset) & 0xFF;
    }

    protected void set16(int offset, int value) {
        this.buffer.putShort(offset, (short)(value & 0xFFFF));
        this.dirty = true;
    }

    protected void set32(int offset, long value) {
        this.buffer.putInt(offset, (int)(value & 0xFFFFFFFFFFFFFFFFL));
        this.dirty = true;
    }

    protected void set8(int offset, int value) {
        if ((value & 0xFF) != value) {
            throw new IllegalArgumentException(value + " too big to be stored in a single octet");
        }
        this.buffer.put(offset, (byte)(value & 0xFF));
        this.dirty = true;
    }

    protected long getOffset() {
        return this.offset;
    }
}

