/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmuilib.heap.NativeDiffAllocationInfo;
import com.android.ddmuilib.heap.NativeHeapSnapshot;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NativeHeapDiffSnapshot
extends NativeHeapSnapshot {
    private long mCommonAllocationsTotalMemory;

    public NativeHeapDiffSnapshot(NativeHeapSnapshot newSnapshot, NativeHeapSnapshot oldSnapshot) {
        super(NativeHeapDiffSnapshot.getNewAllocations(newSnapshot, oldSnapshot));
        HashSet<NativeAllocationInfo> commonAllocations = new HashSet<NativeAllocationInfo>(oldSnapshot.getAllocations());
        commonAllocations.retainAll(newSnapshot.getAllocations());
        this.mCommonAllocationsTotalMemory = this.getTotalMemory(commonAllocations);
    }

    private static List<NativeAllocationInfo> getNewAllocations(NativeHeapSnapshot newSnapshot, NativeHeapSnapshot oldSnapshot) {
        HashSet<NativeAllocationInfo> allocations = new HashSet<NativeAllocationInfo>(newSnapshot.getAllocations());
        allocations.removeAll(oldSnapshot.getAllocations());
        HashSet<NativeAllocationInfo> onlyInPrevious = new HashSet<NativeAllocationInfo>(oldSnapshot.getAllocations());
        HashSet newAllocations = Sets.newHashSetWithExpectedSize((int)allocations.size());
        onlyInPrevious.removeAll(newSnapshot.getAllocations());
        for (NativeAllocationInfo current : allocations) {
            NativeAllocationInfo old = NativeHeapDiffSnapshot.getOldAllocationWithSameStack(current, onlyInPrevious);
            if (old == null) {
                newAllocations.add(current);
                continue;
            }
            if (current.getAllocationCount() <= old.getAllocationCount()) continue;
            newAllocations.add(new NativeDiffAllocationInfo(current, old));
        }
        return new ArrayList<NativeAllocationInfo>(newAllocations);
    }

    private static NativeAllocationInfo getOldAllocationWithSameStack(NativeAllocationInfo info, Set<NativeAllocationInfo> allocations) {
        for (NativeAllocationInfo a : allocations) {
            if (info.getSize() != a.getSize() || !info.stackEquals(a)) continue;
            return a;
        }
        return null;
    }

    @Override
    public String getFormattedMemorySize() {
        long newAllocations = this.getTotalSize();
        return String.format("%s bytes new + %s bytes retained = %s bytes total", this.formatMemorySize(newAllocations), this.formatMemorySize(this.mCommonAllocationsTotalMemory), this.formatMemorySize(newAllocations + this.mCommonAllocationsTotalMemory));
    }
}

