/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.log.event.EventDisplay;
import com.android.ddmuilib.log.event.EventValueSelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class EventDisplayOptions
extends Dialog {
    private static final int DLG_WIDTH = 700;
    private static final int DLG_HEIGHT = 700;
    private Shell mParent;
    private Shell mShell;
    private boolean mEditStatus = false;
    private final ArrayList<EventDisplay> mDisplayList = new ArrayList();
    private List mEventDisplayList;
    private Button mEventDisplayNewButton;
    private Button mEventDisplayDeleteButton;
    private Button mEventDisplayUpButton;
    private Button mEventDisplayDownButton;
    private Text mDisplayWidthText;
    private Text mDisplayHeightText;
    private Text mDisplayNameText;
    private Combo mDisplayTypeCombo;
    private Group mChartOptions;
    private Group mHistOptions;
    private Button mPidFilterCheckBox;
    private Text mPidText;
    private Map<Integer, String> mEventTagMap;
    private Map<Integer, EventValueDescription[]> mEventDescriptionMap;
    private ArrayList<Integer> mPidList;
    private EventLogParser mLogParser;
    private Group mInfoGroup;
    private SelectionWidgets mValueSelection;
    private SelectionWidgets mOccurrenceSelection;
    private boolean mProcessTextChanges = true;
    private Text mTimeLimitText;
    private Text mHistWidthText;

    EventDisplayOptions(Shell parent) {
        super(parent, 67680);
    }

    boolean open(EventLogParser logParser, ArrayList<EventDisplay> displayList, ArrayList<EventContainer> eventList) {
        this.mLogParser = logParser;
        if (logParser != null) {
            this.mEventTagMap = logParser.getTagMap();
            this.mEventDescriptionMap = logParser.getEventInfoMap();
        }
        this.duplicateEventDisplay(displayList);
        this.buildPidList(eventList);
        this.createUI();
        if (this.mParent == null || this.mShell == null) {
            return false;
        }
        this.mShell.setMinimumSize(700, 700);
        Rectangle r = this.mParent.getBounds();
        int cx = r.x + r.width / 2;
        int x = cx - 350;
        int cy = r.y + r.height / 2;
        int y = cy - 350;
        this.mShell.setBounds(x, y, 700, 700);
        this.mShell.layout();
        this.mShell.open();
        Display display = this.mParent.getDisplay();
        while (!this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.mEditStatus;
    }

    ArrayList<EventDisplay> getEventDisplays() {
        return this.mDisplayList;
    }

    private void createUI() {
        this.mParent = this.getParent();
        this.mShell = new Shell(this.mParent, this.getStyle());
        this.mShell.setText("Event Display Configuration");
        this.mShell.setLayout((Layout)new GridLayout(1, true));
        Composite topPanel = new Composite((Composite)this.mShell, 0);
        topPanel.setLayoutData((Object)new GridData(1808));
        topPanel.setLayout((Layout)new GridLayout(2, false));
        Composite leftPanel = new Composite(topPanel, 0);
        Composite rightPanel = new Composite(topPanel, 0);
        this.createLeftPanel(leftPanel);
        this.createRightPanel(rightPanel);
        this.mShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = true;
            }
        });
        Label separator = new Label((Composite)this.mShell, 258);
        separator.setLayoutData((Object)new GridData(768));
        Composite bottomButtons = new Composite((Composite)this.mShell, 0);
        bottomButtons.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(2, true);
        bottomButtons.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Button okButton = new Button(bottomButtons, 8);
        okButton.setText("OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDisplayOptions.this.mShell.close();
            }
        });
        Button cancelButton = new Button(bottomButtons, 8);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDisplayOptions.this.mEditStatus = false;
                EventDisplayOptions.this.mShell.close();
            }
        });
        this.enable(false);
        this.fillEventDisplayList();
    }

    private void createLeftPanel(Composite leftPanel) {
        final IPreferenceStore store = DdmUiPreferences.getStore();
        leftPanel.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout(1, false);
        leftPanel.setLayout((Layout)gl);
        gl.verticalSpacing = 1;
        this.mEventDisplayList = new List(leftPanel, 68100);
        this.mEventDisplayList.setLayoutData((Object)new GridData(1808));
        this.mEventDisplayList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDisplayOptions.this.handleEventDisplaySelection();
            }
        });
        Composite bottomControls = new Composite(leftPanel, 0);
        bottomControls.setLayoutData((Object)new GridData(768));
        gl = new GridLayout(5, false);
        bottomControls.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        this.mEventDisplayNewButton = new Button(bottomControls, 0x800008);
        this.mEventDisplayNewButton.setImage(loader.loadImage("add.png", leftPanel.getDisplay()));
        this.mEventDisplayNewButton.setToolTipText("Adds a new event display");
        this.mEventDisplayNewButton.setLayoutData((Object)new GridData(64));
        this.mEventDisplayNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDisplayOptions.this.createNewEventDisplay();
            }
        });
        this.mEventDisplayDeleteButton = new Button(bottomControls, 0x800008);
        this.mEventDisplayDeleteButton.setImage(loader.loadImage("delete.png", leftPanel.getDisplay()));
        this.mEventDisplayDeleteButton.setToolTipText("Deletes the selected event display");
        this.mEventDisplayDeleteButton.setLayoutData((Object)new GridData(64));
        this.mEventDisplayDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDisplayOptions.this.deleteEventDisplay();
            }
        });
        this.mEventDisplayUpButton = new Button(bottomControls, 0x800008);
        this.mEventDisplayUpButton.setImage(loader.loadImage("up.png", leftPanel.getDisplay()));
        this.mEventDisplayUpButton.setToolTipText("Moves the selected event display up");
        this.mEventDisplayUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = EventDisplayOptions.this.mEventDisplayList.getSelectionIndex();
                if (selection > 0) {
                    EventDisplay display = (EventDisplay)EventDisplayOptions.this.mDisplayList.remove(selection);
                    EventDisplayOptions.this.mDisplayList.add(selection - 1, display);
                    EventDisplayOptions.this.mEventDisplayList.remove(selection);
                    EventDisplayOptions.this.mEventDisplayList.add(display.getName(), selection - 1);
                    EventDisplayOptions.this.mEventDisplayList.select(selection - 1);
                    EventDisplayOptions.this.handleEventDisplaySelection();
                    EventDisplayOptions.this.mEventDisplayList.showSelection();
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        this.mEventDisplayDownButton = new Button(bottomControls, 0x800008);
        this.mEventDisplayDownButton.setImage(loader.loadImage("down.png", leftPanel.getDisplay()));
        this.mEventDisplayDownButton.setToolTipText("Moves the selected event display down");
        this.mEventDisplayDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = EventDisplayOptions.this.mEventDisplayList.getSelectionIndex();
                if (selection != -1 && selection < EventDisplayOptions.this.mEventDisplayList.getItemCount() - 1) {
                    EventDisplay display = (EventDisplay)EventDisplayOptions.this.mDisplayList.remove(selection);
                    EventDisplayOptions.this.mDisplayList.add(selection + 1, display);
                    EventDisplayOptions.this.mEventDisplayList.remove(selection);
                    EventDisplayOptions.this.mEventDisplayList.add(display.getName(), selection + 1);
                    EventDisplayOptions.this.mEventDisplayList.select(selection + 1);
                    EventDisplayOptions.this.handleEventDisplaySelection();
                    EventDisplayOptions.this.mEventDisplayList.showSelection();
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        Group sizeGroup = new Group(leftPanel, 0);
        sizeGroup.setText("Display Size:");
        sizeGroup.setLayoutData((Object)new GridData(768));
        sizeGroup.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)sizeGroup, 0);
        l.setText("Width:");
        this.mDisplayWidthText = new Text((Composite)sizeGroup, 18436);
        this.mDisplayWidthText.setLayoutData((Object)new GridData(768));
        this.mDisplayWidthText.setText(Integer.toString(store.getInt("EventLogPanel.width")));
        this.mDisplayWidthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = EventDisplayOptions.this.mDisplayWidthText.getText().trim();
                try {
                    store.setValue("EventLogPanel.width", Integer.parseInt(text));
                    EventDisplayOptions.this.setModified();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        l = new Label((Composite)sizeGroup, 0);
        l.setText("Height:");
        this.mDisplayHeightText = new Text((Composite)sizeGroup, 18436);
        this.mDisplayHeightText.setLayoutData((Object)new GridData(768));
        this.mDisplayHeightText.setText(Integer.toString(store.getInt("EventLogPanel.height")));
        this.mDisplayHeightText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = EventDisplayOptions.this.mDisplayHeightText.getText().trim();
                try {
                    store.setValue("EventLogPanel.height", Integer.parseInt(text));
                    EventDisplayOptions.this.setModified();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }

    private void createRightPanel(Composite rightPanel) {
        rightPanel.setLayout((Layout)new GridLayout(1, true));
        rightPanel.setLayoutData((Object)new GridData(1808));
        this.mInfoGroup = new Group(rightPanel, 0);
        this.mInfoGroup.setLayoutData((Object)new GridData(768));
        this.mInfoGroup.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label((Composite)this.mInfoGroup, 16384);
        nameLabel.setText("Name:");
        this.mDisplayNameText = new Text((Composite)this.mInfoGroup, 18436);
        this.mDisplayNameText.setLayoutData((Object)new GridData(768));
        this.mDisplayNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EventDisplay eventDisplay;
                if (EventDisplayOptions.this.mProcessTextChanges && (eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay()) != null) {
                    eventDisplay.setName(EventDisplayOptions.this.mDisplayNameText.getText());
                    int index = EventDisplayOptions.this.mEventDisplayList.getSelectionIndex();
                    EventDisplayOptions.this.mEventDisplayList.remove(index);
                    EventDisplayOptions.this.mEventDisplayList.add(eventDisplay.getName(), index);
                    EventDisplayOptions.this.mEventDisplayList.select(index);
                    EventDisplayOptions.this.handleEventDisplaySelection();
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        Label displayLabel = new Label((Composite)this.mInfoGroup, 16384);
        displayLabel.setText("Type:");
        this.mDisplayTypeCombo = new Combo((Composite)this.mInfoGroup, 12);
        this.mDisplayTypeCombo.setLayoutData((Object)new GridData(768));
        this.mDisplayTypeCombo.add("Log All");
        this.mDisplayTypeCombo.add("Filtered Log");
        this.mDisplayTypeCombo.add("Graph");
        this.mDisplayTypeCombo.add("Sync");
        this.mDisplayTypeCombo.add("Sync Histogram");
        this.mDisplayTypeCombo.add("Sync Performance");
        this.mDisplayTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null && eventDisplay.getDisplayType() != EventDisplayOptions.this.mDisplayTypeCombo.getSelectionIndex()) {
                    EventDisplayOptions.this.setModified();
                    String name = eventDisplay.getName();
                    EventDisplay newEventDisplay = EventDisplay.eventDisplayFactory(EventDisplayOptions.this.mDisplayTypeCombo.getSelectionIndex(), name);
                    EventDisplayOptions.this.setCurrentEventDisplay(newEventDisplay);
                    EventDisplayOptions.this.fillUiWith(newEventDisplay);
                }
            }
        });
        this.mChartOptions = new Group((Composite)this.mInfoGroup, 0);
        this.mChartOptions.setText("Chart Options");
        GridData gd = new GridData(768);
        this.mChartOptions.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.mChartOptions.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)this.mChartOptions, 0);
        l.setText("Time Limit (seconds):");
        this.mTimeLimitText = new Text((Composite)this.mChartOptions, 2048);
        this.mTimeLimitText.setLayoutData((Object)new GridData(768));
        this.mTimeLimitText.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent arg0) {
                String text = EventDisplayOptions.this.mTimeLimitText.getText().trim();
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null) {
                    try {
                        if (text.length() == 0) {
                            eventDisplay.resetChartTimeLimit();
                        } else {
                            eventDisplay.setChartTimeLimit(Long.parseLong(text));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        eventDisplay.resetChartTimeLimit();
                    }
                    finally {
                        EventDisplayOptions.this.setModified();
                    }
                }
            }
        });
        this.mHistOptions = new Group((Composite)this.mInfoGroup, 0);
        this.mHistOptions.setText("Histogram Options");
        GridData gdh = new GridData(768);
        this.mHistOptions.setLayoutData((Object)gdh);
        gdh.horizontalSpan = 2;
        this.mHistOptions.setLayout((Layout)new GridLayout(2, false));
        Label lh = new Label((Composite)this.mHistOptions, 0);
        lh.setText("Histogram width (hours):");
        this.mHistWidthText = new Text((Composite)this.mHistOptions, 2048);
        this.mHistWidthText.setLayoutData((Object)new GridData(768));
        this.mHistWidthText.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent arg0) {
                String text = EventDisplayOptions.this.mHistWidthText.getText().trim();
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null) {
                    try {
                        if (text.length() == 0) {
                            eventDisplay.resetHistWidth();
                        } else {
                            eventDisplay.setHistWidth(Long.parseLong(text));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        eventDisplay.resetHistWidth();
                    }
                    finally {
                        EventDisplayOptions.this.setModified();
                    }
                }
            }
        });
        this.mPidFilterCheckBox = new Button((Composite)this.mInfoGroup, 32);
        this.mPidFilterCheckBox.setText("Enable filtering by pid");
        gd = new GridData(768);
        this.mPidFilterCheckBox.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.mPidFilterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null) {
                    eventDisplay.setPidFiltering(EventDisplayOptions.this.mPidFilterCheckBox.getSelection());
                    EventDisplayOptions.this.mPidText.setEnabled(EventDisplayOptions.this.mPidFilterCheckBox.getSelection());
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        Label pidLabel = new Label((Composite)this.mInfoGroup, 0);
        pidLabel.setText("Pid Filter:");
        pidLabel.setToolTipText("Enter all pids, separated by commas");
        this.mPidText = new Text((Composite)this.mInfoGroup, 2048);
        this.mPidText.setLayoutData((Object)new GridData(768));
        this.mPidText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EventDisplay eventDisplay;
                if (EventDisplayOptions.this.mProcessTextChanges && (eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay()) != null && eventDisplay.getPidFiltering()) {
                    String pidText = EventDisplayOptions.this.mPidText.getText().trim();
                    String[] pids = pidText.split("\\s*,\\s*");
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    for (String pid : pids) {
                        try {
                            list.add(Integer.valueOf(pid));
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                    eventDisplay.setPidFilterList(list);
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        this.mValueSelection = this.createEventSelection(rightPanel, EventDisplay.ValueDisplayDescriptor.class, "Event Value Display");
        this.mOccurrenceSelection = this.createEventSelection(rightPanel, EventDisplay.OccurrenceDisplayDescriptor.class, "Event Occurrence Display");
    }

    private SelectionWidgets createEventSelection(Composite rightPanel, final Class<? extends EventDisplay.OccurrenceDisplayDescriptor> descriptorClass, String groupMessage) {
        Group eventSelectionPanel = new Group(rightPanel, 0);
        eventSelectionPanel.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(2, false);
        eventSelectionPanel.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        eventSelectionPanel.setText(groupMessage);
        final SelectionWidgets widgets = new SelectionWidgets();
        widgets.mList = new List((Composite)eventSelectionPanel, 2564);
        widgets.mList.setLayoutData((Object)new GridData(1808));
        widgets.mList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = widgets.mList.getSelectionIndex();
                if (index != -1) {
                    widgets.mDeleteButton.setEnabled(true);
                    widgets.mEditButton.setEnabled(true);
                } else {
                    widgets.mDeleteButton.setEnabled(false);
                    widgets.mEditButton.setEnabled(false);
                }
            }
        });
        Composite rightControls = new Composite((Composite)eventSelectionPanel, 0);
        rightControls.setLayoutData((Object)new GridData(1040));
        gl = new GridLayout(1, false);
        rightControls.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        widgets.mNewButton = new Button(rightControls, 0x800008);
        widgets.mNewButton.setText("New...");
        widgets.mNewButton.setLayoutData((Object)new GridData(768));
        widgets.mNewButton.setEnabled(false);
        widgets.mNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    EventValueSelector dialog;
                    EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                    if (eventDisplay != null && (dialog = new EventValueSelector(EventDisplayOptions.this.mShell)).open(descriptorClass, EventDisplayOptions.this.mLogParser)) {
                        eventDisplay.addDescriptor(dialog.getDescriptor());
                        EventDisplayOptions.this.fillUiWith(eventDisplay);
                        EventDisplayOptions.this.setModified();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        widgets.mEditButton = new Button(rightControls, 0x800008);
        widgets.mEditButton.setText("Edit...");
        widgets.mEditButton.setLayoutData((Object)new GridData(768));
        widgets.mEditButton.setEnabled(false);
        widgets.mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null && (index = widgets.mList.getSelectionIndex()) != -1) {
                    EventDisplay.OccurrenceDisplayDescriptor descriptor = eventDisplay.getDescriptor(descriptorClass, index);
                    EventValueSelector dialog = new EventValueSelector(EventDisplayOptions.this.mShell);
                    if (dialog.open(descriptor, EventDisplayOptions.this.mLogParser)) {
                        descriptor.replaceWith(dialog.getDescriptor());
                        eventDisplay.updateValueDescriptorCheck();
                        EventDisplayOptions.this.fillUiWith(eventDisplay);
                        widgets.mList.select(index);
                        widgets.mList.notifyListeners(13, null);
                        EventDisplayOptions.this.setModified();
                    }
                }
            }
        });
        widgets.mDeleteButton = new Button(rightControls, 0x800008);
        widgets.mDeleteButton.setLayoutData((Object)new GridData(768));
        widgets.mDeleteButton.setText("Delete");
        widgets.mDeleteButton.setEnabled(false);
        widgets.mDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null && (index = widgets.mList.getSelectionIndex()) != -1) {
                    eventDisplay.removeDescriptor(descriptorClass, index);
                    EventDisplayOptions.this.fillUiWith(eventDisplay);
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        return widgets;
    }

    private void duplicateEventDisplay(ArrayList<EventDisplay> displayList) {
        for (EventDisplay eventDisplay : displayList) {
            this.mDisplayList.add(EventDisplay.clone(eventDisplay));
        }
    }

    private void buildPidList(ArrayList<EventContainer> eventList) {
        this.mPidList = new ArrayList();
        for (EventContainer event : eventList) {
            if (this.mPidList.indexOf(event.pid) != -1) continue;
            this.mPidList.add(event.pid);
        }
    }

    private void setModified() {
        this.mEditStatus = true;
    }

    private void enable(boolean status) {
        this.mEventDisplayDeleteButton.setEnabled(status);
        int selection = this.mEventDisplayList.getSelectionIndex();
        int count = this.mEventDisplayList.getItemCount();
        this.mEventDisplayUpButton.setEnabled(status && selection > 0);
        this.mEventDisplayDownButton.setEnabled(status && selection != -1 && selection < count - 1);
        this.mDisplayNameText.setEnabled(status);
        this.mDisplayTypeCombo.setEnabled(status);
        this.mPidFilterCheckBox.setEnabled(status);
        this.mValueSelection.setEnabled(status);
        this.mOccurrenceSelection.setEnabled(status);
        this.mValueSelection.mNewButton.setEnabled(status);
        this.mOccurrenceSelection.mNewButton.setEnabled(status);
        if (!status) {
            this.mPidText.setEnabled(false);
        }
    }

    private void fillEventDisplayList() {
        for (EventDisplay eventDisplay : this.mDisplayList) {
            this.mEventDisplayList.add(eventDisplay.getName());
        }
    }

    private void createNewEventDisplay() {
        int count = this.mDisplayList.size();
        String name = String.format("display %1$d", count + 1);
        EventDisplay eventDisplay = EventDisplay.eventDisplayFactory(0, name);
        this.mDisplayList.add(eventDisplay);
        this.mEventDisplayList.add(name);
        this.mEventDisplayList.select(count);
        this.handleEventDisplaySelection();
        this.mEventDisplayList.showSelection();
        this.setModified();
    }

    private void deleteEventDisplay() {
        int selection = this.mEventDisplayList.getSelectionIndex();
        if (selection != -1) {
            this.mDisplayList.remove(selection);
            this.mEventDisplayList.remove(selection);
            if (this.mDisplayList.size() < selection) {
                --selection;
            }
            this.mEventDisplayList.select(selection);
            this.handleEventDisplaySelection();
            this.setModified();
        }
    }

    private EventDisplay getCurrentEventDisplay() {
        int selection = this.mEventDisplayList.getSelectionIndex();
        if (selection != -1) {
            return this.mDisplayList.get(selection);
        }
        return null;
    }

    private void setCurrentEventDisplay(EventDisplay eventDisplay) {
        int selection = this.mEventDisplayList.getSelectionIndex();
        if (selection != -1) {
            this.mDisplayList.set(selection, eventDisplay);
        }
    }

    private void handleEventDisplaySelection() {
        EventDisplay eventDisplay = this.getCurrentEventDisplay();
        if (eventDisplay != null) {
            this.enable(true);
            this.fillUiWith(eventDisplay);
        } else {
            this.enable(false);
            this.emptyUi();
        }
    }

    private void emptyUi() {
        this.mDisplayNameText.setText("");
        this.mDisplayTypeCombo.clearSelection();
        this.mValueSelection.mList.removeAll();
        this.mOccurrenceSelection.mList.removeAll();
    }

    private void fillUiWith(EventDisplay eventDisplay) {
        long limit;
        GridData gd;
        this.mProcessTextChanges = false;
        this.mDisplayNameText.setText(eventDisplay.getName());
        int displayMode = eventDisplay.getDisplayType();
        this.mDisplayTypeCombo.select(displayMode);
        if (displayMode == 2) {
            gd = (GridData)this.mChartOptions.getLayoutData();
            gd.exclude = false;
            this.mChartOptions.setVisible(!gd.exclude);
            limit = eventDisplay.getChartTimeLimit();
            if (limit != -1L) {
                this.mTimeLimitText.setText(Long.toString(limit));
            } else {
                this.mTimeLimitText.setText("");
            }
        } else {
            gd = (GridData)this.mChartOptions.getLayoutData();
            gd.exclude = true;
            this.mChartOptions.setVisible(!gd.exclude);
            this.mTimeLimitText.setText("");
        }
        if (displayMode == 4) {
            gd = (GridData)this.mHistOptions.getLayoutData();
            gd.exclude = false;
            this.mHistOptions.setVisible(!gd.exclude);
            limit = eventDisplay.getHistWidth();
            if (limit != -1L) {
                this.mHistWidthText.setText(Long.toString(limit));
            } else {
                this.mHistWidthText.setText("");
            }
        } else {
            gd = (GridData)this.mHistOptions.getLayoutData();
            gd.exclude = true;
            this.mHistOptions.setVisible(!gd.exclude);
            this.mHistWidthText.setText("");
        }
        this.mInfoGroup.layout(true);
        this.mShell.layout(true);
        this.mShell.pack();
        if (eventDisplay.getPidFiltering()) {
            this.mPidFilterCheckBox.setSelection(true);
            this.mPidText.setEnabled(true);
            ArrayList<Integer> list = eventDisplay.getPidFilterList();
            if (list != null) {
                StringBuilder sb = new StringBuilder();
                int count = list.size();
                for (int i = 0; i < count; ++i) {
                    sb.append(list.get(i));
                    if (i >= count - 1) continue;
                    sb.append(", ");
                }
                this.mPidText.setText(sb.toString());
            } else {
                this.mPidText.setText("");
            }
        } else {
            this.mPidFilterCheckBox.setSelection(false);
            this.mPidText.setEnabled(false);
            this.mPidText.setText("");
        }
        this.mProcessTextChanges = true;
        this.mValueSelection.mList.removeAll();
        this.mOccurrenceSelection.mList.removeAll();
        if (eventDisplay.getDisplayType() == 1 || eventDisplay.getDisplayType() == 2) {
            this.mOccurrenceSelection.setEnabled(true);
            this.mValueSelection.setEnabled(true);
            Iterator<EventDisplay.ValueDisplayDescriptor> valueIterator = eventDisplay.getValueDescriptors();
            while (valueIterator.hasNext()) {
                EventDisplay.ValueDisplayDescriptor descriptor = valueIterator.next();
                this.mValueSelection.mList.add(String.format("%1$s: %2$s [%3$s]%4$s", this.mEventTagMap.get(descriptor.eventTag), descriptor.valueName, this.getSeriesLabelDescription(descriptor), this.getFilterDescription(descriptor)));
            }
            Iterator<EventDisplay.OccurrenceDisplayDescriptor> occurrenceIterator = eventDisplay.getOccurrenceDescriptors();
            while (occurrenceIterator.hasNext()) {
                EventDisplay.OccurrenceDisplayDescriptor descriptor = occurrenceIterator.next();
                this.mOccurrenceSelection.mList.add(String.format("%1$s [%2$s]%3$s", this.mEventTagMap.get(descriptor.eventTag), this.getSeriesLabelDescription(descriptor), this.getFilterDescription(descriptor)));
            }
            this.mValueSelection.mList.notifyListeners(13, null);
            this.mOccurrenceSelection.mList.notifyListeners(13, null);
        } else {
            this.mOccurrenceSelection.setEnabled(false);
            this.mValueSelection.setEnabled(false);
        }
    }

    private String getSeriesLabelDescription(EventDisplay.OccurrenceDisplayDescriptor descriptor) {
        if (descriptor.seriesValueIndex != -1) {
            if (descriptor.includePid) {
                return String.format("%1$s + pid", this.mEventDescriptionMap.get(descriptor.eventTag)[descriptor.seriesValueIndex].getName());
            }
            return this.mEventDescriptionMap.get(descriptor.eventTag)[descriptor.seriesValueIndex].getName();
        }
        return "pid";
    }

    private String getFilterDescription(EventDisplay.OccurrenceDisplayDescriptor descriptor) {
        if (descriptor.filterValueIndex != -1) {
            return String.format(" [%1$s %2$s %3$s]", this.mEventDescriptionMap.get(descriptor.eventTag)[descriptor.filterValueIndex].getName(), descriptor.filterCompareMethod.testString(), descriptor.filterValue != null ? descriptor.filterValue.toString() : "?");
        }
        return "";
    }

    private static class SelectionWidgets {
        private List mList;
        private Button mNewButton;
        private Button mEditButton;
        private Button mDeleteButton;

        private SelectionWidgets() {
        }

        private void setEnabled(boolean enable) {
            this.mList.setEnabled(enable);
            this.mNewButton.setEnabled(enable);
            this.mEditButton.setEnabled(enable);
            this.mDeleteButton.setEnabled(enable);
        }
    }
}

