/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenGLTraceAction
implements IWorkbenchWindowActionDelegate {
    private static String sLoadFromFolder = System.getProperty("user.home");

    public void run(IAction iAction) {
        this.openTrace();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    private void openTrace() {
        Shell shell = Display.getDefault().getActiveShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setText("Open Trace File");
        fileDialog.setFilterPath(sLoadFromFolder);
        fileDialog.setFilterExtensions(new String[]{"*.gltrace"});
        String string = fileDialog.open();
        if (string == null || string.trim().length() == 0) {
            return;
        }
        sLoadFromFolder = new File(string).getParent().toString();
        this.openEditorFor(string);
    }

    private void openEditorFor(String string) {
        IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(string));
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditorOnFileStore((IWorkbenchPage)iWorkbenchPage, (IFileStore)iFileStore);
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error opening GL Trace File", (String)("Unexpected error while opening GL Trace file: " + partInitException.getMessage()));
        }
    }
}

