/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.GlTracePlugin;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.liblzf.CLZF;

public class ProtoBufUtils {
    private static ImageData getImageData(GLProtoBuf.GLMessage gLMessage) {
        int n;
        int n2 = gLMessage.getFb().getWidth();
        if (n2 * (n = gLMessage.getFb().getHeight()) == 0) {
            return null;
        }
        byte[] byArray = gLMessage.getFb().getContents(0).toByteArray();
        byte[] byArray2 = new byte[n2 * n * 4];
        int n3 = CLZF.lzf_decompress((byte[])byArray, (int)byArray.length, (byte[])byArray2, (int)byArray2.length);
        assert (n3 == n2 * n * 4) : "Unexpected image size after decompression.";
        int n4 = -16777216;
        int n5 = 0xFF0000;
        int n6 = 65280;
        PaletteData paletteData = new PaletteData(n4, n5, n6);
        ImageData imageData = new ImageData(n2, n, 32, paletteData, 1, byArray2);
        byte[] byArray3 = new byte[n2 * n];
        int n7 = 0;
        while (n7 < n2 * n) {
            byArray3[n7] = byArray2[n7 * 4 + 3];
            ++n7;
        }
        imageData.alphaData = byArray3;
        imageData = imageData.scaledTo(imageData.width, -imageData.height);
        return imageData;
    }

    public static Image getImage(Display display, GLProtoBuf.GLMessage gLMessage) {
        if (!gLMessage.hasFb()) {
            return null;
        }
        ImageData imageData = null;
        try {
            imageData = ProtoBufUtils.getImageData(gLMessage);
        }
        catch (Exception exception) {
            GlTracePlugin.getDefault().logMessage("Unexpected error while retrieving framebuffer image: " + exception);
            return null;
        }
        if (imageData == null) {
            return null;
        }
        return new Image((Device)display, imageData);
    }
}

