/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.editors;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class GLCallGroups {
    public static List<GLCallNode> constructCallHierarchy(GLTrace gLTrace, int n, int n2, int n3) {
        if (gLTrace == null) {
            return Collections.emptyList();
        }
        if (n3 < 0 || n3 > gLTrace.getContexts().size()) {
            return GLCallGroups.flatHierarchy(gLTrace, n, n2);
        }
        List<GLCall> list = gLTrace.getGLCalls();
        Stack<GLTreeNode> stack = new Stack<GLTreeNode>();
        ArrayList<GLCallNode> arrayList = new ArrayList<GLCallNode>();
        int n4 = n;
        while (n4 < n2) {
            GLCall gLCall = list.get(n4);
            if (gLCall.getContextId() == n3) {
                GLCallNode gLCallNode;
                if (gLCall.getFunction() == GLProtoBuf.GLMessage.Function.glPushGroupMarkerEXT) {
                    gLCallNode = new GLTreeNode(gLCall);
                    if (stack.size() > 0) {
                        ((GLTreeNode)stack.peek()).addChild(gLCallNode);
                    } else {
                        arrayList.add(gLCallNode);
                    }
                    stack.push((GLTreeNode)gLCallNode);
                } else if (gLCall.getFunction() == GLProtoBuf.GLMessage.Function.glPopGroupMarkerEXT) {
                    if (stack.size() > 0) {
                        stack.pop();
                    } else {
                        arrayList.add(new GLLeafNode(gLCall));
                    }
                } else {
                    gLCallNode = new GLLeafNode(gLCall);
                    if (stack.size() > 0) {
                        ((GLTreeNode)stack.peek()).addChild(gLCallNode);
                    } else {
                        arrayList.add(gLCallNode);
                    }
                }
            }
            ++n4;
        }
        return arrayList;
    }

    private static List<GLCallNode> flatHierarchy(GLTrace gLTrace, int n, int n2) {
        ArrayList<GLCallNode> arrayList = new ArrayList<GLCallNode>();
        List<GLCall> list = gLTrace.getGLCalls();
        int n3 = n;
        while (n3 < n2) {
            arrayList.add(new GLLeafNode(list.get(n3)));
            ++n3;
        }
        return arrayList;
    }

    public static interface GLCallNode {
        public boolean hasChildren();

        public List<GLCallNode> getChildren();

        public GLCall getCall();

        public GLCallNode getParent();

        public void setParent(GLCallNode var1);
    }

    private static class GLLeafNode
    implements GLCallNode {
        private final GLCall mCall;
        private GLCallNode mParent;

        public GLLeafNode(GLCall gLCall) {
            this.mCall = gLCall;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public List<GLCallNode> getChildren() {
            return null;
        }

        @Override
        public GLCallNode getParent() {
            return this.mParent;
        }

        @Override
        public void setParent(GLCallNode gLCallNode) {
            this.mParent = gLCallNode;
        }

        @Override
        public GLCall getCall() {
            return this.mCall;
        }
    }

    private static class GLTreeNode
    implements GLCallNode {
        private final GLCall mCall;
        private GLCallNode mParent;
        private List<GLCallNode> mGLCallNodes;

        public GLTreeNode(GLCall gLCall) {
            this.mCall = gLCall;
            this.mGLCallNodes = new ArrayList<GLCallNode>();
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public GLCallNode getParent() {
            return this.mParent;
        }

        @Override
        public void setParent(GLCallNode gLCallNode) {
            this.mParent = gLCallNode;
        }

        @Override
        public List<GLCallNode> getChildren() {
            return this.mGLCallNodes;
        }

        public void addChild(GLCallNode gLCallNode) {
            this.mGLCallNodes.add(gLCallNode);
            gLCallNode.setParent(this);
        }

        @Override
        public GLCall getCall() {
            return this.mCall;
        }
    }
}

