/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.GLListProperty;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;

public class ListElementAddTransform
implements IStateTransform {
    private final IGLPropertyAccessor mAccessor;
    private final IGLProperty mElement;

    public ListElementAddTransform(IGLPropertyAccessor iGLPropertyAccessor, IGLProperty iGLProperty) {
        this.mAccessor = iGLPropertyAccessor;
        this.mElement = iGLProperty;
    }

    @Override
    public void apply(IGLProperty iGLProperty) {
        GLListProperty gLListProperty = this.getList(iGLProperty);
        if (gLListProperty != null) {
            gLListProperty.add(this.mElement);
        }
    }

    @Override
    public void revert(IGLProperty iGLProperty) {
        GLListProperty gLListProperty = this.getList(iGLProperty);
        if (gLListProperty != null) {
            gLListProperty.remove(this.mElement);
        }
    }

    @Override
    public IGLProperty getChangedProperty(IGLProperty iGLProperty) {
        return this.getList(iGLProperty);
    }

    private GLListProperty getList(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = iGLProperty;
        if (this.mAccessor != null) {
            iGLProperty2 = this.mAccessor.getProperty(iGLProperty2);
        }
        if (iGLProperty2 instanceof GLListProperty) {
            return (GLListProperty)iGLProperty2;
        }
        return null;
    }
}

