/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AddOnTarget;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PlatformTarget;
import com.android.sdklib.SystemImage;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.repository.LocalSdkParser;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PlatformToolPackage;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;

public class SdkManager {
    private static final boolean DEBUG = System.getenv("SDKMAN_DEBUG") != null;
    public static final String PROP_VERSION_SDK = "ro.build.version.sdk";
    public static final String PROP_VERSION_CODENAME = "ro.build.version.codename";
    public static final String PROP_VERSION_RELEASE = "ro.build.version.release";
    public static final String ADDON_NAME = "name";
    public static final String ADDON_VENDOR = "vendor";
    public static final String ADDON_API = "api";
    public static final String ADDON_DESCRIPTION = "description";
    public static final String ADDON_LIBRARIES = "libraries";
    public static final String ADDON_DEFAULT_SKIN = "skin";
    public static final String ADDON_USB_VENDOR = "usb-vendor";
    public static final String ADDON_REVISION = "revision";
    public static final String ADDON_REVISION_OLD = "version";
    private static final Pattern PATTERN_LIB_DATA = Pattern.compile("^([a-zA-Z0-9._-]+\\.jar);(.*)$", 2);
    private static final Pattern PATTERN_USB_IDS = Pattern.compile("^0x[a-f0-9]{4}$", 2);
    private static final String[] sPlatformContentList = new String[]{"android.jar", "framework.aidl"};
    private static final String ADB_INI_FILE = "adb_usb.ini";
    private static final String ADB_INI_HEADER = "# ANDROID 3RD PARTY USB VENDOR ID LIST -- DO NOT EDIT.\n# USE 'android update adb' TO GENERATE.\n# 1 USB VENDOR ID PER LINE.\n";
    private final String mOsSdkPath;
    private IAndroidTarget[] mTargets = new IAndroidTarget[0];
    private Map<FullRevision, BuildToolInfo> mBuildTools = Maps.newTreeMap();
    private final Map<File, DirInfo> mVisistedDirs = new HashMap<File, DirInfo>();

    protected SdkManager(@NonNull String osSdkPath) {
        this.mOsSdkPath = osSdkPath;
    }

    @Nullable
    public static SdkManager createManager(@NonNull String osSdkPath, @NonNull ILogger log) {
        try {
            SdkManager manager = new SdkManager(osSdkPath);
            manager.reloadSdk(log);
            return manager;
        }
        catch (Throwable throwable) {
            log.error(throwable, "Error parsing the sdk.", new Object[0]);
            return null;
        }
    }

    public void reloadSdk(@NonNull ILogger log) {
        this.mVisistedDirs.clear();
        HashMap buildTools = Maps.newHashMap();
        SdkManager.loadBuildTools(this.mOsSdkPath, buildTools, this.mVisistedDirs, log);
        this.setBuildTools(buildTools);
        BuildToolInfo latestBuildTools = this.getLatestBuildTool();
        if (latestBuildTools == null) {
            String platformToolsVersion = this.getPlatformToolsVersion();
            if (platformToolsVersion == null) {
                log.error(null, "Missing platform-tools", new Object[0]);
            } else {
                FullRevision fullRevision = FullRevision.parseRevision(platformToolsVersion);
                if (fullRevision.compareTo(new FullRevision(17)) < 0) {
                    latestBuildTools = this.getCompatibilityBuildTools(fullRevision);
                }
            }
        }
        ArrayList targets = Lists.newArrayList();
        SdkManager.loadPlatforms(this.mOsSdkPath, targets, this.mVisistedDirs, latestBuildTools, log);
        SdkManager.loadAddOns(this.mOsSdkPath, targets, this.mVisistedDirs, log);
        Collections.sort(targets);
        this.setTargets(targets.toArray(new IAndroidTarget[targets.size()]));
        this.initializeSamplePaths(log);
    }

    private BuildToolInfo getCompatibilityBuildTools(FullRevision fullRevision) {
        File platformTools = new File(this.mOsSdkPath, "platform-tools");
        File platformToolsLib = new File(platformTools, "lib");
        File platformToolsRs = new File(platformTools, "renderscript");
        return new BuildToolInfo(fullRevision, platformTools, new File(platformTools, SdkConstants.FN_AAPT), new File(platformTools, SdkConstants.FN_AIDL), new File(platformTools, SdkConstants.FN_DX), new File(platformToolsLib, "dx.jar"), new File(platformTools, SdkConstants.FN_RENDERSCRIPT), new File(platformToolsRs, "include"), new File(platformToolsRs, "clang-include"), null, null, null, null);
    }

    public boolean hasChanged() {
        return this.hasChanged(null);
    }

    public boolean hasChanged(@Nullable ILogger log) {
        HashSet<File> visited = new HashSet<File>();
        boolean changed = false;
        block0: for (String dirName : new String[]{"platforms", "add-ons", "build-tools"}) {
            File[] subFolders;
            File folder = new File(this.mOsSdkPath, dirName);
            if (!folder.isDirectory() || (subFolders = folder.listFiles()) == null) continue;
            for (File subFolder : subFolders) {
                if (!subFolder.isDirectory()) continue;
                visited.add(subFolder);
                DirInfo dirInfo = this.mVisistedDirs.get(subFolder);
                if (dirInfo == null) {
                    changed = true;
                } else {
                    boolean bl = changed = changed || dirInfo.hasChanged();
                }
                if (!changed) continue;
                String s = "SDK changed due to " + (dirInfo != null ? dirInfo.toString() : subFolder.getPath());
                if (log != null) {
                    log.verbose("%s", new Object[]{s});
                }
                if (!DEBUG) continue block0;
                System.out.println(s);
                continue block0;
            }
        }
        if (!changed) {
            for (File previousDir : this.mVisistedDirs.keySet()) {
                if (visited.contains(previousDir)) continue;
                changed = true;
                String s = String.format("SDK changed: %s removed", previousDir.getPath());
                if (log != null) {
                    log.verbose("%s", new Object[]{s});
                }
                if (!DEBUG) break;
                System.out.println(s);
                break;
            }
        }
        return changed;
    }

    @NonNull
    public String getLocation() {
        return this.mOsSdkPath;
    }

    @NonNull
    public IAndroidTarget[] getTargets() {
        return this.mTargets;
    }

    protected void setTargets(@NonNull IAndroidTarget[] targets) {
        assert (targets != null);
        this.mTargets = targets;
    }

    private void setBuildTools(@NonNull Map<FullRevision, BuildToolInfo> buildTools) {
        assert (buildTools != null);
        this.mBuildTools = buildTools;
    }

    @NonNull
    public Set<FullRevision> getBuildTools() {
        return Collections.unmodifiableSet(this.mBuildTools.keySet());
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        if (this.mBuildTools.isEmpty()) {
            return null;
        }
        FullRevision max = null;
        for (FullRevision r : this.mBuildTools.keySet()) {
            if (max != null && r.compareTo(max) <= 0) continue;
            max = r;
        }
        return this.mBuildTools.get(max);
    }

    @Nullable
    public BuildToolInfo getBuildTool(@Nullable FullRevision revision) {
        return this.mBuildTools.get(revision);
    }

    @Nullable
    public IAndroidTarget getTargetFromHashString(@Nullable String hash) {
        if (hash != null) {
            for (IAndroidTarget target : this.mTargets) {
                if (!hash.equals(target.hashString())) continue;
                return target;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdb() throws AndroidLocation.AndroidLocationException, IOException {
        OutputStreamWriter writer = null;
        try {
            IAndroidTarget[] targets;
            File adbIni = new File(AndroidLocation.getFolder(), ADB_INI_FILE);
            writer = new FileWriter(adbIni);
            HashSet<Integer> set = new HashSet<Integer>();
            for (IAndroidTarget target : targets = this.getTargets()) {
                if (target.getUsbVendorId() == 0) continue;
                set.add(target.getUsbVendorId());
            }
            writer.write(ADB_INI_HEADER);
            for (Integer i : set) {
                writer.write(String.format("0x%04x\n", i));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Deprecated
    @Nullable
    public LayoutlibVersion getMaxLayoutlibVersion() {
        LayoutlibVersion maxVersion = null;
        for (IAndroidTarget target : this.getTargets()) {
            LayoutlibVersion lv;
            if (!(target instanceof PlatformTarget) || (lv = ((PlatformTarget)target).getLayoutlibVersion()) == null || maxVersion != null && lv.compareTo(maxVersion) <= 0) continue;
            maxVersion = lv;
        }
        return maxVersion;
    }

    @NonNull
    public Map<File, String> getExtraSamples() {
        LocalSdkParser parser = new LocalSdkParser();
        Package[] packages = parser.parseSdk(this.mOsSdkPath, this, 1024, new NullTaskMonitor(NullLogger.getLogger()));
        HashMap<File, String> samples = new HashMap<File, String>();
        for (Package pkg : packages) {
            if (!(pkg instanceof ExtraPackage) || !pkg.isLocal()) continue;
            assert (pkg.getArchives() != null && pkg.getArchives().length == 1);
            Archive a = pkg.getArchives()[0];
            assert (a != null);
            File path = new File(a.getLocalOsPath(), "samples");
            if (path.isDirectory()) {
                samples.put(path, pkg.getListDescription());
                continue;
            }
            path = new File(a.getLocalOsPath(), "sample");
            if (!path.isDirectory() || !new File(path, "AndroidManifest.xml").isFile()) continue;
            samples.put(path, pkg.getListDescription());
        }
        return samples;
    }

    @NonNull
    public Map<String, Integer> getExtrasVersions() {
        LocalSdkParser parser = new LocalSdkParser();
        Package[] packages = parser.parseSdk(this.mOsSdkPath, this, 1024, new NullTaskMonitor(NullLogger.getLogger()));
        TreeMap<String, Integer> extraVersions = new TreeMap<String, Integer>();
        for (Package pkg : packages) {
            if (!(pkg instanceof ExtraPackage) || !pkg.isLocal()) continue;
            ExtraPackage ep = (ExtraPackage)pkg;
            String vendor = ep.getVendorId();
            String path = ep.getPath();
            int majorRev = ep.getRevision().getMajor();
            extraVersions.put(vendor + '/' + path, majorRev);
        }
        return extraVersions;
    }

    @Nullable
    public String getPlatformToolsVersion() {
        Package[] packages;
        LocalSdkParser parser = new LocalSdkParser();
        for (Package pkg : packages = parser.parseSdk(this.mOsSdkPath, this, 2, new NullTaskMonitor(NullLogger.getLogger()))) {
            if (!(pkg instanceof PlatformToolPackage) || !pkg.isLocal()) continue;
            return pkg.getRevision().toShortString();
        }
        return null;
    }

    private static void loadPlatforms(@NonNull String sdkOsPath, @NonNull ArrayList<IAndroidTarget> targets, @NonNull Map<File, DirInfo> dirInfos, BuildToolInfo latestBuildTools, @NonNull ILogger log) {
        File platformFolder = new File(sdkOsPath, "platforms");
        if (platformFolder.isDirectory()) {
            File[] platforms = platformFolder.listFiles();
            if (platforms != null) {
                for (File platform : platforms) {
                    if (platform.isDirectory()) {
                        PlatformTarget target = SdkManager.loadPlatform(sdkOsPath, platform, latestBuildTools, log);
                        if (target != null) {
                            targets.add(target);
                        }
                        dirInfos.put(platform, new DirInfo(platform));
                        continue;
                    }
                    log.warning("Ignoring platform '%1$s', not a folder.", new Object[]{platform.getName()});
                }
            }
            return;
        }
        if (!platformFolder.exists()) {
            if (!platformFolder.mkdir()) {
                throw new RuntimeException(String.format("Failed to create %1$s.", platformFolder.getAbsolutePath()));
            }
        } else {
            throw new RuntimeException(String.format("%1$s is not a folder.", platformFolder.getAbsolutePath()));
        }
    }

    @Nullable
    private static PlatformTarget loadPlatform(@NonNull String sdkOsPath, @NonNull File platformFolder, BuildToolInfo latestBuildTools, @NonNull ILogger log) {
        FileWrapper buildProp = new FileWrapper(platformFolder, "build.prop");
        FileWrapper sourcePropFile = new FileWrapper(platformFolder, "source.properties");
        if (buildProp.isFile() && sourcePropFile.isFile()) {
            int apiNumber;
            String stringValue;
            FileWrapper sdkPropFile;
            HashMap<String, String> platformProp = new HashMap<String, String>();
            Map<String, String> map = ProjectProperties.parsePropertyFile((IAbstractFile)buildProp, log);
            if (map != null) {
                platformProp.putAll(map);
            }
            if ((map = ProjectProperties.parsePropertyFile((IAbstractFile)sourcePropFile, log)) != null) {
                platformProp.putAll(map);
            }
            if ((sdkPropFile = new FileWrapper(platformFolder, "sdk.properties")).isFile() && (map = ProjectProperties.parsePropertyFile((IAbstractFile)sdkPropFile, log)) != null) {
                platformProp.putAll(map);
            }
            if ((stringValue = (String)platformProp.get(PROP_VERSION_SDK)) == null) {
                log.warning("Ignoring platform '%1$s': %2$s is missing from '%3$s'", new Object[]{platformFolder.getName(), PROP_VERSION_SDK, "build.prop"});
                return null;
            }
            try {
                apiNumber = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                log.warning("Ignoring platform '%1$s': %2$s is not a valid number in %3$s.", new Object[]{platformFolder.getName(), PROP_VERSION_SDK, "build.prop"});
                return null;
            }
            AndroidVersion apiVersion = new AndroidVersion(apiNumber, (String)platformProp.get(PROP_VERSION_CODENAME));
            String apiName = (String)platformProp.get("Platform.Version");
            if (apiName == null) {
                apiName = (String)platformProp.get(PROP_VERSION_RELEASE);
            }
            if (apiName == null) {
                log.warning("Ignoring platform '%1$s': %2$s is missing from '%3$s'", new Object[]{platformFolder.getName(), PROP_VERSION_RELEASE, "build.prop"});
                return null;
            }
            int revision = 1;
            LayoutlibVersion layoutlibVersion = null;
            try {
                revision = Integer.parseInt((String)platformProp.get("Pkg.Revision"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                int llRev;
                String propApi = (String)platformProp.get("Layoutlib.Api");
                String propRev = (String)platformProp.get("Layoutlib.Revision");
                int llApi = propApi == null ? 0 : Integer.parseInt(propApi);
                int n = llRev = propRev == null ? 0 : Integer.parseInt(propRev);
                if (llApi > 0 && llRev >= 0) {
                    layoutlibVersion = new LayoutlibVersion(llApi, llRev);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (!SdkManager.checkPlatformContent(platformFolder, log)) {
                return null;
            }
            ISystemImage[] systemImages = SdkManager.getPlatformSystemImages(sdkOsPath, platformFolder, apiVersion);
            PlatformTarget target = new PlatformTarget(sdkOsPath, platformFolder.getAbsolutePath(), apiVersion, apiName, revision, layoutlibVersion, systemImages, platformProp, latestBuildTools);
            String[] skins = SdkManager.parseSkinFolder(target.getPath(5));
            target.setSkins(skins);
            return target;
        }
        log.warning("Ignoring platform '%1$s': %2$s is missing.", new Object[]{platformFolder.getName(), "build.prop"});
        return null;
    }

    @NonNull
    private static ISystemImage[] getAddonSystemImages(@NonNull File root) {
        TreeSet<SystemImage> found = new TreeSet<SystemImage>();
        root = new File(root, SdkConstants.OS_IMAGES_FOLDER);
        File[] files = root.listFiles();
        boolean hasImgFiles = false;
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    found.add(new SystemImage(file, ISystemImage.LocationType.IN_PLATFORM_SUBFOLDER, file.getName()));
                    continue;
                }
                if (hasImgFiles || !file.isFile() || !file.getName().endsWith(".img")) continue;
                hasImgFiles = true;
            }
        }
        if (found.size() == 0 && hasImgFiles && root.isDirectory()) {
            found.add(new SystemImage(root, ISystemImage.LocationType.IN_PLATFORM_LEGACY, "armeabi"));
        }
        return found.toArray(new ISystemImage[found.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ISystemImage[] getPlatformSystemImages(@NonNull String sdkOsPath, @NonNull File root, @NonNull AndroidVersion version) {
        TreeSet<SystemImage> found = new TreeSet<SystemImage>();
        HashSet<String> abiFound = new HashSet<String>();
        File[] firstLevelFiles = new File(sdkOsPath, "system-images").listFiles();
        if (firstLevelFiles != null) {
            for (File firstLevel : firstLevelFiles) {
                File[] secondLevelFiles = firstLevel.listFiles();
                if (secondLevelFiles == null) continue;
                for (File secondLevel : secondLevelFiles) {
                    try {
                        String abi;
                        File propFile = new File(secondLevel, "source.properties");
                        Properties props = new Properties();
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(propFile);
                            props.load(fis);
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        AndroidVersion propsVersion = new AndroidVersion(props);
                        if (!propsVersion.equals(version) || (abi = props.getProperty("SystemImage.Abi")) == null || abiFound.contains(abi)) continue;
                        found.add(new SystemImage(secondLevel, ISystemImage.LocationType.IN_SYSTEM_IMAGE, abi));
                        abiFound.add(abi);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
        }
        root = new File(root, SdkConstants.OS_IMAGES_FOLDER);
        File[] files = root.listFiles();
        boolean useLegacy = true;
        boolean hasImgFiles = false;
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    useLegacy = false;
                    String abi = file.getName();
                    if (abiFound.contains(abi)) continue;
                    found.add(new SystemImage(file, ISystemImage.LocationType.IN_PLATFORM_SUBFOLDER, abi));
                    abiFound.add(abi);
                    continue;
                }
                if (hasImgFiles || !file.isFile() || !file.getName().endsWith(".img")) continue;
                hasImgFiles = true;
            }
        }
        if (useLegacy && hasImgFiles && root.isDirectory() && !abiFound.contains("armeabi")) {
            found.add(new SystemImage(root, ISystemImage.LocationType.IN_PLATFORM_LEGACY, "armeabi"));
        }
        return found.toArray(new ISystemImage[found.size()]);
    }

    private static void loadAddOns(@NonNull String osSdkPath, @NonNull ArrayList<IAndroidTarget> targets, @NonNull Map<File, DirInfo> dirInfos, @NonNull ILogger log) {
        File addonFolder = new File(osSdkPath, "add-ons");
        if (addonFolder.isDirectory()) {
            File[] addons = addonFolder.listFiles();
            IAndroidTarget[] targetList = targets.toArray(new IAndroidTarget[targets.size()]);
            if (addons != null) {
                for (File addon : addons) {
                    if (!addon.isDirectory()) continue;
                    AddOnTarget target = SdkManager.loadAddon(addon, targetList, log);
                    if (target != null) {
                        targets.add(target);
                    }
                    dirInfos.put(addon, new DirInfo(addon));
                }
            }
            return;
        }
        if (!addonFolder.exists()) {
            if (!addonFolder.mkdir()) {
                throw new RuntimeException(String.format("Failed to create %1$s.", addonFolder.getAbsolutePath()));
            }
        } else {
            throw new RuntimeException(String.format("%1$s is not a folder.", addonFolder.getAbsolutePath()));
        }
    }

    @Nullable
    private static AddOnTarget loadAddon(@NonNull File addonDir, @NonNull IAndroidTarget[] targetList, @NonNull ILogger log) {
        Pair<Map<String, String>, String> infos = SdkManager.parseAddonProperties(addonDir, targetList, log);
        Map propertyMap = (Map)infos.getFirst();
        String error = (String)infos.getSecond();
        if (error != null) {
            log.warning("Ignoring add-on '%1$s': %2$s", new Object[]{addonDir.getName(), error});
            return null;
        }
        try {
            int usbVendorId;
            String[] libraries;
            assert (propertyMap != null);
            String api = (String)propertyMap.get(ADDON_API);
            String name = (String)propertyMap.get(ADDON_NAME);
            String vendor = (String)propertyMap.get(ADDON_VENDOR);
            assert (api != null);
            assert (name != null);
            assert (vendor != null);
            PlatformTarget baseTarget = null;
            for (IAndroidTarget target : targetList) {
                if (!target.isPlatform() || !target.getVersion().equals(api)) continue;
                baseTarget = (PlatformTarget)target;
                break;
            }
            assert (baseTarget != null);
            String description = (String)propertyMap.get(ADDON_DESCRIPTION);
            int revisionValue = 1;
            String revision = (String)propertyMap.get(ADDON_REVISION);
            if (revision == null) {
                revision = (String)propertyMap.get(ADDON_REVISION_OLD);
            }
            if (revision != null) {
                revisionValue = Integer.parseInt(revision);
            }
            String librariesValue = (String)propertyMap.get(ADDON_LIBRARIES);
            HashMap<String, String[]> libMap = null;
            if (librariesValue != null && (librariesValue = librariesValue.trim()).length() > 0 && (libraries = librariesValue.split(";")).length > 0) {
                libMap = new HashMap<String, String[]>();
                for (String libName : libraries) {
                    String libData = (String)propertyMap.get(libName = libName.trim());
                    if (libData != null) {
                        Matcher m = PATTERN_LIB_DATA.matcher(libData);
                        if (m.matches()) {
                            libMap.put(libName, new String[]{m.group(1), m.group(2)});
                            continue;
                        }
                        log.warning("Ignoring library '%1$s', property value has wrong format\n\t%2$s", new Object[]{libName, libData});
                        continue;
                    }
                    log.warning("Ignoring library '%1$s', missing property value", new Object[]{libName, libData});
                }
            }
            ISystemImage[] systemImages = SdkManager.getAddonSystemImages(addonDir);
            boolean hasRenderingLibrary = false;
            boolean hasRenderingResources = false;
            File dataFolder = new File(addonDir, "data");
            if (dataFolder.isDirectory()) {
                hasRenderingLibrary = new File(dataFolder, "layoutlib.jar").isFile();
                hasRenderingResources = new File(dataFolder, "res").isDirectory() && new File(dataFolder, "fonts").isDirectory();
            }
            AddOnTarget target = new AddOnTarget(addonDir.getAbsolutePath(), name, vendor, revisionValue, description, systemImages, libMap, hasRenderingLibrary, hasRenderingResources, baseTarget);
            String[] skins = SdkManager.parseSkinFolder(target.getPath(5));
            String defaultSkin = (String)propertyMap.get(ADDON_DEFAULT_SKIN);
            if (defaultSkin == null) {
                defaultSkin = skins.length == 1 ? skins[0] : baseTarget.getDefaultSkin();
            }
            if ((usbVendorId = SdkManager.convertId((String)propertyMap.get(ADDON_USB_VENDOR))) != 0) {
                target.setUsbVendorId(usbVendorId);
            }
            target.setSkins(skins, defaultSkin);
            return target;
        }
        catch (Exception e) {
            log.warning("Ignoring add-on '%1$s': error %2$s.", new Object[]{addonDir.getName(), e.toString()});
            return null;
        }
    }

    @NonNull
    public static Pair<Map<String, String>, String> parseAddonProperties(@NonNull File addonDir, @NonNull IAndroidTarget[] targetList, @NonNull ILogger log) {
        String error;
        Map<String, String> propertyMap;
        block5: {
            block10: {
                PlatformTarget baseTarget;
                String api;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                FileWrapper addOnManifest;
                                block4: {
                                    propertyMap = null;
                                    error = null;
                                    addOnManifest = new FileWrapper(addonDir, "manifest.ini");
                                    if (addOnManifest.isFile()) break block4;
                                    error = String.format("File not found: %1$s", "manifest.ini");
                                    break block5;
                                }
                                propertyMap = ProjectProperties.parsePropertyFile((IAbstractFile)addOnManifest, log);
                                if (propertyMap != null) break block6;
                                error = String.format("Failed to parse properties from %1$s", "manifest.ini");
                                break block5;
                            }
                            String name = propertyMap.get(ADDON_NAME);
                            if (name != null) break block7;
                            error = SdkManager.addonManifestWarning(ADDON_NAME);
                            break block5;
                        }
                        String vendor = propertyMap.get(ADDON_VENDOR);
                        if (vendor != null) break block8;
                        error = SdkManager.addonManifestWarning(ADDON_VENDOR);
                        break block5;
                    }
                    api = propertyMap.get(ADDON_API);
                    baseTarget = null;
                    if (api != null) break block9;
                    error = SdkManager.addonManifestWarning(ADDON_API);
                    break block5;
                }
                for (IAndroidTarget target : targetList) {
                    if (!target.isPlatform() || !target.getVersion().equals(api)) continue;
                    baseTarget = (PlatformTarget)target;
                    break;
                }
                if (baseTarget != null) break block10;
                error = String.format("Unable to find base platform with API level '%1$s'", api);
                break block5;
            }
            String revision = propertyMap.get(ADDON_REVISION);
            if (revision == null) {
                revision = propertyMap.get(ADDON_REVISION_OLD);
            }
            if (revision == null) break block5;
            try {
                Integer.parseInt(revision);
            }
            catch (NumberFormatException e) {
                error = String.format("%1$s is not a valid number in %2$s.", ADDON_REVISION, "build.prop");
            }
        }
        return Pair.of(propertyMap, (Object)error);
    }

    private static int convertId(@Nullable String value) {
        if (value != null && value.length() > 0 && PATTERN_USB_IDS.matcher(value).matches()) {
            String v = value.substring(2);
            try {
                return Integer.parseInt(v, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @NonNull
    private static String addonManifestWarning(@NonNull String valueName) {
        return String.format("'%1$s' is missing from %2$s.", valueName, "manifest.ini");
    }

    private static boolean checkPlatformContent(@NonNull File platform, @NonNull ILogger log) {
        for (String relativePath : sPlatformContentList) {
            File f = new File(platform, relativePath);
            if (f.exists()) continue;
            log.warning("Ignoring platform '%1$s': %2$s is missing.", new Object[]{platform.getName(), relativePath});
            return false;
        }
        return true;
    }

    @NonNull
    private static String[] parseSkinFolder(@NonNull String osPath) {
        File skinRootFolder = new File(osPath);
        if (skinRootFolder.isDirectory()) {
            File[] files;
            ArrayList<String> skinList = new ArrayList<String>();
            for (File skinFolder : files = skinRootFolder.listFiles()) {
                File layout;
                if (!skinFolder.isDirectory() || !(layout = new File(skinFolder, "layout")).isFile()) continue;
                skinList.add(skinFolder.getName());
            }
            return skinList.toArray(new String[skinList.size()]);
        }
        return new String[0];
    }

    private void initializeSamplePaths(@NonNull ILogger log) {
        File sampleFolder = new File(this.mOsSdkPath, "samples");
        if (sampleFolder.isDirectory()) {
            File[] platforms;
            block0: for (File platform : platforms = sampleFolder.listFiles()) {
                AndroidVersion version;
                if (!platform.isDirectory() || (version = this.getSamplesVersion(platform, log)) == null) continue;
                for (IAndroidTarget target : this.mTargets) {
                    if (!target.isPlatform() || !target.getVersion().equals(version)) continue;
                    ((PlatformTarget)target).setSamplesPath(platform.getAbsolutePath());
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AndroidVersion getSamplesVersion(@NonNull File folder, @NonNull ILogger log) {
        File sourceProp = new File(folder, "source.properties");
        try {
            Properties p = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sourceProp);
                p.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            return new AndroidVersion(p);
        }
        catch (FileNotFoundException e) {
            log.warning("Ignoring sample '%1$s': does not contain %2$s.", new Object[]{folder.getName(), "source.properties"});
        }
        catch (IOException e) {
            log.warning("Ignoring sample '%1$s': failed reading %2$s.", new Object[]{folder.getName(), "source.properties"});
        }
        catch (AndroidVersion.AndroidVersionException e) {
            log.warning("Ignoring sample '%1$s': no android version found in %2$s.", new Object[]{folder.getName(), "source.properties"});
        }
        return null;
    }

    private static void loadBuildTools(@NonNull String sdkOsPath, @NonNull Map<FullRevision, BuildToolInfo> infos, @NonNull Map<File, DirInfo> dirInfos, @NonNull ILogger log) {
        File buildToolsFolder = new File(sdkOsPath, "build-tools");
        if (buildToolsFolder.isDirectory()) {
            File[] folders = buildToolsFolder.listFiles();
            if (folders != null) {
                for (File subFolder : folders) {
                    if (subFolder.isDirectory()) {
                        BuildToolInfo info = SdkManager.loadBuildTool(sdkOsPath, subFolder, log);
                        if (info != null) {
                            infos.put(info.getRevision(), info);
                        }
                        dirInfos.put(subFolder, new DirInfo(subFolder));
                        continue;
                    }
                    log.warning("Ignoring build-tool '%1$s', not a folder.", new Object[]{subFolder.getName()});
                }
            }
            return;
        }
        if (!buildToolsFolder.exists()) {
            if (!buildToolsFolder.mkdir()) {
                throw new RuntimeException(String.format("Failed to create %1$s.", buildToolsFolder.getAbsolutePath()));
            }
        } else {
            throw new RuntimeException(String.format("%1$s is not a folder.", buildToolsFolder.getAbsolutePath()));
        }
    }

    @Nullable
    private static BuildToolInfo loadBuildTool(@NonNull String sdkOsPath, @NonNull File folder, @NonNull ILogger log) {
        FileOp f = new FileOp();
        File sourcePropFile = new File(folder, "source.properties");
        if (!f.isFile(sourcePropFile)) {
            log.warning("Ignoring build-tool '%1$s': missing file %2$s", new Object[]{folder.getName(), "source.properties"});
        } else {
            Properties props = f.loadProperties(sourcePropFile);
            String revStr = props.getProperty("Pkg.Revision");
            try {
                FullRevision rev = FullRevision.parseRevision(props.getProperty("Pkg.Revision"));
                BuildToolInfo info = new BuildToolInfo(rev, folder);
                return info.isValid(log) ? info : null;
            }
            catch (NumberFormatException e) {
                log.warning("Ignoring build-tool '%1$s': invalid revision '%2$s'", new Object[]{folder.getName(), revStr});
            }
        }
        return null;
    }

    private static class DirInfo {
        @NonNull
        private final File mDir;
        private final long mDirModifiedTS;
        private final long mPropsModifiedTS;
        private final long mPropsChecksum;

        public DirInfo(@NonNull File dir) {
            this.mDir = dir;
            this.mDirModifiedTS = dir.lastModified();
            long propsChecksum = 0L;
            long propsModifiedTS = 0L;
            File props = new File(dir, "source.properties");
            if (props.isFile()) {
                propsModifiedTS = props.lastModified();
                propsChecksum = DirInfo.getFileChecksum(props);
            }
            this.mPropsModifiedTS = propsModifiedTS;
            this.mPropsChecksum = propsChecksum;
        }

        public boolean hasChanged() {
            boolean hadProps;
            if (!this.mDir.isDirectory()) {
                return true;
            }
            if (this.mDirModifiedTS != this.mDir.lastModified()) {
                return true;
            }
            File props = new File(this.mDir, "source.properties");
            boolean bl = hadProps = this.mPropsModifiedTS != 0L;
            if (hadProps != props.isFile()) {
                return true;
            }
            if (hadProps) {
                if (this.mPropsModifiedTS != props.lastModified()) {
                    return true;
                }
                if (this.mPropsChecksum != DirInfo.getFileChecksum(props)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static long getFileChecksum(@NonNull File file) {
            FileInputStream fis = null;
            try {
                int n;
                fis = new FileInputStream(file);
                Adler32 a = new Adler32();
                byte[] buf = new byte[1024];
                while ((n = fis.read(buf)) > 0) {
                    a.update(buf, 0, n);
                }
                long l = a.getValue();
                return l;
            }
            catch (Exception ignore) {
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ignore) {}
            }
            return 0L;
        }

        public String toString() {
            String s = String.format("<DirInfo %1$s TS=%2$d", this.mDir, this.mDirModifiedTS);
            if (this.mPropsModifiedTS != 0L) {
                s = s + String.format(" | Props TS=%1$d, Chksum=%2$s", this.mPropsModifiedTS, this.mPropsChecksum);
            }
            return s + ">";
        }
    }

    public static class LayoutlibVersion
    implements Comparable<LayoutlibVersion> {
        private final int mApi;
        private final int mRevision;
        public static final int NOT_SPECIFIED = 0;

        public LayoutlibVersion(int api, int revision) {
            this.mApi = api;
            this.mRevision = revision;
        }

        public int getApi() {
            return this.mApi;
        }

        public int getRevision() {
            return this.mRevision;
        }

        @Override
        public int compareTo(@NonNull LayoutlibVersion rhs) {
            boolean useRev = this.mRevision > 0 && rhs.mRevision > 0;
            int lhsValue = (this.mApi << 16) + (useRev ? this.mRevision : 0);
            int rhsValue = (rhs.mApi << 16) + (useRev ? rhs.mRevision : 0);
            return lhsValue - rhsValue;
        }
    }
}

