/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms;

import com.android.ddmlib.Log;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LogCatMonitorDialog
extends TitleAreaDialog {
    private static final String TITLE = "Auto Monitor Logcat";
    private static final String DEFAULT_MESSAGE = "Would you like ADT to automatically monitor logcat \noutput for messages from applications in the workspace?";
    private boolean mShouldMonitor = true;
    private static final String[] LOG_PRIORITIES = new String[]{Log.LogLevel.VERBOSE.getStringValue(), Log.LogLevel.DEBUG.getStringValue(), Log.LogLevel.INFO.getStringValue(), Log.LogLevel.WARN.getStringValue(), Log.LogLevel.ERROR.getStringValue(), Log.LogLevel.ASSERT.getStringValue()};
    private static final int ERROR_PRIORITY_INDEX = 4;
    private String mMinimumLogPriority = LOG_PRIORITIES[4];

    public LogCatMonitorDialog(Shell shell) {
        super(shell);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        composite = (Composite)super.createDialogArea(composite);
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = false;
        composite2.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 16);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        button.setText("No, do not monitor logcat output.");
        final Button button2 = new Button(composite2, 16);
        button2.setText("Yes, monitor logcat and display logcat view if there are\nmessages with priority higher than:");
        button2.setSelection(true);
        final Combo combo = new Combo(composite2, 12);
        combo.setItems(LOG_PRIORITIES);
        combo.select(4);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.getSource() == button2) {
                    LogCatMonitorDialog.this.mShouldMonitor = button2.getSelection();
                    combo.setEnabled(LogCatMonitorDialog.this.mShouldMonitor);
                } else if (selectionEvent.getSource() == combo) {
                    LogCatMonitorDialog.this.mMinimumLogPriority = LOG_PRIORITIES[combo.getSelectionIndex()];
                }
            }
        };
        combo.addSelectionListener((SelectionListener)selectionAdapter);
        button2.addSelectionListener((SelectionListener)selectionAdapter);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
    }

    public boolean shouldMonitor() {
        return this.mShouldMonitor;
    }

    public String getMinimumPriority() {
        return this.mMinimumLogPriority;
    }
}

