/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.TestResult;
import com.android.ddmlib.testrunner.TestRunResult;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.kxml2.io.KXmlSerializer;

public class XmlTestRunListener
implements ITestRunListener {
    private static final String LOG_TAG = "XmlResultReporter";
    private static final String TEST_RESULT_FILE_SUFFIX = ".xml";
    private static final String TEST_RESULT_FILE_PREFIX = "test_result_";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_TESTS = "tests";
    private static final String PROPERTIES = "properties";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOSTNAME = "hostname";
    private static final String ns = null;
    private String mHostName = "localhost";
    private File mReportDir = new File(System.getProperty("java.io.tmpdir"));
    private String mReportPath = "";
    private TestRunResult mRunResult = new TestRunResult();

    public void setReportDir(File file) {
        this.mReportDir = file;
    }

    public void setHostName(String hostName) {
        this.mHostName = hostName;
    }

    public TestRunResult getRunResult() {
        return this.mRunResult;
    }

    @Override
    public void testRunStarted(String runName, int numTests) {
        this.mRunResult = new TestRunResult(runName);
    }

    @Override
    public void testStarted(TestIdentifier test) {
        this.mRunResult.reportTestStarted(test);
    }

    @Override
    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        if (status.equals((Object)ITestRunListener.TestFailure.ERROR)) {
            this.mRunResult.reportTestFailure(test, TestResult.TestStatus.ERROR, trace);
        } else {
            this.mRunResult.reportTestFailure(test, TestResult.TestStatus.FAILURE, trace);
        }
        Log.d(LOG_TAG, String.format("%s %s: %s", new Object[]{test, status, trace}));
    }

    @Override
    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        this.mRunResult.reportTestEnded(test, testMetrics);
    }

    @Override
    public void testRunFailed(String errorMessage) {
        this.mRunResult.setRunFailureError(errorMessage);
    }

    @Override
    public void testRunStopped(long arg0) {
    }

    @Override
    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        this.mRunResult.setRunComplete(true);
        this.generateDocument(this.mReportDir, elapsedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDocument(File reportDir, long elapsedTime) {
        String timestamp = this.getTimestamp();
        OutputStream stream = null;
        try {
            stream = this.createOutputResultStream(reportDir);
            KXmlSerializer serializer = new KXmlSerializer();
            serializer.setOutput(stream, "UTF-8");
            serializer.startDocument("UTF-8", null);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            this.printTestResults(serializer, timestamp, elapsedTime);
            serializer.endDocument();
            String msg = String.format("XML test result file generated at %s. Total tests %d, Failed %d, Error %d", this.getAbsoluteReportPath(), this.mRunResult.getNumTests(), this.mRunResult.getNumFailedTests(), this.mRunResult.getNumErrorTests());
            Log.logAndDisplay(Log.LogLevel.INFO, LOG_TAG, msg);
        }
        catch (IOException e) {
            Log.e(LOG_TAG, "Failed to generate report data");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private String getAbsoluteReportPath() {
        return this.mReportPath;
    }

    String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
        TimeZone gmt = TimeZone.getTimeZone("UTC");
        dateFormat.setTimeZone(gmt);
        dateFormat.setLenient(true);
        String timestamp = dateFormat.format(new Date());
        return timestamp;
    }

    protected File getResultFile(File reportDir) throws IOException {
        File reportFile = File.createTempFile(TEST_RESULT_FILE_PREFIX, TEST_RESULT_FILE_SUFFIX, reportDir);
        Log.i(LOG_TAG, String.format("Created xml report file at %s", reportFile.getAbsolutePath()));
        return reportFile;
    }

    OutputStream createOutputResultStream(File reportDir) throws IOException {
        File reportFile = this.getResultFile(reportDir);
        this.mReportPath = reportFile.getAbsolutePath();
        return new BufferedOutputStream(new FileOutputStream(reportFile));
    }

    protected String getTestSuiteName() {
        return this.mRunResult.getName();
    }

    void printTestResults(KXmlSerializer serializer, String timestamp, long elapsedTime) throws IOException {
        serializer.startTag(ns, TESTSUITE);
        String name = this.getTestSuiteName();
        if (name != null) {
            serializer.attribute(ns, ATTR_NAME, name);
        }
        serializer.attribute(ns, ATTR_TESTS, Integer.toString(this.mRunResult.getNumTests()));
        serializer.attribute(ns, ATTR_FAILURES, Integer.toString(this.mRunResult.getNumFailedTests()));
        serializer.attribute(ns, ATTR_ERRORS, Integer.toString(this.mRunResult.getNumErrorTests()));
        serializer.attribute(ns, ATTR_TIME, Double.toString((double)elapsedTime / 1000.0));
        serializer.attribute(ns, TIMESTAMP, timestamp);
        serializer.attribute(ns, HOSTNAME, this.mHostName);
        serializer.startTag(ns, PROPERTIES);
        this.setPropertiesAttributes(serializer, ns);
        serializer.endTag(ns, PROPERTIES);
        Map<TestIdentifier, TestResult> testResults = this.mRunResult.getTestResults();
        for (Map.Entry<TestIdentifier, TestResult> testEntry : testResults.entrySet()) {
            this.print(serializer, testEntry.getKey(), testEntry.getValue());
        }
        serializer.endTag(ns, TESTSUITE);
    }

    protected void setPropertiesAttributes(KXmlSerializer serializer, String namespace) throws IOException {
    }

    protected String getTestName(TestIdentifier testId) {
        return testId.getTestName();
    }

    void print(KXmlSerializer serializer, TestIdentifier testId, TestResult testResult) throws IOException {
        serializer.startTag(ns, TESTCASE);
        serializer.attribute(ns, ATTR_NAME, this.getTestName(testId));
        serializer.attribute(ns, ATTR_CLASSNAME, testId.getClassName());
        long elapsedTimeMs = testResult.getEndTime() - testResult.getStartTime();
        serializer.attribute(ns, ATTR_TIME, Double.toString((double)elapsedTimeMs / 1000.0));
        if (!TestResult.TestStatus.PASSED.equals((Object)testResult.getStatus())) {
            String result = testResult.getStatus().equals((Object)TestResult.TestStatus.FAILURE) ? FAILURE : ERROR;
            serializer.startTag(ns, result);
            String stackText = this.sanitize(testResult.getStackTrace());
            serializer.text(stackText);
            serializer.endTag(ns, result);
        }
        serializer.endTag(ns, TESTCASE);
    }

    private String sanitize(String text) {
        return text.replace("\u0000", "<\\0>");
    }
}

