/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Comment;
import lombok.ast.Identifier;
import lombok.ast.JavadocContainer;
import lombok.ast.ListAccessor;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;
import lombok.ast.TypeMemberMixin;
import lombok.ast.TypeReference;
import lombok.ast.TypeVariable;
import lombok.ast.VariableDefinition;

public class ConstructorDeclaration
extends AbstractNode
implements TypeMember,
JavadocContainer {
    private AbstractNode javadoc = null;
    private AbstractNode modifiers = this.adopt(new Modifiers());
    ListAccessor<TypeVariable, ConstructorDeclaration> typeVariables = ListAccessor.of(this, TypeVariable.class, "ConstructorDeclaration.typeVariables");
    private AbstractNode typeName = this.adopt(new Identifier());
    ListAccessor<VariableDefinition, ConstructorDeclaration> parameters = ListAccessor.of(this, VariableDefinition.class, "ConstructorDeclaration.parameters");
    ListAccessor<TypeReference, ConstructorDeclaration> thrownTypeReferences = ListAccessor.of(this, TypeReference.class, "ConstructorDeclaration.thrownTypeReferences");
    private AbstractNode body = null;

    @Override
    public TypeBody upToTypeBody() {
        if (!(this.getParent() instanceof TypeBody)) {
            return null;
        }
        TypeBody out = (TypeBody)this.getParent();
        if (!out.rawMembers().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public Comment astJavadoc() {
        if (!(this.javadoc instanceof Comment)) {
            return null;
        }
        return (Comment)this.javadoc;
    }

    @Override
    public ConstructorDeclaration astJavadoc(Comment javadoc) {
        return this.rawJavadoc(javadoc);
    }

    @Override
    public Node rawJavadoc() {
        return this.javadoc;
    }

    @Override
    public ConstructorDeclaration rawJavadoc(Node javadoc) {
        if (javadoc == this.javadoc) {
            return this;
        }
        if (javadoc != null) {
            this.adopt((AbstractNode)javadoc);
        }
        if (this.javadoc != null) {
            this.disown(this.javadoc);
        }
        this.javadoc = (AbstractNode)javadoc;
        return this;
    }

    public Modifiers astModifiers() {
        if (!(this.modifiers instanceof Modifiers)) {
            return null;
        }
        return (Modifiers)this.modifiers;
    }

    public ConstructorDeclaration astModifiers(Modifiers modifiers) {
        return this.rawModifiers(modifiers);
    }

    private ConstructorDeclaration rawModifiers(Node modifiers) {
        if (modifiers == this.modifiers) {
            return this;
        }
        if (modifiers != null) {
            this.adopt((AbstractNode)modifiers);
        }
        if (this.modifiers != null) {
            this.disown(this.modifiers);
        }
        this.modifiers = (AbstractNode)modifiers;
        return this;
    }

    public RawListAccessor<TypeVariable, ConstructorDeclaration> rawTypeVariables() {
        return this.typeVariables.asRaw();
    }

    public StrictListAccessor<TypeVariable, ConstructorDeclaration> astTypeVariables() {
        return this.typeVariables.asStrict();
    }

    public Identifier astTypeName() {
        if (!(this.typeName instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.typeName;
    }

    public ConstructorDeclaration astTypeName(Identifier typeName) {
        return this.rawTypeName(typeName);
    }

    private ConstructorDeclaration rawTypeName(Node typeName) {
        if (typeName == this.typeName) {
            return this;
        }
        if (typeName != null) {
            this.adopt((AbstractNode)typeName);
        }
        if (this.typeName != null) {
            this.disown(this.typeName);
        }
        this.typeName = (AbstractNode)typeName;
        return this;
    }

    public RawListAccessor<VariableDefinition, ConstructorDeclaration> rawParameters() {
        return this.parameters.asRaw();
    }

    public StrictListAccessor<VariableDefinition, ConstructorDeclaration> astParameters() {
        return this.parameters.asStrict();
    }

    public RawListAccessor<TypeReference, ConstructorDeclaration> rawThrownTypeReferences() {
        return this.thrownTypeReferences.asRaw();
    }

    public StrictListAccessor<TypeReference, ConstructorDeclaration> astThrownTypeReferences() {
        return this.thrownTypeReferences.asStrict();
    }

    public Block astBody() {
        if (!(this.body instanceof Block)) {
            return null;
        }
        return (Block)this.body;
    }

    public ConstructorDeclaration astBody(Block body) {
        if (body == null) {
            throw new NullPointerException("body is mandatory");
        }
        return this.rawBody(body);
    }

    public Node rawBody() {
        return this.body;
    }

    public ConstructorDeclaration rawBody(Node body) {
        if (body == this.body) {
            return this;
        }
        if (body != null) {
            this.adopt((AbstractNode)body);
        }
        if (this.body != null) {
            this.disown(this.body);
        }
        this.body = (AbstractNode)body;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.javadoc != null) {
            result.add(this.javadoc);
        }
        if (this.modifiers != null) {
            result.add(this.modifiers);
        }
        result.addAll(this.typeVariables.backingList());
        if (this.typeName != null) {
            result.add(this.typeName);
        }
        result.addAll(this.parameters.backingList());
        result.addAll(this.thrownTypeReferences.backingList());
        if (this.body != null) {
            result.add(this.body);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.javadoc == original) {
            this.rawJavadoc(replacement);
            return true;
        }
        if (this.modifiers == original) {
            if (replacement instanceof Modifiers) {
                this.astModifiers((Modifiers)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Modifiers", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.rawTypeVariables().replace(original, replacement)) {
            return true;
        }
        if (this.typeName == original) {
            if (replacement instanceof Identifier) {
                this.astTypeName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.rawParameters().replace(original, replacement)) {
            return true;
        }
        if (this.rawThrownTypeReferences().replace(original, replacement)) {
            return true;
        }
        if (this.body == original) {
            this.rawBody(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.javadoc == child) {
            this.disown((AbstractNode)child);
            this.javadoc = null;
            return true;
        }
        if (this.modifiers == child) {
            this.disown((AbstractNode)child);
            this.modifiers = null;
            return true;
        }
        if (this.rawTypeVariables().remove(child)) {
            return true;
        }
        if (this.typeName == child) {
            this.disown((AbstractNode)child);
            this.typeName = null;
            return true;
        }
        if (this.rawParameters().remove(child)) {
            return true;
        }
        if (this.rawThrownTypeReferences().remove(child)) {
            return true;
        }
        if (this.body == child) {
            this.disown((AbstractNode)child);
            this.body = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitConstructorDeclaration(this)) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.accept(visitor);
        }
        if (this.modifiers != null) {
            this.modifiers.accept(visitor);
        }
        for (AbstractNode child : this.typeVariables.asIterable()) {
            child.accept(visitor);
        }
        if (this.typeName != null) {
            this.typeName.accept(visitor);
        }
        for (AbstractNode child : this.parameters.asIterable()) {
            child.accept(visitor);
        }
        for (AbstractNode child : this.thrownTypeReferences.asIterable()) {
            child.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public ConstructorDeclaration copy() {
        ConstructorDeclaration result = new ConstructorDeclaration();
        if (this.javadoc != null) {
            result.rawJavadoc(this.javadoc.copy());
        }
        if (this.modifiers != null) {
            result.rawModifiers(this.modifiers.copy());
        }
        for (AbstractNode n : this.typeVariables.backingList()) {
            result.rawTypeVariables().addToEnd(n == null ? null : n.copy());
        }
        if (this.typeName != null) {
            result.rawTypeName(this.typeName.copy());
        }
        for (AbstractNode n : this.parameters.backingList()) {
            result.rawParameters().addToEnd(n == null ? null : n.copy());
        }
        for (AbstractNode n : this.thrownTypeReferences.backingList()) {
            result.rawThrownTypeReferences().addToEnd(n == null ? null : n.copy());
        }
        if (this.body != null) {
            result.rawBody(this.body.copy());
        }
        return result;
    }

    public TypeDeclaration upUpToTypeDeclaration() {
        return TypeMemberMixin.upUpToTypeDeclaration(this);
    }
}

