/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.AbstractNode;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.Literal;

public class NullLiteral
extends AbstractNode.WithParens
implements Literal,
Expression {
    private String rawValue = "null";
    private String errorReasonForValue;

    @Override
    public boolean isStatementExpression() {
        return false;
    }

    public String getErrorReasonForValue() {
        return this.errorReasonForValue;
    }

    public NullLiteral rawValue(String raw) {
        if (raw == null) {
            this.rawValue = null;
            this.errorReasonForValue = "Missing value";
        } else {
            this.rawValue = raw;
            String v = raw.trim();
            this.errorReasonForValue = !v.equals("null") ? "Only 'null' is a valid null literal, not: " + v : null;
        }
        return this;
    }

    @Override
    public String rawValue() {
        return this.rawValue;
    }

    public boolean astIsValid() {
        return this.errorReasonForValue == null;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (!visitor.visitNullLiteral(this)) {
            visitor.endVisit(this);
        }
    }

    @Override
    public NullLiteral copy() {
        NullLiteral result = new NullLiteral();
        result.rawValue = this.rawValue;
        result.errorReasonForValue = this.errorReasonForValue;
        return result;
    }
}

