/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeReference;

public class Super
extends AbstractNode
implements Expression {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode qualifier = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public TypeReference astQualifier() {
        if (!(this.qualifier instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.qualifier;
    }

    public Super astQualifier(TypeReference qualifier) {
        return this.rawQualifier(qualifier);
    }

    public Node rawQualifier() {
        return this.qualifier;
    }

    public Super rawQualifier(Node qualifier) {
        if (qualifier == this.qualifier) {
            return this;
        }
        if (qualifier != null) {
            this.adopt((AbstractNode)qualifier);
        }
        if (this.qualifier != null) {
            this.disown(this.qualifier);
        }
        this.qualifier = (AbstractNode)qualifier;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.qualifier != null) {
            result.add(this.qualifier);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.qualifier == original) {
            this.rawQualifier(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.qualifier == child) {
            this.disown((AbstractNode)child);
            this.qualifier = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitSuper(this)) {
            return;
        }
        if (this.qualifier != null) {
            this.qualifier.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public Super copy() {
        Super result = new Super();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.qualifier != null) {
            result.rawQualifier(this.qualifier.copy());
        }
        return result;
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean needsParentheses() {
        return ExpressionMixin.needsParentheses(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

