/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled;

import java.util.List;
import lombok.ast.libs.org.parboiled.Node;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.trees.ImmutableTreeNode;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeImpl<V>
extends ImmutableTreeNode<Node<V>>
implements Node<V> {
    private final Matcher<V> matcher;
    private final int startIndex;
    private final int endIndex;
    private final V value;
    private final boolean hasError;

    public NodeImpl(@NotNull Matcher<V> matcher, List<Node<V>> children, int startIndex, int endIndex, V value, boolean hasError) {
        if (matcher == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.NodeImpl.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        super(children);
        this.matcher = matcher;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.value = value;
        this.hasError = hasError;
    }

    @Override
    @NotNull
    public Matcher<V> getMatcher() {
        Matcher<V> matcher = this.matcher;
        if (matcher == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.NodeImpl.getMatcher must not return null");
        }
        return matcher;
    }

    @Override
    public String getLabel() {
        return this.matcher.getLabel();
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.getLabel());
        if (this.value != null) {
            sb.append(", {").append(this.value).append('}');
        }
        sb.append(']');
        if (this.hasError) {
            sb.append('E');
        }
        return StringUtils.escape(sb.toString());
    }
}

