/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.support;

import java.util.Arrays;
import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.common.Utils;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatcherPath<V> {
    private final Matcher[] matchers;

    public MatcherPath(@NotNull MatcherContext<V> context) {
        if (context == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.MatcherPath.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this(context.getLevel() + 1);
        while (context != null) {
            this.matchers[context.getLevel()] = context.getMatcher();
            context = context.getParent();
        }
    }

    private MatcherPath(int length) {
        this.matchers = new Matcher[length];
    }

    public int length() {
        return this.matchers.length;
    }

    public Matcher<V> get(int i) {
        Preconditions.checkElementIndex(i, this.matchers.length);
        return this.matchers[i];
    }

    public Matcher<V> getHead() {
        return this.matchers[this.matchers.length - 1];
    }

    public int getCommonPrefixLength(MatcherPath<V> other) {
        if (other == null) {
            return 0;
        }
        for (int i = 0; i < this.matchers.length; ++i) {
            if (other.length() != i && this.matchers[i] == other.get(i)) continue;
            return i;
        }
        return this.matchers.length;
    }

    public boolean contains(Matcher<V> matcher) {
        return this.indexOf(matcher) != -1;
    }

    public int indexOf(Matcher<V> matcher) {
        for (int i = 0; i < this.matchers.length; ++i) {
            if (this.matchers[i] != matcher) continue;
            return i;
        }
        return -1;
    }

    public boolean isPrefixOf(MatcherPath<V> other) {
        return this.getCommonPrefixLength(other) == this.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatcherPath)) {
            return false;
        }
        MatcherPath that = (MatcherPath)o;
        return Arrays.equals(this.matchers, that.matchers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.matchers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Utils.toString(this.matchers[0]));
        for (int i = 1; i < this.matchers.length; ++i) {
            sb.append('/');
            sb.append(this.matchers[i]);
        }
        return sb.toString();
    }
}

