/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.ast.libs.org.parboiled.BaseParser;
import lombok.ast.libs.org.parboiled.Capture;
import lombok.ast.libs.org.parboiled.ContextAware;
import lombok.ast.libs.org.parboiled.Rule;
import lombok.ast.libs.org.parboiled.asm.ClassReader;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.InsnList;
import lombok.ast.libs.org.parboiled.asm.tree.MethodInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.VarInsnNode;
import lombok.ast.libs.org.parboiled.support.Var;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsmUtils {
    private static final ConcurrentMap<String, Class<?>> classForDesc = new ConcurrentHashMap();

    AsmUtils() {
    }

    public static ClassReader createClassReader(@NotNull Class<?> clazz) throws IOException {
        if (clazz == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.createClassReader(...) corresponds to @NotNull parameter and must not be null");
        }
        String classFilename = clazz.getName().replace('.', '/') + ".class";
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(classFilename);
        return new ClassReader(inputStream);
    }

    public static String getExtendedParserClassName(@NotNull String parserClassName) {
        if (parserClassName == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.getExtendedParserClassName(...) corresponds to @NotNull parameter and must not be null");
        }
        return parserClassName + "$$parboiled";
    }

    public static Class<?> getClassForInternalName(@NotNull String classDesc) {
        if (classDesc == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.getClassForInternalName(...) corresponds to @NotNull parameter and must not be null");
        }
        Class<?> clazz = (Class<?>)classForDesc.get(classDesc);
        if (clazz == null) {
            String className = classDesc.replace('/', '.');
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error loading class '" + className + "' for rule method analysis", e);
            }
            classForDesc.put(classDesc, clazz);
        }
        return clazz;
    }

    public static Class<?> getClassForType(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.getClassForType(...) corresponds to @NotNull parameter and must not be null");
        }
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
            case 9: 
            case 10: {
                return AsmUtils.getClassForInternalName(type.getInternalName());
            }
        }
        throw new IllegalStateException();
    }

    public static Field getClassField(@NotNull String classInternalName, @NotNull String fieldName) {
        Class<?> clazz;
        if (classInternalName == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.getClassField(...) corresponds to @NotNull parameter and must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.getClassField(...) corresponds to @NotNull parameter and must not be null");
        }
        Class<?> current = clazz = AsmUtils.getClassForInternalName(classInternalName);
        while (true) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (!Object.class.equals(current = current.getSuperclass())) continue;
                throw new RuntimeException("Field '" + fieldName + "' not found in '" + clazz + "' or any superclass", e);
            }
            break;
        }
    }

    public static Method getClassMethod(@NotNull String classInternalName, @NotNull String methodName, @NotNull String methodDesc) {
        if (classInternalName == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.getClassMethod(...) corresponds to @NotNull parameter and must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.getClassMethod(...) corresponds to @NotNull parameter and must not be null");
        }
        if (methodDesc == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.transform.AsmUtils.getClassMethod(...) corresponds to @NotNull parameter and must not be null");
        }
        Class<?> clazz = AsmUtils.getClassForInternalName(classInternalName);
        Type[] types = Type.getArgumentTypes(methodDesc);
        Class[] argTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = AsmUtils.getClassForType(types[i]);
        }
        Class<?> current = clazz;
        while (true) {
            try {
                return current.getDeclaredMethod(methodName, argTypes);
            }
            catch (NoSuchMethodException e) {
                if (!Object.class.equals(current = current.getSuperclass())) continue;
                throw new RuntimeException("Method '" + methodName + "' with descriptor '" + methodDesc + "' not found in '" + clazz + "' or any superclass", e);
            }
            break;
        }
    }

    public static Constructor getClassConstructor(@NotNull String classInternalName, @NotNull String constructorDesc) {
        if (classInternalName == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.getClassConstructor(...) corresponds to @NotNull parameter and must not be null");
        }
        if (constructorDesc == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.getClassConstructor(...) corresponds to @NotNull parameter and must not be null");
        }
        Class<?> clazz = AsmUtils.getClassForInternalName(classInternalName);
        Type[] types = Type.getArgumentTypes(constructorDesc);
        Class[] argTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = AsmUtils.getClassForType(types[i]);
        }
        try {
            return clazz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Constructor with descriptor '" + constructorDesc + "' not found in '" + clazz, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findLoadedClass(@NotNull String string, @NotNull ClassLoader classLoader) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.findLoadedClass(...) corresponds to @NotNull parameter and must not be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.findLoadedClass(...) corresponds to @NotNull parameter and must not be null");
        }
        Class<?> clazz = Class.forName("java.lang.ClassLoader");
        Method method = clazz.getDeclaredMethod("findLoadedClass", String.class);
        method.setAccessible(true);
        try {
            Class clazz2 = (Class)method.invoke((Object)classLoader, string);
            method.setAccessible(false);
            return clazz2;
        }
        catch (Throwable throwable) {
            try {
                method.setAccessible(false);
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not determine whether class '" + string + "' has already been loaded", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadClass(@NotNull String string, @NotNull byte[] byArray, @NotNull ClassLoader classLoader) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.loadClass(...) corresponds to @NotNull parameter and must not be null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.loadClass(...) corresponds to @NotNull parameter and must not be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.transform.AsmUtils.loadClass(...) corresponds to @NotNull parameter and must not be null");
        }
        Class<?> clazz = Class.forName("java.lang.ClassLoader");
        Method method = clazz.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        try {
            Class clazz2 = (Class)method.invoke((Object)classLoader, string, byArray, 0, byArray.length);
            method.setAccessible(false);
            return clazz2;
        }
        catch (Throwable throwable) {
            try {
                method.setAccessible(false);
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not load class '" + string + '\'', exception);
            }
        }
    }

    public static InsnList createArgumentLoaders(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.createArgumentLoaders(...) corresponds to @NotNull parameter and must not be null");
        }
        InsnList insnList = new InsnList();
        Type[] typeArray = Type.getArgumentTypes(string);
        for (int i = 0; i < typeArray.length; ++i) {
            insnList.add(new VarInsnNode(AsmUtils.getLoadingOpcode(typeArray[i]), i + 1));
        }
        return insnList;
    }

    public static int getLoadingOpcode(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.getLoadingOpcode(...) corresponds to @NotNull parameter and must not be null");
        }
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 21;
            }
            case 8: {
                return 24;
            }
            case 6: {
                return 23;
            }
            case 7: {
                return 22;
            }
            case 9: 
            case 10: {
                return 25;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean isAssignableTo(@NotNull String string, @NotNull Class<?> clazz) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isAssignableTo(...) corresponds to @NotNull parameter and must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.isAssignableTo(...) corresponds to @NotNull parameter and must not be null");
        }
        return clazz.isAssignableFrom(AsmUtils.getClassForInternalName(string));
    }

    public static boolean isBooleanValueOfZ(@NotNull AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isBooleanValueOfZ(...) corresponds to @NotNull parameter and must not be null");
        }
        if (abstractInsnNode.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isBooleanValueOfZ(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc);
    }

    public static boolean isBooleanValueOfZ(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isBooleanValueOfZ(...) corresponds to @NotNull parameter and must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.isBooleanValueOfZ(...) corresponds to @NotNull parameter and must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.transform.AsmUtils.isBooleanValueOfZ(...) corresponds to @NotNull parameter and must not be null");
        }
        return "java/lang/Boolean".equals(string) && "valueOf".equals(string2) && "(Z)Ljava/lang/Boolean;".equals(string3);
    }

    public static boolean isActionRoot(@NotNull AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isActionRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        if (abstractInsnNode.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isActionRoot(methodInsnNode.owner, methodInsnNode.name);
    }

    public static boolean isActionRoot(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isActionRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.isActionRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        return "ACTION".equals(string2) && AsmUtils.isAssignableTo(string, BaseParser.class);
    }

    public static boolean isCaptureRoot(@NotNull AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isCaptureRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        if (abstractInsnNode.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isCaptureRoot(methodInsnNode.owner, methodInsnNode.name);
    }

    public static boolean isCaptureRoot(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isCaptureRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.isCaptureRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        return "CAPTURE".equals(string2) && AsmUtils.isAssignableTo(string, BaseParser.class);
    }

    public static boolean isVarRoot(@NotNull AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isVarRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        if (abstractInsnNode.getOpcode() != 183) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isVarRoot(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc);
    }

    public static boolean isVarRoot(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isVarRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.isVarRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.transform.AsmUtils.isVarRoot(...) corresponds to @NotNull parameter and must not be null");
        }
        return "<init>".equals(string2) && "(Ljava/lang/Object;)V".equals(string3) && AsmUtils.isAssignableTo(string, Var.class);
    }

    public static boolean isContextSwitch(@NotNull AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isContextSwitch(...) corresponds to @NotNull parameter and must not be null");
        }
        if (abstractInsnNode.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isContextSwitch(methodInsnNode.owner, methodInsnNode.name);
    }

    public static boolean isContextSwitch(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isContextSwitch(...) corresponds to @NotNull parameter and must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.AsmUtils.isContextSwitch(...) corresponds to @NotNull parameter and must not be null");
        }
        return AsmUtils.isAssignableTo(string, BaseParser.class) && "UP/UP2/UP3/UP4/UP5/UP6/DOWN/DOWN2/DOWN3/DOWN4/DOWN5/DOWN6".contains(string2);
    }

    public static boolean isCallOnContextAware(@NotNull AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isCallOnContextAware(...) corresponds to @NotNull parameter and must not be null");
        }
        if (abstractInsnNode.getOpcode() != 182 && abstractInsnNode.getOpcode() != 185) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isAssignableTo(methodInsnNode.owner, ContextAware.class);
    }

    public static boolean isCaptureGet(@NotNull AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isCaptureGet(...) corresponds to @NotNull parameter and must not be null");
        }
        if (abstractInsnNode.getOpcode() != 182 && abstractInsnNode.getOpcode() != 185) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return "get".equals(methodInsnNode.name) && "()Ljava/lang/Object;".equals(methodInsnNode.desc) && AsmUtils.isAssignableTo(methodInsnNode.owner, Capture.class);
    }

    public static boolean isCallToRuleCreationMethod(@NotNull AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.AsmUtils.isCallToRuleCreationMethod(...) corresponds to @NotNull parameter and must not be null");
        }
        if (abstractInsnNode.getType() != 5) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        Type type = Type.getReturnType(methodInsnNode.desc);
        return type.getSort() == 10 && AsmUtils.isAssignableTo(type.getInternalName(), Rule.class);
    }
}

