/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.FieldInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.FieldNode;
import lombok.ast.libs.org.parboiled.asm.tree.InsnList;
import lombok.ast.libs.org.parboiled.asm.tree.InsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.IntInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.JumpInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.LabelNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.TypeInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.VarInsnNode;
import lombok.ast.libs.org.parboiled.common.Utils;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import lombok.ast.libs.org.parboiled.transform.Types;
import org.jetbrains.annotations.NotNull;

class CachingGenerator
implements Opcodes,
RuleMethodProcessor,
Types {
    private ParserClassNode classNode;
    private RuleMethod method;
    private InsnList instructions;
    private AbstractInsnNode current;
    private String cacheFieldName;

    CachingGenerator() {
    }

    public boolean appliesTo(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.CachingGenerator.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.CachingGenerator.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        return method.hasCachedAnnotation();
    }

    public void process(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) throws Exception {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.CachingGenerator.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.CachingGenerator.process(...) corresponds to @NotNull parameter and must not be null");
        }
        Preconditions.checkState(!method.isSuperMethod());
        this.classNode = classNode;
        this.method = method;
        this.instructions = method.instructions;
        this.current = this.instructions.getFirst();
        this.generateCacheHitReturn();
        this.generateStoreNewProxyMatcher();
        this.seekToReturnInstruction();
        this.generateArmProxyMatcher();
        this.generateStoreInCache();
    }

    private void generateCacheHitReturn() {
        this.generateGetFromCache();
        this.insert(new InsnNode(89));
        LabelNode cacheMissLabel = new LabelNode();
        this.insert(new JumpInsnNode(198, cacheMissLabel));
        this.insert(new InsnNode(176));
        this.insert(cacheMissLabel);
        this.insert(new InsnNode(87));
    }

    private void generateGetFromCache() {
        Type[] paramTypes = Type.getArgumentTypes(this.method.desc);
        this.cacheFieldName = this.findUnusedCacheFieldName();
        String cacheFieldDesc = paramTypes.length == 0 ? RULE_DESC : "Ljava/util/HashMap;";
        this.classNode.fields.add(new FieldNode(2, this.cacheFieldName, cacheFieldDesc, null, null));
        this.insert(new VarInsnNode(25, 0));
        this.insert(new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, cacheFieldDesc));
        if (paramTypes.length == 0) {
            return;
        }
        this.insert(new InsnNode(89));
        LabelNode alreadyInitialized = new LabelNode();
        this.insert(new JumpInsnNode(199, alreadyInitialized));
        this.insert(new InsnNode(87));
        this.insert(new VarInsnNode(25, 0));
        this.insert(new TypeInsnNode(187, "java/util/HashMap"));
        this.insert(new InsnNode(90));
        this.insert(new InsnNode(89));
        this.insert(new MethodInsnNode(183, "java/util/HashMap", "<init>", "()V"));
        this.insert(new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, cacheFieldDesc));
        this.insert(alreadyInitialized);
        if (paramTypes.length > 1 || paramTypes[0].getSort() == 9) {
            String arguments = Type.getInternalName(Arguments.class);
            this.insert(new TypeInsnNode(187, arguments));
            this.insert(new InsnNode(89));
            this.generatePushNewParameterObjectArray(paramTypes);
            this.insert(new MethodInsnNode(183, arguments, "<init>", "([Ljava/lang/Object;)V"));
        } else {
            this.generatePushParameterAsObject(paramTypes, 0);
        }
        this.insert(new InsnNode(89));
        this.insert(new VarInsnNode(58, this.method.maxLocals));
        this.insert(new MethodInsnNode(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;"));
        this.insert(new TypeInsnNode(192, RULE.getInternalName()));
    }

    private String findUnusedCacheFieldName() {
        String name = "cache$" + this.method.name;
        int i = 2;
        while (this.hasField(name)) {
            name = "cache$" + this.method.name + i++;
        }
        return name;
    }

    public boolean hasField(String fieldName) {
        for (Object field : this.classNode.fields) {
            if (!fieldName.equals(((FieldNode)field).name)) continue;
            return true;
        }
        return false;
    }

    private void generatePushNewParameterObjectArray(Type[] typeArray) {
        this.insert(new IntInsnNode(16, typeArray.length));
        this.insert(new TypeInsnNode(189, "java/lang/Object"));
        for (int i = 0; i < typeArray.length; ++i) {
            this.insert(new InsnNode(89));
            this.insert(new IntInsnNode(16, i));
            this.generatePushParameterAsObject(typeArray, i);
            this.insert(new InsnNode(83));
        }
    }

    private void generatePushParameterAsObject(Type[] typeArray, int n) {
        switch (typeArray[n++].getSort()) {
            case 1: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;"));
                return;
            }
            case 2: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;"));
                return;
            }
            case 3: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
                return;
            }
            case 4: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;"));
                return;
            }
            case 5: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;"));
                return;
            }
            case 6: {
                this.insert(new VarInsnNode(23, n));
                this.insert(new MethodInsnNode(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;"));
                return;
            }
            case 7: {
                this.insert(new VarInsnNode(22, n));
                this.insert(new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;"));
                return;
            }
            case 8: {
                this.insert(new VarInsnNode(24, n));
                this.insert(new MethodInsnNode(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;"));
                return;
            }
            case 9: 
            case 10: {
                this.insert(new VarInsnNode(25, n));
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void generateStoreNewProxyMatcher() {
        String proxyMatcherType = PROXY_MATCHER.getInternalName();
        this.insert(new TypeInsnNode(187, proxyMatcherType));
        this.insert(new InsnNode(89));
        this.insert(new MethodInsnNode(183, proxyMatcherType, "<init>", "()V"));
        this.generateStoreInCache();
    }

    private void seekToReturnInstruction() {
        while (this.current.getOpcode() != 176) {
            this.current = this.current.getNext();
        }
    }

    private void generateArmProxyMatcher() {
        String string = PROXY_MATCHER.getInternalName();
        this.insert(new InsnNode(90));
        this.insert(new TypeInsnNode(192, MATCHER.getInternalName()));
        this.insert(new MethodInsnNode(182, string, "arm", '(' + MATCHER_DESC + ")V"));
    }

    private void generateStoreInCache() {
        Type[] typeArray = Type.getArgumentTypes(this.method.desc);
        this.insert(new InsnNode(89));
        if (typeArray.length == 0) {
            this.insert(new VarInsnNode(25, 0));
            this.insert(new InsnNode(95));
            this.insert(new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, RULE_DESC));
            return;
        }
        this.insert(new VarInsnNode(25, this.method.maxLocals));
        this.insert(new InsnNode(95));
        this.insert(new VarInsnNode(25, 0));
        this.insert(new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, "Ljava/util/HashMap;"));
        this.insert(new InsnNode(91));
        this.insert(new InsnNode(87));
        this.insert(new MethodInsnNode(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"));
        this.insert(new InsnNode(87));
    }

    private void insert(AbstractInsnNode instruction) {
        this.instructions.insertBefore(this.current, instruction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Arguments {
        private final Object[] params;

        public Arguments(Object[] params) {
            ArrayList<Object> list = new ArrayList<Object>();
            this.unroll(params, list);
            this.params = list.toArray();
        }

        private void unroll(Object[] params, List<Object> list) {
            block11: for (Object param : params) {
                if (param != null && param.getClass().isArray()) {
                    switch (Type.getType(param.getClass().getComponentType()).getSort()) {
                        case 1: {
                            this.unroll(Utils.toObjectArray((boolean[])param), list);
                            continue block11;
                        }
                        case 3: {
                            this.unroll(Utils.toObjectArray((byte[])param), list);
                            continue block11;
                        }
                        case 2: {
                            this.unroll(Utils.toObjectArray((char[])param), list);
                            continue block11;
                        }
                        case 8: {
                            this.unroll(Utils.toObjectArray((double[])param), list);
                            continue block11;
                        }
                        case 6: {
                            this.unroll(Utils.toObjectArray((float[])param), list);
                            continue block11;
                        }
                        case 5: {
                            this.unroll(Utils.toObjectArray((int[])param), list);
                            continue block11;
                        }
                        case 7: {
                            this.unroll(Utils.toObjectArray((long[])param), list);
                            continue block11;
                        }
                        case 4: {
                            this.unroll(Utils.toObjectArray((short[])param), list);
                            continue block11;
                        }
                        case 9: 
                        case 10: {
                            this.unroll((Object[])param, list);
                            continue block11;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                list.add(param);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments that = (Arguments)o;
            return Arrays.equals(this.params, that.params);
        }

        public int hashCode() {
            return this.params != null ? Arrays.hashCode(this.params) : 0;
        }
    }
}

