/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DebugPortManager;
import com.android.ddmlib.Log;
import com.android.ddms.DebugPortProvider;
import com.android.ddms.PrefsDialog;
import com.android.ddms.UIThread;
import com.android.sdkstats.SdkStatsService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Main {
    public static String sRevision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String ddmsParentLocation;
        if (Main.isMac()) {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            System.setProperty("JAVA_STARTED_ON_FIRST_THREAD_" + rt.getName().split("@")[0], "1");
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        PrefsDialog.init();
        Log.d((String)"ddms", (String)"Initializing");
        Display.setAppName((String)"DDMS");
        Shell shell = new Shell(Display.getDefault());
        SdkStatsService stats = new SdkStatsService();
        stats.checkUserPermissionForPing(shell);
        if (args.length >= 3 && args[0].equals("ping")) {
            stats.ping(args);
            return;
        }
        if (args.length > 0) {
            Log.e((String)"ddms", (String)("Unknown argument: " + args[0]));
            System.exit(1);
        }
        if ((ddmsParentLocation = System.getProperty("com.android.ddms.bindir")) == null) {
            ddmsParentLocation = System.getenv("com.android.ddms.bindir");
        }
        Main.ping(stats, ddmsParentLocation);
        stats = null;
        DebugPortManager.setProvider((DebugPortManager.IDebugPortProvider)DebugPortProvider.getInstance());
        UIThread ui = UIThread.getInstance();
        try {
            ui.runUI(ddmsParentLocation);
        }
        finally {
            PrefsDialog.save();
            AndroidDebugBridge.terminate();
        }
        Log.d((String)"ddms", (String)"Bye");
        System.exit(0);
    }

    static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ping(SdkStatsService stats, String ddmsParentLocation) {
        Properties p = new Properties();
        try {
            File sourceProp = ddmsParentLocation != null && ddmsParentLocation.length() > 0 ? new File(ddmsParentLocation, "source.properties") : new File("source.properties");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sourceProp);
                p.load(fis);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            sRevision = p.getProperty("Pkg.Revision");
            if (sRevision != null && sRevision.length() > 0) {
                stats.ping("ddms", sRevision);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Log.e((String)"ddms", (String)"shutting down due to uncaught exception");
            Log.e((String)"ddms", (Throwable)e);
            System.exit(1);
        }
    }
}

