/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum KeyboardState implements ResourceEnum
{
    EXPOSED("keysexposed", "Exposed", "Exposed keyboard"),
    HIDDEN("keyshidden", "Hidden", "Hidden keyboard"),
    SOFT("keyssoft", "Soft", "Soft keyboard");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private KeyboardState(String value, String shortDisplayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = shortDisplayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static KeyboardState getEnum(String value) {
        for (KeyboardState state : KeyboardState.values()) {
            if (!state.mValue.equals(value)) continue;
            return state;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(KeyboardState value) {
        int i = 0;
        for (KeyboardState input : KeyboardState.values()) {
            if (value == input) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static KeyboardState getByIndex(int index) {
        int i = 0;
        for (KeyboardState value : KeyboardState.values()) {
            if (i == index) {
                return value;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

